/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.common;

import java.util.LinkedList;

public class GenericEventQueue {
    private LinkedList queue = new LinkedList();
    private EventThread eventThread;

    public GenericEventQueue(String queueTitle) {
        this(queueTitle, Thread.currentThread().getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericEventQueue(String queueTitle, int priority) {
        this.eventThread = new EventThread(queueTitle);
        this.eventThread.setPriority(priority);
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.eventThread.start();
            try {
                this.queue.wait(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void close() {
        this.eventThread.close();
    }

    public void postEvent(Runnable runnable) {
        this.eventThread.postEvent(runnable);
    }

    private class EventThread
    extends Thread {
        private boolean run = true;

        public EventThread(String title) {
            super(title);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            LinkedList linkedList = GenericEventQueue.this.queue;
            synchronized (linkedList) {
                this.run = false;
                GenericEventQueue.this.queue.clear();
                GenericEventQueue.this.queue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postEvent(Runnable run) {
            if (!this.isAlive()) {
                throw new IllegalStateException("Event queue thread is not executing.");
            }
            LinkedList linkedList = GenericEventQueue.this.queue;
            synchronized (linkedList) {
                if (run != null) {
                    GenericEventQueue.this.queue.addLast(run);
                }
                GenericEventQueue.this.queue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                Object var3_4;
                Runnable runnable;
                LinkedList linkedList = GenericEventQueue.this.queue;
                synchronized (linkedList) {
                    while (true) {
                        if (!this.run || !GenericEventQueue.this.queue.isEmpty()) {
                            if (this.run) break;
                            return;
                        }
                        try {
                            GenericEventQueue.this.queue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    runnable = (Runnable)GenericEventQueue.this.queue.removeFirst();
                }
                try {
                    try {
                        runnable.run();
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    var3_4 = null;
                    runnable = null;
                    throw throwable;
                }
                {
                    var3_4 = null;
                    runnable = null;
                    continue;
                }
                break;
            }
        }
    }
}

