/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.internal.helper;

import java.io.LineNumberReader;
import java.io.StringReader;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.helper.OCLHelperImpl;
import org.eclipse.ocl.internal.parser.OCLLexer;
import org.eclipse.ocl.internal.parser.OCLParser;
import org.eclipse.ocl.internal.parser.ValidationVisitor;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.ExpressionInOCL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelperUtil {
    static final int NONE = -1;
    static final String OCL_COMMENT = "--";
    static final String PATH_DELIMETER = "(=> ";
    static final String PACKAGE = "package";
    static final String COLON = ":";
    static final String DOUBLE_COLON = "::";
    static final String DOT = ".";
    static final String ARROW = "->";
    static final String CARET = "^";
    static final String DOUBLE_CARET = "^^";
    static final String EMPTY = "";
    static final String HTTP = "http://";

    private HelperUtil() {
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> OCLHelper<C, O, P, CT> createOCLHelper(OCL<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> ocl) {
        return new OCLHelperImpl<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(ocl);
    }

    static void throwException(RuntimeException exception, Class<?> clazz, String methodName) {
        OCLPlugin.throwing(clazz, methodName, exception);
        throw exception;
    }

    static void catchException(Exception exception, Class<?> clazz, String methodName) {
        OCLPlugin.catching(clazz, methodName, exception);
    }

    static String getLogicalLine(String txt) throws Exception {
        LineNumberReader reader = new LineNumberReader(new StringReader(txt.trim()));
        String logicalLine = EMPTY;
        int embeddedCommnetIndex = -1;
        String line = reader.readLine();
        while (line != null) {
            if (!(line = line.trim()).startsWith(OCL_COMMENT)) {
                embeddedCommnetIndex = line.indexOf(OCL_COMMENT);
                if (embeddedCommnetIndex != -1) {
                    line = line.substring(0, embeddedCommnetIndex);
                    line = line.trim();
                }
                logicalLine = String.valueOf(logicalLine) + line + ' ';
            }
            line = reader.readLine();
        }
        return logicalLine;
    }

    static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> OCLExpression<C> parseQuery(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String expression, boolean validate, boolean trace) throws ParserException {
        OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parser = HelperUtil.createParser(env, "inv:", expression, trace);
        CT constraint = parser.parseInvOrDefCS();
        ExpressionInOCL spec = env.getUMLReflection().getSpecification(constraint);
        OCLExpression<C> result = spec.getBodyExpression();
        env.getUMLReflection().setSpecification(constraint, null);
        spec.setBodyExpression(null);
        if (validate) {
            HelperUtil.validate(env, result);
        }
        HelperUtil.persist(env, spec.getContextVariable());
        return result;
    }

    static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> CT parseInvariant(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String expression, boolean validate, boolean trace) throws ParserException {
        OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parser = HelperUtil.createParser(env, "inv:", expression, trace);
        CT result = parser.parseInvOrDefCS();
        if (validate) {
            HelperUtil.validate(env, result);
        }
        HelperUtil.persist(env, result);
        return result;
    }

    static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> CT parsePrecondition(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String expression, boolean validate, boolean trace) throws ParserException {
        OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parser = HelperUtil.createParser(env, "pre:", expression, trace);
        CT result = parser.parsePrePostOrBodyDeclCS();
        if (validate) {
            HelperUtil.validate(env, result);
        }
        HelperUtil.persist(env, result);
        return result;
    }

    static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> CT parsePostcondition(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String expression, boolean validate, boolean trace) throws ParserException {
        OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parser = HelperUtil.createParser(env, "post:", expression, trace);
        CT result = parser.parsePrePostOrBodyDeclCS();
        if (validate) {
            HelperUtil.validate(env, result);
        }
        HelperUtil.persist(env, result);
        return result;
    }

    static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> CT parseBodyCondition(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String expression, boolean validate, boolean trace) throws ParserException {
        OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parser = HelperUtil.createParser(env, "body:", expression, trace);
        CT result = parser.parsePrePostOrBodyDeclCS();
        if (validate) {
            HelperUtil.validate(env, result);
        }
        HelperUtil.persist(env, result);
        return result;
    }

    static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> CT parseInitialValueExpression(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String expression, boolean validate, boolean trace) throws ParserException {
        OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parser = HelperUtil.createParser(env, "init:", expression, trace);
        CT result = parser.parseInitOrDerValueCS();
        if (validate) {
            HelperUtil.validate(env, result);
        }
        HelperUtil.persist(env, result);
        return result;
    }

    static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> CT parseDerivedValueExpression(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String expression, boolean validate, boolean trace) throws ParserException {
        OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parser = HelperUtil.createParser(env, "derive:", expression, trace);
        CT result = parser.parseInitOrDerValueCS();
        if (validate) {
            HelperUtil.validate(env, result);
        }
        HelperUtil.persist(env, result);
        return result;
    }

    static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> CT parseDefExpression(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String defExpression, boolean validate, boolean trace) throws ParserException {
        OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parser = HelperUtil.createParser(env, "def:", defExpression, trace);
        CT result = parser.parseInvOrDefCS();
        if (validate) {
            HelperUtil.validate(env, result);
        }
        HelperUtil.persist(env, result);
        return result;
    }

    private static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createParser(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String prefix, String text, boolean trace) {
        OCLLexer lexer = new OCLLexer((String.valueOf(prefix) + '\n' + text).toCharArray());
        OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> result = new OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>(lexer, env);
        result.setErrorReportLineOffset(-1);
        result.setCharacterOffset(-(prefix.length() + 1));
        result.setTraceFlag(trace);
        return result;
    }

    private static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> void validate(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, OCLExpression<C> expression) throws SemanticException {
        try {
            expression.accept(ValidationVisitor.getInstance(env));
        }
        catch (Exception e) {
            throw new SemanticException(e.getLocalizedMessage(), e);
        }
    }

    private static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> void validate(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, CT constraint) throws SemanticException {
        try {
            ValidationVisitor.getInstance(env).visitConstraint(constraint);
        }
        catch (Exception e) {
            throw new SemanticException(e.getLocalizedMessage(), e);
        }
    }

    private static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> void persist(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, CT constraint) {
        EObject constraintEObject = (EObject)constraint;
        if (constraintEObject.eResource() == null) {
            env.getTypeResolver().getResource().getContents().add((Object)constraintEObject);
        }
    }

    private static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> void persist(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, ASTNode astNode) {
        if (astNode.eResource() == null) {
            env.getTypeResolver().getResource().getContents().add((Object)astNode);
        }
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> Object getConstraintContext(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, Object element, OCLExpression<C> expr) {
        Object application;
        Object contextClassifier;
        ExpressionInOCL specification;
        Variable contextVariable;
        Object result = element;
        if (expr.eContainer() instanceof ExpressionInOCL && (contextVariable = (specification = (ExpressionInOCL)expr.eContainer()).getContextVariable()) != null && (contextClassifier = contextVariable.getType()) != null && env.getUMLReflection().isStereotype(contextClassifier) && (application = env.getUMLReflection().getStereotypeApplication(element, contextClassifier)) != null) {
            result = application;
        }
        return result;
    }
}

