/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.internal.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import lpg.lpgjavaruntime.LexStream;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CallExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.FeatureCallExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.LiteralExp;
import org.eclipse.ocl.expressions.LoopExp;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.NavigationCallExp;
import org.eclipse.ocl.expressions.NullLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PrimitiveLiteralExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralPart;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.internal.cst.BooleanLiteralExpCS;
import org.eclipse.ocl.internal.cst.CSTNode;
import org.eclipse.ocl.internal.cst.CallExpCS;
import org.eclipse.ocl.internal.cst.ClassifierContextDeclCS;
import org.eclipse.ocl.internal.cst.CollectionLiteralExpCS;
import org.eclipse.ocl.internal.cst.CollectionLiteralPartCS;
import org.eclipse.ocl.internal.cst.CollectionRangeCS;
import org.eclipse.ocl.internal.cst.CollectionTypeCS;
import org.eclipse.ocl.internal.cst.CollectionTypeIdentifierEnum;
import org.eclipse.ocl.internal.cst.ContextDeclCS;
import org.eclipse.ocl.internal.cst.DefCS;
import org.eclipse.ocl.internal.cst.DefExpressionCS;
import org.eclipse.ocl.internal.cst.EnumLiteralExpCS;
import org.eclipse.ocl.internal.cst.FeatureCallExpCS;
import org.eclipse.ocl.internal.cst.IfExpCS;
import org.eclipse.ocl.internal.cst.InitOrDerValueCS;
import org.eclipse.ocl.internal.cst.IntegerLiteralExpCS;
import org.eclipse.ocl.internal.cst.InvCS;
import org.eclipse.ocl.internal.cst.InvOrDefCS;
import org.eclipse.ocl.internal.cst.InvalidLiteralExpCS;
import org.eclipse.ocl.internal.cst.IterateExpCS;
import org.eclipse.ocl.internal.cst.IteratorExpCS;
import org.eclipse.ocl.internal.cst.LetExpCS;
import org.eclipse.ocl.internal.cst.LiteralExpCS;
import org.eclipse.ocl.internal.cst.LoopExpCS;
import org.eclipse.ocl.internal.cst.MessageExpCS;
import org.eclipse.ocl.internal.cst.MessageExpKind;
import org.eclipse.ocl.internal.cst.NullLiteralExpCS;
import org.eclipse.ocl.internal.cst.OCLExpressionCS;
import org.eclipse.ocl.internal.cst.OCLMessageArgCS;
import org.eclipse.ocl.internal.cst.OperationCS;
import org.eclipse.ocl.internal.cst.OperationCallExpCS;
import org.eclipse.ocl.internal.cst.OperationContextDeclCS;
import org.eclipse.ocl.internal.cst.PackageDeclarationCS;
import org.eclipse.ocl.internal.cst.PathNameCS;
import org.eclipse.ocl.internal.cst.PrePostOrBodyDeclCS;
import org.eclipse.ocl.internal.cst.PrePostOrBodyEnum;
import org.eclipse.ocl.internal.cst.PrimitiveLiteralExpCS;
import org.eclipse.ocl.internal.cst.PrimitiveTypeCS;
import org.eclipse.ocl.internal.cst.PropertyContextCS;
import org.eclipse.ocl.internal.cst.RealLiteralExpCS;
import org.eclipse.ocl.internal.cst.SimpleNameCS;
import org.eclipse.ocl.internal.cst.SimpleTypeEnum;
import org.eclipse.ocl.internal.cst.StateExpCS;
import org.eclipse.ocl.internal.cst.StringLiteralExpCS;
import org.eclipse.ocl.internal.cst.TupleLiteralExpCS;
import org.eclipse.ocl.internal.cst.TupleTypeCS;
import org.eclipse.ocl.internal.cst.TypeCS;
import org.eclipse.ocl.internal.cst.UnlimitedNaturalLiteralExpCS;
import org.eclipse.ocl.internal.cst.VariableCS;
import org.eclipse.ocl.internal.cst.VariableExpCS;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.internal.parser.OCLLPGParser;
import org.eclipse.ocl.internal.parser.OCLLexer;
import org.eclipse.ocl.types.BagType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.MessageType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.OrderedSetType;
import org.eclipse.ocl.types.SequenceType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.CallingASTNode;
import org.eclipse.ocl.utilities.ExpressionInOCL;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.TypedASTNode;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLParser<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends OCLLPGParser {
    public static final String[] errorMessages = new String[]{OCLMessages.OCLParseErrorCodes_LEX_ERROR, OCLMessages.OCLParseErrorCodes_ERROR, OCLMessages.OCLParseErrorCodes_BEFORE, OCLMessages.OCLParseErrorCodes_INSERTION, OCLMessages.OCLParseErrorCodes_INVALID, OCLMessages.OCLParseErrorCodes_SUBSTITUTION_SECONDARY, OCLMessages.OCLParseErrorCodes_DELETION, OCLMessages.OCLParseErrorCodes_MERGE, OCLMessages.OCLParseErrorCodes_MISPLACED, OCLMessages.OCLParseErrorCodes_SCOPE, OCLMessages.OCLParseErrorCodes_EOF, OCLMessages.OCLParseErrorCodes_INVALID_TOKEN};
    private static final String OCL_ESCAPE_PREFIX = "_";
    private static final int OCL_ESCAPE_LENGTH = "_".length();
    OCLFactory oclFactory;
    UMLReflection<PK, C, O, P, EL, PM, S, COA, SSA, CT> uml;
    private EnvironmentFactory<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> environmentFactory;
    private Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> environment;
    private boolean traceflag = false;
    private String errorString = "";
    private int charOffset = 0;
    private int errorReportLineOffset = 0;

    public OCLParser(OCLLexer lexStream, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> environment) {
        super((LexStream)lexStream);
        lexStream.lexer(this);
        this.environmentFactory = environment.getFactory();
        this.environment = environment;
        this.oclFactory = environment.getOCLFactory();
        this.uml = environment.getUMLReflection();
    }

    public void setTraceFlag(boolean flag) {
        this.traceflag = flag;
    }

    public boolean getTraceFlag() {
        return this.traceflag;
    }

    private void TRACE(String rule, String message) {
        if (this.traceflag) {
            OCLPlugin.trace(String.valueOf(rule) + ": " + message);
        }
    }

    private void TRACE(String rule, String message, EList<String> namelist) {
        this.TRACE(rule, String.valueOf(message) + this.makeString(namelist));
    }

    public void setCharacterOffset(int offset) {
        this.charOffset = offset;
    }

    public void setErrorReportLineOffset(int offset) {
        this.errorReportLineOffset = offset;
    }

    public static boolean isIdentifierOrKeyword(int tokenKind) {
        switch (tokenKind) {
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                return true;
            }
        }
        return false;
    }

    private void initStartEndPositions(ASTNode astNode, CSTNode cstNode) {
        astNode.setStartPosition(cstNode.getStartOffset() + this.charOffset);
        astNode.setEndPosition(cstNode.getEndOffset() + this.charOffset + 1);
    }

    private void initPropertyPositions(CallingASTNode callingASTNode, CSTNode cstNode) {
        callingASTNode.setPropertyStartPosition(cstNode.getStartOffset() + this.charOffset);
        callingASTNode.setPropertyEndPosition(cstNode.getEndOffset() + this.charOffset + 1);
    }

    private void initTypePositions(TypedASTNode typedASTNode, CSTNode cstNode) {
        typedASTNode.setTypeStartPosition(cstNode.getStartOffset() + this.charOffset);
        typedASTNode.setTypeEndPosition(cstNode.getEndOffset() + this.charOffset + 1);
    }

    private String makeString(EList<String> namelist) {
        String msg = "";
        int i = 0;
        while (i < namelist.size()) {
            msg = String.valueOf(msg) + " " + (String)namelist.get(i);
            ++i;
        }
        return msg;
    }

    private String makeName(EList<String> namelist) {
        StringBuffer msg = new StringBuffer();
        int i = 0;
        while (i < namelist.size()) {
            if (i > 0) {
                msg.append("::");
            }
            msg.append((String)namelist.get(i));
            ++i;
        }
        return msg.toString();
    }

    private String operationString(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String operName, List<? extends TypedElement<C>> args) {
        StringBuffer result = new StringBuffer();
        result.append(operName);
        result.append('(');
        Iterator<TypedElement<C>> iter = args.iterator();
        while (iter.hasNext()) {
            TypedElement<C> arg = iter.next();
            C type = arg.getType();
            result.append(type == null ? null : this.uml.getName(type));
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        result.append(')');
        return result.toString();
    }

    private OCLStandardLibrary<C> getStandardLibrary() {
        return this.environment.getOCLStandardLibrary();
    }

    private C getBoolean() {
        return this.getStandardLibrary().getBoolean();
    }

    private void setQualifiers(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String rule, NavigationCallExp<C, P> nc, List<OCLExpression<C>> qualifiers) throws SemanticException {
        if (nc instanceof PropertyCallExp) {
            Object source = ((PropertyCallExp)nc).getReferredProperty();
            List<P> expectedQualifiers = this.uml.getQualifiers(source);
            if (expectedQualifiers.size() != qualifiers.size()) {
                this.ERROR(rule, OCLMessages.bind(OCLMessages.MismatchedQualifiers_ERROR_, nc.toString()));
            } else if (!qualifiers.isEmpty()) {
                Object ncType;
                Iterator<P> eiter = expectedQualifiers.iterator();
                Iterator<OCLExpression<C>> qiter = qualifiers.iterator();
                while (eiter.hasNext()) {
                    OCLExpression<C> qualifier;
                    Object qualifierType;
                    C expectedType = this.uml.getOCLType(eiter.next());
                    if (TypeUtil.typeCompare(env, expectedType, qualifierType = (qualifier = qiter.next()).getType()) >= 0) continue;
                    this.ERROR(rule, OCLMessages.bind(OCLMessages.MismatchedQualifiers_ERROR_, nc.toString()));
                }
                if (this.uml.isMany(source) && (ncType = nc.getType()) instanceof CollectionType) {
                    CollectionType ct = (CollectionType)ncType;
                    nc.setType(ct.getElementType());
                }
            }
        } else if (nc instanceof AssociationClassCallExp) {
            OCLExpression<C> qualifier;
            if (qualifiers.size() != 1) {
                this.ERROR(rule, OCLMessages.bind(OCLMessages.AssociationClassQualifierCount_ERROR_, nc.toString()));
            }
            if (!((qualifier = qualifiers.get(0)) instanceof PropertyCallExp)) {
                this.ERROR(rule, OCLMessages.bind(OCLMessages.AssociationClassQualifierType_ERROR_, nc.toString()));
            }
            AssociationClassCallExp acc = (AssociationClassCallExp)nc;
            Object assocClass = acc.getReferredAssociationClass();
            Object sourceType = this.getElementType(nc.getSource().getType());
            Object property = ((PropertyCallExp)qualifier).getReferredProperty();
            C refAssocClass = this.uml.getAssociationClass(property);
            if (refAssocClass == null) {
                this.ERROR(rule, OCLMessages.bind(OCLMessages.AssociationClassQualifierType_ERROR_, nc.toString()));
            }
            if (this.uml.getAttributes(sourceType).contains(property) && refAssocClass == assocClass) {
                acc.setNavigationSource(property);
                CollectionKind kind = this.getCollectionKind(this.uml.getOCLType(property));
                if (kind != null) {
                    acc.setType(this.getCollectionType(env, kind, assocClass));
                } else {
                    acc.setType(assocClass);
                }
            } else {
                this.ERROR(rule, OCLMessages.bind(OCLMessages.AssociationClassQualifierType_ERROR_, nc.toString()));
            }
        }
        nc.getQualifier().addAll(qualifiers);
    }

    private void checkNotReflexive(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String rule, AssociationClassCallExp<C, P> acc) throws SemanticException {
        C assocClass = acc.getReferredAssociationClass();
        List<Object> ends = this.uml.isAssociationClass(assocClass) ? this.uml.getMemberEnds(assocClass) : Collections.emptyList();
        if (ends.size() == 2) {
            Object end1 = ends.get(0);
            Object end2 = ends.get(1);
            if (TypeUtil.getPropertyType(env, assocClass, end1) == TypeUtil.getPropertyType(env, assocClass, end2)) {
                this.ERROR(rule, OCLMessages.bind(OCLMessages.AssociationClassAmbiguous_ERROR_, acc.toString()));
            }
        }
    }

    public static void ERR(String message) throws SemanticException {
        throw new SemanticException(message);
    }

    private void ERROR(String rule, String errorMessage) throws SemanticException {
        String error = OCLMessages.bind(OCLMessages.ErrorMessage_ERROR_, rule, errorMessage);
        this.errorString = String.valueOf(this.errorString) + error;
        OCLParser.ERR(error);
    }

    private Variable<C, PM> genVariableDeclaration(String rule, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String name, C type, OCLExpression<C> initExp, boolean explicitFlag, boolean addToEnvironment, boolean isSelf) throws SemanticException {
        Variable vdcl = this.oclFactory.createVariable();
        vdcl.setName(name);
        vdcl.setType(TypeUtil.resolveType(env, type));
        vdcl.setInitExpression(initExp);
        if (addToEnvironment) {
            boolean result = env.addElement(name, vdcl, explicitFlag);
            if (!result) {
                if (name != null) {
                    String message = OCLMessages.bind(OCLMessages.VariableUsed_ERROR_, name);
                    this.ERROR(rule, message);
                } else {
                    this.ERROR(rule, OCLMessages.VariableDeclaration_ERROR_);
                }
            }
            if (isSelf) {
                env.setSelfVariable(vdcl);
            }
        }
        if (addToEnvironment) {
            this.TRACE(rule, "adding variable declaration for " + vdcl.getName());
        }
        return vdcl;
    }

    private OperationCallExp<C, O> genOperationCallExp(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, String rule, String operName, OCLExpression<C> source, C ownerType, List<OCLExpression<C>> args) throws SemanticException {
        OperationCallExp<C, O> result = this.oclFactory.createOperationCallExp();
        result.setSource(source);
        O oper = env.lookupOperation(ownerType, operName, args);
        if (oper == null) {
            String message = OCLMessages.bind(OCLMessages.OperationNotFound_ERROR_, this.operationString(env, operName, args), ownerType == null ? null : this.uml.getName(ownerType));
            this.ERROR(rule, message);
            result.setType(env.getOCLStandardLibrary().getOclVoid());
        } else {
            this.TRACE(rule, this.uml.getName(oper));
            result.setReferredOperation(oper);
        }
        List callargs = (List)result.getArgument();
        if (args != null) {
            for (OCLExpression<C> arg : args) {
                if (arg == null) {
                    this.ERROR(rule, OCLMessages.BadArg_ERROR_);
                    continue;
                }
                callargs.add(arg);
            }
        }
        if (oper != null) {
            Object resultType = null;
            int opcode = 0;
            if (ownerType instanceof PredefinedType) {
                opcode = OCLStandardLibraryUtil.getOperationCode(operName);
            } else if (TypeUtil.isOclAnyOperation(env, oper)) {
                opcode = OCLStandardLibraryUtil.getOclAnyOperationCode(operName);
            }
            result.setOperationCode(opcode);
            resultType = OCLStandardLibraryUtil.getResultTypeOf(env, ownerType, opcode, args);
            if (resultType == null) {
                resultType = this.uml.getOCLType(oper);
            }
            resultType = TypeUtil.resolveType(env, resultType);
            result.setType(resultType);
        }
        return result;
    }

    public CSTNode parseConcreteSyntax() throws ParserException {
        CSTNode cstNode = (CSTNode)this.parser();
        if (this.errorString.length() > 0) {
            String error = this.errorString;
            this.errorString = "";
            throw new ParserException(error);
        }
        return cstNode;
    }

    public OCLExpression<C> parseAST(OCLExpressionCS cst, ConstraintKind constraintType) throws ParserException {
        OCLExpression<C> result = null;
        switch (constraintType) {
            case PRECONDITION: {
                PrePostOrBodyDeclCS pre = this.createPrePostOrBodyDeclCS(PrePostOrBodyEnum.PRE_LITERAL, null, cst);
                result = this.uml.getSpecification(this.prePostOrBodyDeclCS(this.environment, pre)).getBodyExpression();
                break;
            }
            case BODYCONDITION: {
                PrePostOrBodyDeclCS body = this.createPrePostOrBodyDeclCS(PrePostOrBodyEnum.BODY_LITERAL, null, cst);
                result = this.uml.getSpecification(this.prePostOrBodyDeclCS(this.environment, body)).getBodyExpression();
                break;
            }
            case POSTCONDITION: {
                PrePostOrBodyDeclCS post = this.createPrePostOrBodyDeclCS(PrePostOrBodyEnum.POST_LITERAL, null, cst);
                result = this.uml.getSpecification(this.prePostOrBodyDeclCS(this.environment, post)).getBodyExpression();
                break;
            }
            default: {
                InvCS inv = this.createInvCS(null, null, cst);
                result = this.uml.getSpecification(this.invCS(inv, this.environment)).getBodyExpression();
            }
        }
        return result;
    }

    public List<CT> parsePackageDeclarationCS(List<CT> constraints) throws ParserException {
        CSTNode cstNode = this.parseConcreteSyntax();
        if (cstNode != null && !(cstNode instanceof PackageDeclarationCS)) {
            this.ERROR("parsePackageDeclarationCS", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "PackageDeclarationCS", cstNode.eClass().getName()));
        }
        BasicEList.FastCompare packageDecls = new BasicEList.FastCompare(4);
        PackageDeclarationCS pkgdecl = (PackageDeclarationCS)cstNode;
        while (pkgdecl != null) {
            packageDecls.add(0, pkgdecl);
            pkgdecl = pkgdecl.getPackageDeclarationCS();
        }
        for (PackageDeclarationCS packageDeclCS : packageDecls) {
            this.packageDeclarationCS(packageDeclCS, constraints);
        }
        return constraints;
    }

    public CT parseInvOrDefCS() throws ParserException {
        CSTNode cstNode = this.parseConcreteSyntax();
        if (cstNode != null) {
            if (cstNode instanceof InvOrDefCS) {
                return this.invOrDefCS((InvOrDefCS)cstNode, this.environment);
            }
            this.ERROR("parseInvOrDefCS", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "InvOrDefCS", cstNode.eClass().getName()));
        }
        return null;
    }

    public CT parsePrePostOrBodyDeclCS() throws ParserException {
        CSTNode cstNode = this.parseConcreteSyntax();
        if (cstNode != null && cstNode instanceof PrePostOrBodyDeclCS) {
            return this.prePostOrBodyDeclCS(this.environment, (PrePostOrBodyDeclCS)cstNode);
        }
        this.ERROR("parsePrePostOrBodyDeclCS", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "PrePostOrBodyDeclCS", cstNode.eClass().getName()));
        return null;
    }

    public CT parseInitOrDerValueCS() throws ParserException {
        CSTNode cstNode = this.parseConcreteSyntax();
        if (cstNode != null && cstNode instanceof InitOrDerValueCS) {
            return this.initOrDerValueCS(this.environment, (InitOrDerValueCS)cstNode);
        }
        this.ERROR("parseInitOrDerValueCS", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "InitOrDerValueCS", cstNode.eClass().getName()));
        return null;
    }

    public Variable<C, PM> parseVariableDeclarationCS(boolean addToEnvironment) throws ParserException {
        CSTNode cstNode = this.parseConcreteSyntax();
        if (cstNode != null) {
            if (cstNode instanceof VariableCS) {
                return this.variableDeclarationCS((VariableCS)cstNode, this.environment, true);
            }
            this.ERROR("parseVariableDeclarationCS", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "VariableDeclarationCS", cstNode.eClass().getName()));
        }
        return null;
    }

    public void reportError(int left_char, int right_char) {
    }

    public void reportError(int errorCode, String locationInfo, int leftToken, int rightToken, String tokenText) {
        int leftTokenLoc = leftToken > rightToken ? rightToken : leftToken;
        int rightTokenLoc = rightToken;
        if (this.getLine(leftTokenLoc) + this.errorReportLineOffset <= 0) {
            this.errorString = OCLMessages.InvalidOCL_ERROR_;
        } else {
            String locInfo = OCLMessages.bind(OCLMessages.ErrorReport_RowColumn, new Object[]{new Integer(this.getLine(leftTokenLoc) + this.errorReportLineOffset), new Integer(this.getColumn(leftTokenLoc)), new Integer(this.getEndLine(rightTokenLoc) + this.errorReportLineOffset), new Integer(this.getEndColumn(rightTokenLoc))});
            switch (errorCode) {
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    this.errorString = String.valueOf(OCLMessages.bind(errorMessages[errorCode], locInfo, String.valueOf('\"') + this.computeInputString(this.getIToken(leftToken).getStartOffset(), this.getIToken(rightToken).getEndOffset()))) + '\"';
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    this.errorString = OCLMessages.bind(errorMessages[errorCode], new Object[]{locInfo, tokenText, String.valueOf('\"') + this.computeInputString(this.getIToken(leftToken).getStartOffset(), this.getIToken(rightToken).getEndOffset()) + '\"'});
                    break;
                }
                default: {
                    this.errorString = OCLMessages.bind(errorMessages[errorCode], locInfo, tokenText);
                }
            }
        }
    }

    private String computeInputString(int left, int right) {
        StringBuffer result = new StringBuffer(right - left + 1);
        char[] chars = this.getInputChars();
        int i = left;
        while (i <= right) {
            if (chars[i] == '\t') {
                result.append(' ');
            } else if (chars[i] == '\n' || chars[i] == '\r' || chars[i] == '\f') {
                if (i > 0 && !Character.isWhitespace(chars[i - 1])) {
                    result.append(' ');
                }
            } else {
                result.append(chars[i]);
            }
            ++i;
        }
        return result.toString();
    }

    private String computeInputString(CSTNode node) {
        return this.computeInputString(node.getStartOffset(), node.getEndOffset());
    }

    public void reportError(int errorCode, String locationInfo, String tokenText) {
    }

    public void reportError(int i, String code) {
        this.errorString = String.valueOf(code) + " (" + this.getKind(i) + ") : " + this.getStartOffset(i) + ":" + this.getLineNumberOfTokenAt(i) + ":" + this.getColumnOfTokenAt(i) + ":" + this.getTokenLength(i) + " " + this.getTokenText(i);
    }

    protected void packageDeclarationCS(PackageDeclarationCS packageDeclarationCS, List<CT> constraints) throws SemanticException {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env;
        EList pathname;
        EList<ContextDeclCS> contextDecls = packageDeclarationCS.getContextDecls();
        PathNameCS pathNameCS = packageDeclarationCS.getPathNameCS();
        EList eList = pathname = pathNameCS == null ? null : pathNameCS.getSequenceOfNames();
        if (pathname == null) {
            env = this.environment;
            pathname = ECollections.emptyEList();
        } else {
            env = this.environmentFactory.createPackageContext(this.environment, (List<String>)pathname);
            if (env == null) {
                this.ERROR("packageDeclarationCS", OCLMessages.bind(OCLMessages.PackageNotFound_ERROR_, this.makeString((EList<String>)pathname)));
            }
        }
        this.TRACE("packageDeclarationCS", "Package ", (EList<String>)pathname);
        for (ContextDeclCS decl : contextDecls) {
            this.contextDeclCS(decl, env, constraints);
        }
    }

    protected void contextDeclCS(ContextDeclCS contextDeclCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, List<CT> constraints) throws SemanticException {
        if (contextDeclCS instanceof OperationContextDeclCS) {
            this.operationContextDeclCS((OperationContextDeclCS)contextDeclCS, env, constraints);
        } else if (contextDeclCS instanceof PropertyContextCS) {
            this.propertyContextCS((PropertyContextCS)contextDeclCS, env, constraints);
        } else if (contextDeclCS instanceof ClassifierContextDeclCS) {
            this.classifierContextDeclCS((ClassifierContextDeclCS)contextDeclCS, env, constraints);
        }
    }

    protected void operationContextDeclCS(OperationContextDeclCS operationContextDeclCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, List<CT> constraints) throws SemanticException {
        env = this.operationCS(operationContextDeclCS.getOperationCS(), env);
        for (PrePostOrBodyDeclCS decl : operationContextDeclCS.getPrePostOrBodyDecls()) {
            CT astNode = this.prePostOrBodyDeclCS(env, decl);
            constraints.add(astNode);
        }
    }

    protected Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> operationCS(OperationCS operationCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        int lastName;
        ArrayList<String> className;
        O operation = null;
        Object classifier = null;
        BasicEList operationName = new BasicEList();
        operationName.addAll(operationCS.getPathNameCS().getSequenceOfNames());
        operationName.add((Object)operationCS.getSimpleNameCS().getValue());
        if (operationName.size() > 1 && (classifier = (Object)env.lookupClassifier(className = new ArrayList<String>(operationName.subList(0, lastName = operationName.size() - 1)))) != null) {
            if ((env = this.environmentFactory.createClassifierContext(env, classifier)).lookupLocal("self") == null) {
                this.genVariableDeclaration("operationCS", env, "self", classifier, null, true, true, true);
            }
            List<Variable<Object, PM>> contextParms = this.parametersCS((List<VariableCS>)operationCS.getParameters(), env);
            operation = env.lookupOperation(classifier, (String)operationName.get(lastName), contextParms);
            if (operation == null) {
                String message = OCLMessages.bind(OCLMessages.UnrecognizedContext_ERROR_, this.makeString((EList<String>)operationName));
                this.ERROR("operationContextDeclCS", message);
            }
        }
        if (operation == null) {
            String message = OCLMessages.bind(OCLMessages.UnrecognizedContext_ERROR_, this.makeString((EList<String>)operationName));
            this.ERROR("operationContextDeclCS", message);
        }
        this.TRACE("operationCS", "context", (EList<String>)operationName);
        return this.createOperationContext(env, (OperationContextDeclCS)operationCS.eContainer(), operation);
    }

    private Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createOperationContext(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, OperationContextDeclCS operationContextCS, O operation) throws SemanticException {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> result = this.environmentFactory.createOperationContext(env, operation);
        if (result.lookupLocal("self") == null) {
            this.genVariableDeclaration("operationContextDeclCS", result, "self", env.getContextClassifier(), null, true, true, true);
        }
        if (operationContextCS != null) {
            EList<VariableCS> contextParms = operationContextCS.getOperationCS().getParameters();
            List<PM> parms = this.uml.getParameters(operation);
            int i = 0;
            while (i < parms.size()) {
                String innateParmName;
                String contextParmName = ((VariableCS)contextParms.get(i)).getName();
                if (!contextParmName.equals(innateParmName = this.uml.getName(parms.get(i)))) {
                    Variable<C, PM> var = result.lookupLocal(innateParmName);
                    result.deleteElement(innateParmName);
                    var.setName(contextParmName);
                    result.addElement(contextParmName, var, true);
                }
                ++i;
            }
        }
        return result;
    }

    protected List<Variable<C, PM>> parametersCS(List<VariableCS> parameters, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        return this.variableDeclarationListCS(parameters, env, false);
    }

    protected CT prePostOrBodyDeclCS(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, PrePostOrBodyDeclCS prePostOrBodyDeclCS) throws SemanticException {
        CT astNode;
        Variable<C, PM> resultVar = null;
        O operation = env.getContextOperation();
        env = this.createOperationContext(env, (OperationContextDeclCS)prePostOrBodyDeclCS.eContainer(), operation);
        C operationType = this.uml.getOCLType(operation);
        if (operationType instanceof VoidType) {
            operationType = null;
        }
        String stereotype = null;
        switch (prePostOrBodyDeclCS.getKind().getValue()) {
            case 1: {
                stereotype = "precondition";
                break;
            }
            case 2: {
                stereotype = "postcondition";
                if (operationType == null || env.lookupLocal("result") != null) break;
                resultVar = this.genVariableDeclaration("prePostOrBodyDeclCS0", env, "result", operationType, null, true, true, false);
                break;
            }
            case 3: {
                stereotype = "body";
                if (operationType == null || env.lookupLocal("result") != null) break;
                resultVar = this.genVariableDeclaration("prePostOrBodyDeclCS", env, "result", operationType, null, true, true, false);
            }
        }
        try {
            OCLExpression<C> oclExpression = this.oclExpressionCS(prePostOrBodyDeclCS.getExpressionCS(), env);
            astNode = this.uml.createConstraint();
            SimpleNameCS simpleNameCS = prePostOrBodyDeclCS.getSimpleNameCS();
            if (simpleNameCS != null) {
                this.uml.setConstraintName(astNode, simpleNameCS.getValue());
            }
            List<EObject> constrainedElement = this.uml.getConstrainedElements(astNode);
            constrainedElement.add((EObject)operation);
            ExpressionInOCL<C, PM> spec = this.uml.createExpressionInOCL();
            spec.setBodyExpression(oclExpression);
            spec.setContextVariable(env.getSelfVariable());
            spec.setResultVariable(resultVar);
            List<PM> parameters = this.uml.getParameters(operation);
            Collection<Variable<C, PM>> vars = env.getVariables();
            for (Variable<C, PM> var : vars) {
                if (!parameters.contains(var.getRepresentedParameter())) continue;
                spec.getParameterVariable().add(var);
            }
            this.uml.setSpecification(astNode, spec);
            this.uml.setStereotype(astNode, stereotype);
            if ("body".equals(stereotype)) {
                env.setBodyCondition(operation, astNode);
            }
        }
        finally {
            if (resultVar != null) {
                env.deleteElement("result");
            }
        }
        return astNode;
    }

    protected P propertyContextCS(PropertyContextCS propertyContextCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, List<CT> constraints) throws SemanticException {
        EList<String> pathName = propertyContextCS.getPathNameCS().getSequenceOfNames();
        C owner = env.lookupClassifier((List<String>)pathName);
        if (owner == null) {
            String message = OCLMessages.bind(OCLMessages.UnrecognizedContext_ERROR_, this.makeString(pathName));
            this.ERROR("propertyContextCS", message);
        }
        owner = this.uml.asOCLType(owner);
        env = this.environmentFactory.createClassifierContext(env, owner);
        String simpleName = propertyContextCS.getSimpleNameCS().getValue();
        P property = env.lookupProperty(owner, simpleName);
        BasicEList propertyName = new BasicEList();
        propertyName.addAll(pathName);
        propertyName.add((Object)simpleName);
        if (property == null) {
            String message = OCLMessages.bind(OCLMessages.UnrecognizedContext_ERROR_, this.makeString((EList<String>)propertyName));
            this.ERROR("propertyContextCS", message);
        }
        C type = this.typeCS(propertyContextCS.getTypeCS(), env);
        C propertyType = TypeUtil.getPropertyType(env, owner, property);
        if (type == null || TypeUtil.typeCompare(env, propertyType, type) != 0) {
            String message = OCLMessages.bind(OCLMessages.UnrecognizedContext_ERROR_, this.makeString((EList<String>)propertyName));
            this.ERROR("propertyContextCS", message);
        }
        this.TRACE("propertyContextCS", "context", (EList<String>)propertyName);
        env = this.environmentFactory.createAttributeContext(env, property);
        InitOrDerValueCS initOrDerValueCS = propertyContextCS.getInitOrDerValueCS();
        CT astNode = this.initOrDerValueCS(env, initOrDerValueCS);
        constraints.add(astNode);
        InitOrDerValueCS other = initOrDerValueCS.getInitOrDerValueCS();
        if (other != null) {
            if (initOrDerValueCS.eClass() == other.eClass() || other.getInitOrDerValueCS() != null) {
                String message = OCLMessages.bind(OCLMessages.PropertyConstraints_ERROR_, this.makeString((EList<String>)propertyName));
                this.ERROR("propertyContextCS", message);
            }
            astNode = this.initOrDerValueCS(env, other);
            constraints.add(astNode);
        }
        return property;
    }

    private Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createPropertyContext(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, PropertyContextCS propertyContextCS, P property) throws SemanticException {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> result = this.environmentFactory.createAttributeContext(env, property);
        if (result.lookupLocal("self") == null) {
            this.genVariableDeclaration("propertyContextCS", result, "self", env.getContextClassifier(), null, true, true, true);
        }
        return result;
    }

    protected CT initOrDerValueCS(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, InitOrDerValueCS initOrDerValueCS) throws SemanticException {
        P property = env.getContextProperty();
        env = this.createPropertyContext(env, (PropertyContextCS)initOrDerValueCS.eContainer(), property);
        String stereotype = null;
        switch (initOrDerValueCS.eClass().getClassifierID()) {
            case 16: {
                stereotype = "initial";
                break;
            }
            case 15: {
                stereotype = "derivation";
            }
        }
        OCLExpression<C> oclExpression = this.oclExpressionCS(initOrDerValueCS.getExpressionCS(), env);
        CT astNode = this.uml.createConstraint();
        List<EObject> constrainedElement = this.uml.getConstrainedElements(astNode);
        constrainedElement.add((EObject)property);
        ExpressionInOCL<C, PM> spec = this.uml.createExpressionInOCL();
        spec.setBodyExpression(oclExpression);
        spec.setContextVariable(env.getSelfVariable());
        this.uml.setSpecification(astNode, spec);
        this.uml.setStereotype(astNode, stereotype);
        if ("derivation".equals(stereotype)) {
            env.setDeriveConstraint(property, astNode);
        } else {
            env.setInitConstraint(property, astNode);
        }
        return astNode;
    }

    protected Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> classifierContextDeclCS(ClassifierContextDeclCS classifierContextDeclCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, List<CT> constraints) throws SemanticException {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> result = null;
        EList<String> pathName = classifierContextDeclCS.getPathNameCS().getSequenceOfNames();
        C type = env.lookupClassifier((List<String>)pathName);
        if (type == null) {
            String message = OCLMessages.bind(OCLMessages.UnrecognizedContext_ERROR_, this.makeString(pathName));
            this.ERROR("classifierContextDeclCS", message);
        }
        if ((result = this.environmentFactory.createClassifierContext(env, type = this.uml.asOCLType(type))).getSelfVariable() == null) {
            this.genVariableDeclaration("classifierContextDeclCS", result, "self", type, null, true, true, true);
        }
        this.TRACE("classifierContextDeclCS", "context", pathName);
        BasicEList.FastCompare constraintDecls = new BasicEList.FastCompare(4);
        InvOrDefCS invOrDefCS = classifierContextDeclCS.getInvOrDefCS();
        while (invOrDefCS != null) {
            constraintDecls.add(0, invOrDefCS);
            invOrDefCS = invOrDefCS.getInvOrDefCS();
        }
        for (InvOrDefCS decl : constraintDecls) {
            constraints.add(this.invOrDefCS(decl, result));
        }
        return result;
    }

    private Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> createClassifierContext(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, ClassifierContextDeclCS classifierContextDeclCS, C classifier) throws SemanticException {
        Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> result = this.environmentFactory.createClassifierContext(env, classifier);
        if (result.lookupLocal("self") == null) {
            this.genVariableDeclaration("propertyContextCS", result, "self", env.getContextClassifier(), null, true, true, true);
        }
        return result;
    }

    protected CT invOrDefCS(InvOrDefCS invOrDefCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        C classifier = env.getContextClassifier();
        env = this.createClassifierContext(env, (ClassifierContextDeclCS)invOrDefCS.eContainer(), classifier);
        CT astNode = null;
        if (invOrDefCS instanceof InvCS) {
            astNode = this.invCS((InvCS)invOrDefCS, env);
        } else if (invOrDefCS instanceof DefCS) {
            astNode = this.defCS((DefCS)invOrDefCS, env);
        }
        return astNode;
    }

    protected CT invCS(InvCS invCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        OCLExpression<C> oclExpression = this.oclExpressionCS(invCS.getExpressionCS(), env);
        CT astNode = this.uml.createConstraint();
        SimpleNameCS simpleNameCS = invCS.getSimpleNameCS();
        if (simpleNameCS != null) {
            this.uml.setConstraintName(astNode, simpleNameCS.getValue());
        }
        C type = env.getContextClassifier();
        List<EObject> constrainedElement = this.uml.getConstrainedElements(astNode);
        constrainedElement.add((EObject)type);
        ExpressionInOCL<C, PM> spec = this.uml.createExpressionInOCL();
        spec.setBodyExpression(oclExpression);
        spec.setContextVariable(env.getSelfVariable());
        this.uml.setSpecification(astNode, spec);
        this.uml.setStereotype(astNode, "invariant");
        return astNode;
    }

    protected CT defCS(DefCS defCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        DefExpressionCS defExpr = defCS.getDefExpressionCS();
        EObject feature = null;
        OCLExpression<C> expression = null;
        CT astNode = this.uml.createConstraint();
        Variable<C, PM> variable = null;
        Object operType = null;
        C contextClassifier = env.getContextClassifier();
        SimpleNameCS simpleNameCS = defCS.getSimpleNameCS();
        if (simpleNameCS != null) {
            this.uml.setConstraintName(astNode, simpleNameCS.getValue());
        }
        List<EObject> constrainedElement = this.uml.getConstrainedElements(astNode);
        constrainedElement.add((EObject)contextClassifier);
        ExpressionInOCL<C, PM> spec = this.uml.createExpressionInOCL();
        this.uml.setSpecification(astNode, spec);
        this.uml.setStereotype(astNode, "definition");
        try {
            if (defExpr.getVariableCS() != null) {
                Environment<PK, Object, O, P, EL, PM, S, COA, SSA, CT, CLS, E> contextEnv = env;
                variable = this.variableDeclarationCS(defExpr.getVariableCS(), contextEnv, false);
                P existing = env.lookupProperty(contextClassifier, variable.getName());
                if (existing != null) {
                    this.ERROR("defCS", OCLMessages.bind(OCLMessages.DuplicateProperty_ERROR_, variable.getName(), this.uml.getName(contextEnv.getContextClassifier())));
                }
                spec.setContextVariable(env.getSelfVariable());
                feature = (EObject)env.defineAttribute(contextClassifier, variable, astNode);
                constrainedElement.add(feature);
                expression = this.oclExpressionCS(defExpr.getExpressionCS(), contextEnv);
            } else if (defExpr.getOperationCS() != null) {
                Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> contextEnv = this.environmentFactory.createEnvironment(env);
                OperationCS operCS = defExpr.getOperationCS();
                List<Variable<C, PM>> params = this.variableDeclarationListCS((List<VariableCS>)operCS.getParameters(), contextEnv, true);
                operType = this.typeCS(operCS.getTypeCS(), contextEnv);
                String operName = operCS.getSimpleNameCS().getValue();
                O existing = env.lookupOperation(contextClassifier, operName, params);
                if (existing != null) {
                    this.ERROR("defCS", OCLMessages.bind(OCLMessages.DuplicateOperation_ERROR_, this.operationString(env, operName, params), this.uml.getName(contextEnv.getContextClassifier())));
                }
                spec.setContextVariable(env.getSelfVariable());
                spec.getParameterVariable().addAll(params);
                feature = (EObject)env.defineOperation(contextClassifier, defExpr.getOperationCS().getSimpleNameCS().getValue(), operType, params, astNode);
                constrainedElement.add(feature);
                expression = this.oclExpressionCS(defExpr.getExpressionCS(), contextEnv);
            }
            if (feature != null && expression != null) {
                C featureType = this.uml.getOCLType(feature);
                Object bodyType = expression.getType();
                if (featureType == null || TypeUtil.typeCompare(env, bodyType, featureType) > 0) {
                    expression = null;
                    String message = OCLMessages.bind(OCLMessages.DefinitionConstraintConformance_ERROR_, this.uml.getName(bodyType), this.uml.getName(featureType));
                    this.ERROR("defCS", message);
                }
                spec.setBodyExpression(expression);
            }
        }
        finally {
            if (feature != null && expression == null) {
                env.undefine(feature);
            }
        }
        return astNode;
    }

    protected Variable<C, PM> variableDeclarationCS(VariableCS variableDeclarationCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, boolean addToEnvironment) throws SemanticException {
        String varName = variableDeclarationCS.getName();
        C type = null;
        if (variableDeclarationCS.getTypeCS() != null) {
            type = this.typeCS(variableDeclarationCS.getTypeCS(), env);
        }
        OCLExpression<C> expr = null;
        if (variableDeclarationCS.getInitExpression() != null) {
            expr = this.oclExpressionCS(variableDeclarationCS.getInitExpression(), env);
        }
        if (expr != null) {
            Object exprType = expr.getType();
            while (exprType instanceof CollectionType) {
                CollectionType ct = (CollectionType)exprType;
                exprType = ct.getElementType();
            }
            if (exprType instanceof MessageType) {
                C varType = type;
                if (varType instanceof CollectionType) {
                    do {
                        CollectionType collType;
                        if ((varType = (C)(collType = (CollectionType)varType).getElementType()) != env.getOCLStandardLibrary().getOclMessage()) continue;
                        collType.setElementType(exprType);
                        break;
                    } while (varType instanceof CollectionType);
                } else if (type == env.getOCLStandardLibrary().getOclMessage()) {
                    type = exprType;
                }
            }
        }
        Variable<Object, PM> astNode = this.genVariableDeclaration("variableDeclarationCS", env, varName, type, expr, true, addToEnvironment, false);
        this.initStartEndPositions(astNode, variableDeclarationCS);
        if (variableDeclarationCS.getTypeCS() != null) {
            this.initTypePositions(astNode, variableDeclarationCS.getTypeCS());
        }
        return astNode;
    }

    protected List<Variable<C, PM>> variableDeclarationListCS(List<VariableCS> variableDeclarationCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, boolean addToEnvironment) throws SemanticException {
        ArrayList<Variable<C, PM>> variableDeclarations = new ArrayList<Variable<C, PM>>();
        for (VariableCS next : variableDeclarationCS) {
            variableDeclarations.add(this.variableDeclarationCS(next, env, addToEnvironment));
        }
        return variableDeclarations;
    }

    protected C typeCS(TypeCS typeCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        C astNode = null;
        if (typeCS instanceof PrimitiveTypeCS) {
            astNode = this.primitiveTypeCS(((PrimitiveTypeCS)typeCS).getType(), env);
        } else if (typeCS instanceof PathNameCS) {
            astNode = env.lookupClassifier((List<String>)((PathNameCS)typeCS).getSequenceOfNames());
        } else if (typeCS instanceof CollectionTypeCS || typeCS instanceof TupleTypeCS) {
            if (typeCS instanceof CollectionTypeCS) {
                astNode = this.collectionTypeCS((CollectionTypeCS)typeCS, env);
            } else if (typeCS instanceof TupleTypeCS) {
                astNode = this.tupleTypeCS((TupleTypeCS)typeCS, env);
            }
        }
        return astNode;
    }

    protected StateExp<C, S> stateExpCS(OCLExpression<C> source, StateExpCS stateExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        Object sourceType = null;
        if (source != null) {
            sourceType = source.getType();
        }
        Object state = null;
        EList<String> statePath = stateExpCS.getSequenceOfNames();
        if (!statePath.isEmpty() && (state = (Object)env.lookupState(sourceType, (List<String>)statePath)) == null) {
            this.ERROR("stateExpCS", OCLMessages.bind(OCLMessages.NoSuchState_ERROR_, statePath, sourceType == null ? null : this.uml.getName(sourceType)));
        }
        StateExp astNode = this.oclFactory.createStateExp();
        astNode.setReferredState(state);
        astNode.setType(env.getOCLStandardLibrary().getState());
        astNode.setName(this.makeName(statePath));
        this.initStartEndPositions(astNode, stateExpCS);
        return astNode;
    }

    protected C collectionTypeCS(CollectionTypeCS collectionTypeCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        CollectionKind kind = this.collectionTypeIdentifierCS(collectionTypeCS.getCollectionTypeIdentifier());
        C type = this.typeCS(collectionTypeCS.getTypeCS(), env);
        C result = this.getCollectionType(env, kind, type);
        CollectionType astNode = (CollectionType)result;
        this.initTypePositions(astNode, collectionTypeCS.getTypeCS());
        return result;
    }

    protected CollectionKind collectionTypeIdentifierCS(CollectionTypeIdentifierEnum collectionTypeIdentifier) throws SemanticException {
        CollectionKind astNode = null;
        switch (collectionTypeIdentifier.getValue()) {
            case 1: {
                astNode = CollectionKind.SET_LITERAL;
                this.TRACE("collectionTypeIdentifierCS", "SET");
                break;
            }
            case 2: {
                astNode = CollectionKind.BAG_LITERAL;
                this.TRACE("collectionTypeIdentifierCS", "BAG");
                break;
            }
            case 3: {
                astNode = CollectionKind.SEQUENCE_LITERAL;
                this.TRACE("collectionTypeIdentifierCS", "SEQUENCE");
                break;
            }
            case 4: {
                astNode = CollectionKind.COLLECTION_LITERAL;
                this.TRACE("collectionTypeIdentifierCS", "COLLECTION");
                break;
            }
            case 5: {
                astNode = CollectionKind.ORDERED_SET_LITERAL;
                this.TRACE("collectionTypeIdentifierCS", "ORDERED_SET");
            }
        }
        return astNode;
    }

    protected C tupleTypeCS(TupleTypeCS tupleTypeCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        HashSet<String> names = new HashSet<String>();
        String nodeName = null;
        BasicEList vdcls = new BasicEList();
        List<Variable<C, PM>> variableDeclarations = this.variableDeclarationListCS((List<VariableCS>)tupleTypeCS.getVariables(), env, false);
        for (Variable<C, PM> vdcl : variableDeclarations) {
            String message;
            vdcls.add(vdcl);
            String name = vdcl.getName();
            this.TRACE("tupleTypeCS", " name = " + name);
            if (names.contains(name)) {
                message = OCLMessages.bind(OCLMessages.DuplicateNameInTuple_ERROR_, name);
                this.ERROR("tupleTypeCS", message);
                vdcl.setName(null);
            } else {
                names.add(name);
            }
            if (vdcl.getInitExpression() != null) {
                message = OCLMessages.bind(OCLMessages.InitExpNotAllowed_ERROR_, name);
                this.ERROR("tupleTypeCS", message);
            }
            if (vdcl.getType() == null) {
                message = OCLMessages.bind(OCLMessages.DeclarationType_ERROR_, name);
                this.ERROR("tupleTypeCS", message);
            }
            nodeName = nodeName == null ? "Tuple(" : String.valueOf(nodeName) + ", ";
            nodeName = String.valueOf(nodeName) + vdcl.getName() + ":" + this.uml.getName(vdcl.getType());
        }
        return this.getTupleType(env, (EList<? extends TypedElement<C>>)vdcls);
    }

    protected OCLExpression<C> oclExpressionCS(OCLExpressionCS oclExpressionCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        OCLExpression<C> astNode = null;
        if (oclExpressionCS instanceof IfExpCS) {
            astNode = this.ifExpCS((IfExpCS)oclExpressionCS, env);
        } else if (oclExpressionCS instanceof CallExpCS) {
            astNode = this.propertyCallExpCS((CallExpCS)oclExpressionCS, env);
        } else if (oclExpressionCS instanceof VariableExpCS) {
            astNode = this.variableExpCS((VariableExpCS)oclExpressionCS, env);
        } else if (oclExpressionCS instanceof LiteralExpCS) {
            astNode = this.literalExpCS((LiteralExpCS)oclExpressionCS, env);
        } else if (oclExpressionCS instanceof LetExpCS) {
            astNode = this.letExpCS((LetExpCS)oclExpressionCS, env);
        } else if (oclExpressionCS instanceof MessageExpCS) {
            astNode = this.messageExpCS((MessageExpCS)oclExpressionCS, env);
        }
        if (astNode != null) {
            astNode.setType(TypeUtil.resolveType(env, astNode.getType()));
            this.initStartEndPositions(astNode, oclExpressionCS);
        }
        return astNode;
    }

    protected OCLExpression<C> variableExpCS(VariableExpCS variableExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        OCLExpression<C> astNode = this.simpleNameCS(variableExpCS.getSimpleNameCS(), env, null);
        List<OCLExpression<C>> qualifiers = this.qualifiersCS((List<OCLExpressionCS>)variableExpCS.getArguments(), env, astNode);
        if (variableExpCS.getIsMarkedPreCS().isPre()) {
            if (astNode instanceof FeatureCallExp) {
                ((FeatureCallExp)astNode).setMarkedPre(true);
            } else {
                this.ERROR("variableExpCS", OCLMessages.IllegalAtPre_ERROR_);
            }
        }
        if (!qualifiers.isEmpty()) {
            if (astNode instanceof NavigationCallExp) {
                this.setQualifiers(env, "variableExpCS", (NavigationCallExp)astNode, qualifiers);
            } else if (astNode instanceof LoopExp && ((LoopExp)astNode).getBody() instanceof NavigationCallExp) {
                this.setQualifiers(env, "variableExpCS", (NavigationCallExp)((LoopExp)astNode).getBody(), qualifiers);
            } else {
                this.ERROR("variableExpCS", OCLMessages.bind(OCLMessages.IllegalQualifiers_ERROR_, this.computeInputString(variableExpCS)));
            }
        } else if (astNode instanceof AssociationClassCallExp) {
            this.checkNotReflexive(env, "variableExpCS", (AssociationClassCallExp)astNode);
        }
        return astNode;
    }

    protected List<OCLExpression<C>> qualifiersCS(List<OCLExpressionCS> arguments, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, OCLExpression<C> navigation) throws SemanticException {
        if (arguments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OCLExpression<C>> qualifiers = new ArrayList<OCLExpression<C>>();
        if (navigation instanceof LoopExp) {
            navigation = ((LoopExp)navigation).getBody();
        }
        if (navigation instanceof AssociationClassCallExp) {
            AssociationClassCallExp acc = (AssociationClassCallExp)navigation;
            OCLExpression source = acc.getSource();
            OCLExpressionCS arg = arguments.get(0);
            if (!(arg instanceof VariableExpCS)) {
                this.ERROR("qualifiersCS", OCLMessages.bind(OCLMessages.ParseCSTNodeType_ERROR_, "VariableExpCS", arg.eClass().getName()));
            }
            SimpleNameCS qualifier = ((VariableExpCS)arg).getSimpleNameCS();
            String simpleName = qualifier.getValue();
            P property = env.lookupProperty(source.getType(), simpleName);
            if (property == null) {
                String message = OCLMessages.bind(OCLMessages.UnrecognizedVar_ERROR_, simpleName);
                this.ERROR("qualifiersCS", message);
            }
            this.TRACE("qualifierCS", "Reference: " + simpleName);
            PropertyCallExp<C, P> ref = this.oclFactory.createPropertyCallExp();
            ref.setReferredProperty(property);
            ref.setType(TypeUtil.getPropertyType(env, source.getType(), property));
            if (source == null) {
                VariableExp<C, PM> src = this.oclFactory.createVariableExp();
                Variable<C, PM> implicitSource = env.lookupImplicitSourceForProperty(simpleName);
                src.setType(implicitSource.getType());
                src.setReferredVariable(implicitSource);
                src.setName(implicitSource.getName());
            }
            this.initStartEndPositions(ref, qualifier);
            this.initPropertyPositions(ref, qualifier);
            qualifiers.add(ref);
        } else {
            for (OCLExpressionCS arg : arguments) {
                qualifiers.add(this.oclExpressionCS(arg, env));
            }
        }
        return qualifiers;
    }

    protected IfExp<C> ifExpCS(IfExpCS ifExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        OCLExpression<C> condition = this.oclExpressionCS(ifExpCS.getCondition(), env);
        OCLExpression<C> thenExpression = this.oclExpressionCS(ifExpCS.getThenExpression(), env);
        OCLExpression<C> elseExpression = this.oclExpressionCS(ifExpCS.getElseExpression(), env);
        this.TRACE("ifExpCS", " ");
        if (condition.getType() != this.getBoolean()) {
            this.ERROR("ifExpCS", OCLMessages.bind(OCLMessages.BooleanForIf_ERROR_, this.computeInputString(ifExpCS.getCondition())));
        }
        IfExp<C> astNode = this.oclFactory.createIfExp();
        astNode.setCondition(condition);
        astNode.setThenExpression(thenExpression);
        astNode.setElseExpression(elseExpression);
        astNode.setType(TypeUtil.commonSuperType(env, thenExpression.getType(), elseExpression.getType()));
        this.initStartEndPositions(astNode, ifExpCS);
        return astNode;
    }

    protected LetExp<C, PM> letExpCS(LetExpCS letExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        return (LetExp)this.letExpCSRecursive(letExpCS, 0, env);
    }

    protected OCLExpression<C> letExpCSRecursive(LetExpCS letExpCS, int index, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        OCLExpression<C> astNode;
        if (index < letExpCS.getVariables().size()) {
            String message;
            Variable<C, PM> variableDeclaration = this.variableDeclarationCS((VariableCS)letExpCS.getVariables().get(index), env, true);
            String varName = variableDeclaration.getName();
            if (variableDeclaration.getType() == null) {
                message = OCLMessages.bind(OCLMessages.DeclarationType_ERROR_, varName);
                this.ERROR("letExpCS", message);
            }
            if (variableDeclaration.getInitExpression() == null) {
                message = OCLMessages.bind(OCLMessages.DeclarationNoInitExp_ERROR_, varName);
                this.ERROR("letExpCS", message);
            }
            OCLExpression<C> letSubExp = this.letExpCSRecursive(letExpCS, ++index, env);
            LetExp letExp = this.oclFactory.createLetExp();
            letExp.setVariable(variableDeclaration);
            letExp.setIn(letSubExp);
            letExp.setType(letSubExp.getType());
            astNode = letExp;
            env.deleteElement(varName);
        } else {
            astNode = this.oclExpressionCS(letExpCS.getInExpression(), env);
        }
        return astNode;
    }

    protected OCLExpression<C> simpleNameCS(SimpleNameCS simpleNameCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, OCLExpression<C> source) throws SemanticException {
        String simpleName = null;
        OCLExpression<Object> astNode = null;
        Object property = null;
        C classifier = null;
        PropertyCallExp propertyCall = null;
        Object assocClass = null;
        AssociationClassCallExp<C, P> acref = null;
        Variable<C, PM> vdcl = null;
        switch (simpleNameCS.getType().getValue()) {
            case 1: 
            case 2: 
            case 11: {
                simpleName = simpleNameCS.getValue();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                if (source != null) break;
                classifier = this.primitiveTypeCS(simpleNameCS.getType(), env);
                simpleName = this.uml.getName(classifier);
            }
        }
        Object sourceElementType = null;
        if (source != null && (sourceElementType = (Object)source.getType()) instanceof CollectionType) {
            CollectionType ct = (CollectionType)sourceElementType;
            sourceElementType = ct.getElementType();
        }
        ArrayList<String> names = new ArrayList<String>();
        names.add(simpleName);
        if (classifier == null && source == null) {
            classifier = env.lookupClassifier(names);
        }
        if (classifier != null) {
            TypeExp<Object> texp = this.oclFactory.createTypeExp();
            texp.setReferredType(classifier);
            texp.setType(this.getTypeType(env, classifier));
            astNode = texp;
        } else if (source == null && (vdcl = env.lookup(simpleName)) != null) {
            this.TRACE("variableExpCS", "Variable Expression: " + simpleName);
            VariableExp vexp = this.oclFactory.createVariableExp();
            vexp.setReferredVariable(vdcl);
            vexp.setName(vdcl.getName());
            vexp.setType(vdcl.getType());
            astNode = vexp;
        } else {
            P p = env.lookupProperty(sourceElementType, simpleName);
            property = p;
            if (p != null) {
                this.TRACE("variableExpCS", "Property: " + simpleName);
                propertyCall = this.oclFactory.createPropertyCallExp();
                propertyCall.setReferredProperty(property);
                propertyCall.setType(TypeUtil.getPropertyType(env, sourceElementType, property));
                if (source != null) {
                    propertyCall.setSource(source);
                } else {
                    VariableExp<C, PM> src = this.oclFactory.createVariableExp();
                    Variable<C, PM> implicitSource = env.lookupImplicitSourceForProperty(simpleName);
                    src.setType(implicitSource.getType());
                    src.setReferredVariable(implicitSource);
                    src.setName(implicitSource.getName());
                    propertyCall.setSource(src);
                }
                this.initPropertyPositions(propertyCall, simpleNameCS);
                astNode = propertyCall;
            } else {
                assocClass = env.lookupAssociationClassReference(sourceElementType, simpleName);
                if (assocClass != null) {
                    this.TRACE("variableExpCS", "Association class: " + simpleName);
                    acref = this.oclFactory.createAssociationClassCallExp();
                    acref.setReferredAssociationClass(assocClass);
                    if (source != null) {
                        acref.setSource(source);
                    } else {
                        VariableExp<C, PM> src = this.oclFactory.createVariableExp();
                        Variable<C, PM> implicitSource = env.lookupImplicitSourceForAssociationClass(simpleName);
                        src.setType(implicitSource.getType());
                        src.setReferredVariable(implicitSource);
                        src.setName(implicitSource.getName());
                        acref.setSource(src);
                    }
                    Object acrefType = null;
                    Object sourceType = this.getElementType(acref.getSource().getType());
                    List<P> ends = this.uml.getMemberEnds(assocClass);
                    List<P> available = this.uml.getAttributes(sourceType);
                    for (P end : ends) {
                        if (!available.contains(end)) continue;
                        acref.setNavigationSource(end);
                        CollectionKind kind = this.getCollectionKind(this.uml.getOCLType(end));
                        acrefType = kind != null ? this.getCollectionType(env, kind, assocClass) : assocClass;
                    }
                    if (acrefType == null) {
                        acrefType = this.getSetType(env, assocClass);
                    }
                    acref.setType(acrefType);
                    this.initPropertyPositions(acref, simpleNameCS);
                    astNode = acref;
                } else if (source != null && (vdcl = env.lookup(simpleName)) != null) {
                    String message = OCLMessages.bind(OCLMessages.VarInNavExp_ERROR_, simpleName);
                    this.ERROR("variableExpCS", message);
                } else {
                    String message = OCLMessages.bind(OCLMessages.UnrecognizedVar_ERROR_, simpleName);
                    this.ERROR("variableExpCS", message);
                }
            }
        }
        if (source != null && source.getType() instanceof CollectionType) {
            astNode = this.createImplicitCollect(source, (FeatureCallExp)astNode, env);
        }
        return astNode;
    }

    private IteratorExp<C, PM> createImplicitCollect(OCLExpression<C> source, FeatureCallExp<C> propertyCall, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        C c;
        Object sourceElementType = ((CollectionType)source.getType()).getElementType();
        IteratorExp result = this.oclFactory.createIteratorExp();
        Variable<C, PM> itervar = this.genVariableDeclaration("modelPropertyCallCS", env, null, sourceElementType, null, false, true, false);
        List iters = (List)result.getIterator();
        iters.add(itervar);
        result.setBody(propertyCall);
        result.setName("collect");
        VariableExp<C, PM> vexp = this.oclFactory.createVariableExp();
        vexp.setType(itervar.getType());
        vexp.setReferredVariable(itervar);
        vexp.setName(itervar.getName());
        propertyCall.setSource(vexp);
        if (!(propertyCall instanceof OperationCallExp)) {
            propertyCall.setStartPosition(propertyCall.getPropertyStartPosition());
            propertyCall.setEndPosition(propertyCall.getPropertyEndPosition());
        }
        result.setSource(source);
        Object bodyType = propertyCall.getType();
        if (bodyType instanceof CollectionType) {
            CollectionType ct = (CollectionType)bodyType;
            bodyType = ct.getElementType();
        }
        if (source.getType() instanceof SequenceType || source.getType() instanceof OrderedSetType) {
            c = this.getCollectionType(env, CollectionKind.SEQUENCE_LITERAL, bodyType);
            result.setType(c);
        } else {
            c = this.getCollectionType(env, CollectionKind.BAG_LITERAL, bodyType);
            result.setType(c);
        }
        env.deleteElement(itervar.getName());
        return result;
    }

    protected C primitiveTypeCS(SimpleTypeEnum simpleType, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        C astNode = null;
        switch (simpleType) {
            case INTEGER_LITERAL: {
                astNode = env.getOCLStandardLibrary().getInteger();
                break;
            }
            case UNLIMITED_NATURAL_LITERAL: {
                astNode = env.getOCLStandardLibrary().getUnlimitedNatural();
                break;
            }
            case STRING_LITERAL: {
                astNode = env.getOCLStandardLibrary().getString();
                break;
            }
            case REAL_LITERAL: {
                astNode = env.getOCLStandardLibrary().getReal();
                break;
            }
            case BOOLEAN_LITERAL: {
                astNode = env.getOCLStandardLibrary().getBoolean();
                break;
            }
            case OCL_ANY_LITERAL: {
                astNode = env.getOCLStandardLibrary().getOclAny();
                break;
            }
            case OCL_VOID_LITERAL: {
                astNode = env.getOCLStandardLibrary().getOclVoid();
                break;
            }
            case INVALID_LITERAL: {
                astNode = env.getOCLStandardLibrary().getInvalid();
                break;
            }
            case OCL_MESSAGE_LITERAL: {
                astNode = env.getOCLStandardLibrary().getOclMessage();
            }
        }
        return astNode;
    }

    protected LiteralExp<C> primitiveLiteralExpCS(PrimitiveLiteralExpCS primitiveLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        PrimitiveLiteralExp<C> astNode = null;
        if (primitiveLiteralExpCS instanceof IntegerLiteralExpCS) {
            astNode = this.integerLiteralExpCS((IntegerLiteralExpCS)primitiveLiteralExpCS, env);
        } else if (primitiveLiteralExpCS instanceof UnlimitedNaturalLiteralExpCS) {
            astNode = this.unlimitedNaturalLiteralExpCS((UnlimitedNaturalLiteralExpCS)primitiveLiteralExpCS, env);
        } else if (primitiveLiteralExpCS instanceof RealLiteralExpCS) {
            astNode = this.realLiteralExpCS((RealLiteralExpCS)primitiveLiteralExpCS, env);
        } else if (primitiveLiteralExpCS instanceof StringLiteralExpCS) {
            astNode = this.stringLiteralExpCS((StringLiteralExpCS)primitiveLiteralExpCS, env);
        } else if (primitiveLiteralExpCS instanceof BooleanLiteralExpCS) {
            astNode = this.booleanLiteralExpCS((BooleanLiteralExpCS)primitiveLiteralExpCS, env);
        }
        return astNode;
    }

    protected IntegerLiteralExp<C> integerLiteralExpCS(IntegerLiteralExpCS integerLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        IntegerLiteralExp<C> astNode = this.oclFactory.createIntegerLiteralExp();
        astNode.setIntegerSymbol(integerLiteralExpCS.getIntegerSymbol());
        astNode.setType(env.getOCLStandardLibrary().getInteger());
        astNode.setName("Integer");
        this.TRACE("integerLiteralExpCS", "Integer: " + integerLiteralExpCS.getSymbol());
        return astNode;
    }

    protected UnlimitedNaturalLiteralExp<C> unlimitedNaturalLiteralExpCS(UnlimitedNaturalLiteralExpCS unlimitedNaturalLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        UnlimitedNaturalLiteralExp<C> astNode = this.oclFactory.createUnlimitedNaturalLiteralExp();
        astNode.setIntegerSymbol(unlimitedNaturalLiteralExpCS.getIntegerSymbol());
        astNode.setType(env.getOCLStandardLibrary().getUnlimitedNatural());
        astNode.setName("UnlimitedNatural");
        this.TRACE("unlimitedNaturalLiteralExpCS", "UnlimitedNatural: " + unlimitedNaturalLiteralExpCS.getSymbol());
        return astNode;
    }

    protected RealLiteralExp<C> realLiteralExpCS(RealLiteralExpCS realLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        RealLiteralExp<C> astNode = this.oclFactory.createRealLiteralExp();
        astNode.setRealSymbol(realLiteralExpCS.getRealSymbol());
        astNode.setType(env.getOCLStandardLibrary().getReal());
        astNode.setName("Real");
        this.TRACE("realLiteralExpCS", "Real: " + realLiteralExpCS.getSymbol());
        return astNode;
    }

    protected StringLiteralExp<C> stringLiteralExpCS(StringLiteralExpCS stringLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        StringLiteralExp<C> astNode = this.oclFactory.createStringLiteralExp();
        String stringLiteral = stringLiteralExpCS.getStringSymbol();
        if (stringLiteral.length() <= 2) {
            astNode.setStringSymbol("");
        } else {
            astNode.setStringSymbol(this.processStringEscapes(stringLiteral.substring(1, stringLiteral.length() - 1)));
        }
        astNode.setType(env.getOCLStandardLibrary().getString());
        astNode.setName("String");
        this.TRACE("stringLiteralExpCS", "String: " + stringLiteralExpCS.getSymbol());
        return astNode;
    }

    private String processStringEscapes(String stringLiteral) {
        String result = stringLiteral;
        int length = stringLiteral.length();
        int i = 0;
        while (i < length) {
            if (stringLiteral.charAt(i) == '\'') {
                StringBuilder buf = new StringBuilder(length);
                buf.append(stringLiteral, 0, i);
                while (i < length) {
                    char c = stringLiteral.charAt(i);
                    if (c != '\'') {
                        buf.append(c);
                    } else if (++i >= length) {
                        buf.append('\'');
                    } else {
                        c = stringLiteral.charAt(i);
                        switch (c) {
                            case '\'': {
                                buf.append('\'');
                                break;
                            }
                            default: {
                                buf.append('\'');
                                buf.append(c);
                            }
                        }
                    }
                    ++i;
                }
                result = buf.toString();
            }
            ++i;
        }
        return result;
    }

    protected BooleanLiteralExp<C> booleanLiteralExpCS(BooleanLiteralExpCS booleanLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        BooleanLiteralExp<C> astNode = this.oclFactory.createBooleanLiteralExp();
        astNode.setBooleanSymbol(booleanLiteralExpCS.getBooleanSymbol());
        astNode.setType(env.getOCLStandardLibrary().getBoolean());
        astNode.setName("Boolean");
        this.TRACE("booleanLiteralExpCS", "Boolean: " + booleanLiteralExpCS.getSymbol());
        return astNode;
    }

    protected NullLiteralExp<C> nullLiteralExpCS(NullLiteralExpCS nullLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        NullLiteralExp<C> astNode = this.oclFactory.createNullLiteralExp();
        astNode.setType(env.getOCLStandardLibrary().getOclVoid());
        astNode.setName("OclVoid");
        this.TRACE("nullLiteralExpCS", "OclVoid: null");
        return astNode;
    }

    protected InvalidLiteralExp<C> invalidLiteralExpCS(InvalidLiteralExpCS nullLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        InvalidLiteralExp<C> astNode = this.oclFactory.createInvalidLiteralExp();
        astNode.setType(env.getOCLStandardLibrary().getInvalid());
        astNode.setName("Invalid");
        this.TRACE("invalidLiteralExpCS", "Invalid: OclInvalid");
        return astNode;
    }

    protected OCLExpression<C> literalExpCS(LiteralExpCS literalExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        OCLExpression<C> astNode = null;
        if (literalExpCS instanceof PrimitiveLiteralExpCS) {
            astNode = this.primitiveLiteralExpCS((PrimitiveLiteralExpCS)literalExpCS, env);
        } else if (literalExpCS instanceof CollectionLiteralExpCS) {
            astNode = this.collectionLiteralExpCS((CollectionLiteralExpCS)literalExpCS, env);
        } else if (literalExpCS instanceof TupleLiteralExpCS) {
            astNode = this.tupleLiteralExpCS((TupleLiteralExpCS)literalExpCS, env);
        } else if (literalExpCS instanceof EnumLiteralExpCS) {
            astNode = this.enumLiteralExpCS((EnumLiteralExpCS)literalExpCS, env);
        } else if (literalExpCS instanceof NullLiteralExpCS) {
            astNode = this.nullLiteralExpCS((NullLiteralExpCS)literalExpCS, env);
        } else if (literalExpCS instanceof InvalidLiteralExpCS) {
            astNode = this.invalidLiteralExpCS((InvalidLiteralExpCS)literalExpCS, env);
        }
        return astNode;
    }

    protected TupleLiteralExp<C, P> tupleLiteralExpCS(TupleLiteralExpCS tupleLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        HashSet<String> names = new HashSet<String>();
        String nodeName = null;
        TupleLiteralExp astNode = this.oclFactory.createTupleLiteralExp();
        EList tupleParts = astNode.getPart();
        this.TRACE("tupleLiteralExpCS", "Tuple");
        EList<TupleLiteralPart<C, P>> tupleLiteralParts = this.tupleLiteralPartListCS((List<VariableCS>)tupleLiteralExpCS.getVariables(), env);
        for (TupleLiteralPart part : tupleLiteralParts) {
            String message;
            tupleParts.add((Object)part);
            String name = part.getName();
            this.TRACE("tupleLiteralExpCS", " name = " + name);
            if (names.contains(name)) {
                message = OCLMessages.bind(OCLMessages.DuplicateNameInTuple_ERROR_, name);
                this.ERROR("tupleLiteralPartCS", message);
                part.setName(null);
            } else {
                names.add(name);
            }
            if (part.getValue() == null) {
                message = OCLMessages.bind(OCLMessages.MissingTypeInTupleLiteralPart_ERROR_, name, this.computeInputString(tupleLiteralExpCS));
                this.ERROR("tupleLiteralExpCS", message);
            }
            if (part.getType() == null) {
                part.setType(part.getValue().getType());
            }
            nodeName = nodeName == null ? "Tuple{" : String.valueOf(nodeName) + ", ";
            nodeName = String.valueOf(nodeName) + part.getName() + ":" + this.uml.getName(part.getType());
        }
        C tt = this.getTupleType(env, tupleParts);
        astNode.setType(tt);
        for (TupleLiteralPart part : tupleParts) {
            part.setAttribute(env.lookupProperty(tt, part.getName()));
        }
        return astNode;
    }

    private EList<TupleLiteralPart<C, P>> tupleLiteralPartListCS(List<VariableCS> variableDeclarations, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        BasicEList result = new BasicEList();
        Iterator<VariableCS> i = variableDeclarations.iterator();
        while (i.hasNext()) {
            result.add(this.tupleLiteralPartCS(i.next(), env));
        }
        return result;
    }

    private TupleLiteralPart<C, P> tupleLiteralPartCS(VariableCS variableDeclarationCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        String varName = variableDeclarationCS.getName();
        Object type = null;
        if (variableDeclarationCS.getTypeCS() != null) {
            type = this.typeCS(variableDeclarationCS.getTypeCS(), env);
        }
        OCLExpression<C> expr = null;
        if (variableDeclarationCS.getInitExpression() != null) {
            expr = this.oclExpressionCS(variableDeclarationCS.getInitExpression(), env);
        }
        TupleLiteralPart astNode = this.oclFactory.createTupleLiteralPart();
        astNode.setName(varName);
        astNode.setType(type);
        astNode.setValue(expr);
        this.initStartEndPositions(astNode, variableDeclarationCS);
        if (variableDeclarationCS.getTypeCS() != null) {
            this.initTypePositions(astNode, variableDeclarationCS.getTypeCS());
        }
        return astNode;
    }

    protected OCLExpression<C> enumLiteralExpCS(EnumLiteralExpCS enumLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        String message;
        C type;
        OCLExpression<C> astNode = null;
        BasicEList sequenceOfNames = new BasicEList(enumLiteralExpCS.getPathNameCS().getSequenceOfNames());
        String lastToken = enumLiteralExpCS.getSimpleNameCS().getValue();
        Object literal = null;
        Object attribute = null;
        C enumType = env.lookupClassifier((List<String>)sequenceOfNames);
        if (enumType == null) {
            sequenceOfNames.add((Object)lastToken);
            type = env.lookupClassifier((List<String>)sequenceOfNames);
            if (type == null) {
                message = OCLMessages.bind(OCLMessages.UnrecognizedType_ERROR_, sequenceOfNames);
                this.ERROR("enumerationOrClassLiteralExpCS", message);
            } else {
                astNode = this.typeCS(type, env);
            }
        } else {
            if (this.uml.isEnumeration(enumType)) {
                literal = this.uml.getEnumerationLiteral(enumType, lastToken);
                if (literal == null && OCLParser.isEscaped(lastToken)) {
                    literal = this.uml.getEnumerationLiteral(enumType, OCLParser.unescape(lastToken));
                }
                if (literal == null) {
                    attribute = env.lookupProperty(enumType, lastToken);
                }
            } else {
                attribute = env.lookupProperty(enumType, lastToken);
            }
            if (literal != null) {
                astNode = this.oclFactory.createEnumLiteralExp();
                EnumLiteralExp litExp = (EnumLiteralExp)astNode;
                litExp.setReferredEnumLiteral(literal);
                astNode = litExp;
                if (enumType == null || literal == null) {
                    astNode.setType(env.getOCLStandardLibrary().getInvalid());
                } else {
                    astNode.setType(enumType);
                }
            } else if (attribute != null) {
                if (!this.uml.isStatic(attribute)) {
                    String message2 = OCLMessages.bind(OCLMessages.NonStaticAttribute_ERROR_, lastToken);
                    this.ERROR("enumerationOrClassLiteralExpCS", message2);
                }
                PropertyCallExp pcExp = this.oclFactory.createPropertyCallExp();
                astNode = pcExp;
                TypeExp<C> typeExp = this.typeCS(enumType, env);
                this.initStartEndPositions(typeExp, enumLiteralExpCS.getPathNameCS());
                pcExp.setSource(typeExp);
                pcExp.setReferredProperty(attribute);
                pcExp.setType(TypeUtil.getPropertyType(env, enumType, attribute));
                pcExp.setName(lastToken);
                this.initPropertyPositions(pcExp, enumLiteralExpCS.getSimpleNameCS());
            } else {
                sequenceOfNames.add((Object)lastToken);
                type = env.lookupClassifier((List<String>)sequenceOfNames);
                if (type == null) {
                    message = OCLMessages.bind(OCLMessages.UnrecognizedEnum_ERROR_, lastToken);
                    this.ERROR("enumerationOrClassLiteralExpCS", message);
                } else {
                    astNode = this.typeCS(type, env);
                }
            }
        }
        String traceText = new String();
        for (String next : sequenceOfNames) {
            traceText = String.valueOf(traceText) + next + "::";
        }
        traceText = String.valueOf(traceText) + lastToken;
        this.TRACE("enumerationOrClassLiteralExpCS", traceText);
        return astNode;
    }

    private TypeExp<C> typeCS(C type, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        TypeExp<C> astNode = this.oclFactory.createTypeExp();
        astNode.setReferredType(type);
        astNode.setType(this.getTypeType(env, type));
        return astNode;
    }

    protected CollectionLiteralExp<C> collectionLiteralExpCS(CollectionLiteralExpCS collectionLiteralExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        CollectionLiteralExp astNode = null;
        CollectionKind kind = null;
        CollectionLiteralPart<C> collectionLiteralPartExp = null;
        List collectionParts = null;
        Object type = null;
        Object resultType = null;
        kind = this.collectionTypeIdentifierCS(collectionLiteralExpCS.getCollectionType());
        astNode = this.oclFactory.createCollectionLiteralExp();
        astNode.setKind(kind);
        collectionParts = (List)astNode.getPart();
        EList<CollectionLiteralPartCS> collectionLiteralPartsCS = collectionLiteralExpCS.getCollectionLiteralParts();
        if (!collectionLiteralPartsCS.isEmpty()) {
            Iterator i = collectionLiteralPartsCS.iterator();
            CollectionLiteralPartCS colPart = (CollectionLiteralPartCS)i.next();
            collectionLiteralPartExp = this.collectionLiteralPartCS(colPart, env);
            collectionParts.add(collectionLiteralPartExp);
            type = collectionLiteralPartExp.getType();
            while (i.hasNext()) {
                collectionLiteralPartExp = this.collectionLiteralPartCS((CollectionLiteralPartCS)i.next(), env);
                Object type1 = collectionLiteralPartExp.getType();
                type = TypeUtil.commonSuperType(env, type, type1);
                collectionParts.add(collectionLiteralPartExp);
            }
        }
        resultType = collectionParts.isEmpty() ? (Object)this.getCollectionType(env, kind, env.getOCLStandardLibrary().getOclVoid()) : this.getCollectionType(env, kind, type);
        astNode.setType(resultType);
        return astNode;
    }

    protected CollectionLiteralPart<C> collectionLiteralPartCS(CollectionLiteralPartCS collectionLiteralPartCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        CollectionLiteralPart<C> astNode = null;
        OCLExpression<C> expr1 = null;
        OCLExpression<C> expr2 = null;
        CollectionRange collRange = null;
        CollectionItem<C> collItem = null;
        expr1 = this.oclExpressionCS(collectionLiteralPartCS.getExpressionCS(), env);
        if (collectionLiteralPartCS instanceof CollectionRangeCS) {
            CollectionRangeCS collectionRangeCS = (CollectionRangeCS)collectionLiteralPartCS;
            expr2 = this.oclExpressionCS(collectionRangeCS.getLastExpressionCS(), env);
            collRange = this.oclFactory.createCollectionRange();
            collRange.setFirst(expr1);
            collRange.setLast(expr2);
            collRange.setType(expr1.getType());
            if (expr1.getType() != expr2.getType()) {
                this.ERROR("collectionLiteralPartCS", OCLMessages.bind(OCLMessages.FirstLastTypeMismatch_ERROR_, this.computeInputString(collectionLiteralPartCS)));
            }
            astNode = collRange;
            this.TRACE("collectionLiteralPartCS", "collection range");
        } else {
            collItem = this.oclFactory.createCollectionItem();
            collItem.setType(expr1.getType());
            collItem.setItem(expr1);
            astNode = collItem;
            this.TRACE("collectionLiteralPartCS", "collection item");
        }
        return astNode;
    }

    protected OCLExpression<C> propertyCallExpCS(CallExpCS propertyCallExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        OCLExpression astNode = null;
        if (propertyCallExpCS instanceof LoopExpCS) {
            astNode = this.loopExpCS((LoopExpCS)propertyCallExpCS, env);
        } else if (propertyCallExpCS instanceof FeatureCallExpCS) {
            astNode = this.modelPropertyCallExpCS((FeatureCallExpCS)propertyCallExpCS, env);
        }
        this.initStartEndPositions(astNode, propertyCallExpCS);
        return astNode;
    }

    protected LoopExp<C, PM> loopExpCS(LoopExpCS loopExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        LoopExp<C, PM> astNode = null;
        if (loopExpCS instanceof IteratorExpCS) {
            astNode = this.iteratorExpCS((IteratorExpCS)loopExpCS, env);
        } else if (loopExpCS instanceof IterateExpCS) {
            astNode = this.iterateExpCS((IterateExpCS)loopExpCS, env);
        }
        return astNode;
    }

    protected OCLExpression<C> getCollectionSourceExpression(OCLExpressionCS oclExpressionCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        OCLExpression<C> astNode = this.oclExpressionCS(oclExpressionCS, env);
        if (!(astNode.getType() instanceof CollectionType)) {
            CollectionLiteralExp<C> astNode1 = this.oclFactory.createCollectionLiteralExp();
            astNode1.setKind(CollectionKind.SET_LITERAL);
            List collectionParts = (List)astNode1.getPart();
            CollectionItem<C> collItem = this.oclFactory.createCollectionItem();
            collItem.setType(astNode.getType());
            collItem.setItem(astNode);
            collectionParts.add(collItem);
            C type = this.getCollectionType(env, astNode1.getKind(), astNode.getType());
            astNode1.setType(type);
            astNode = astNode1;
        }
        return astNode;
    }

    protected IteratorExp<C, PM> iteratorExpCS(IteratorExpCS iteratorExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        CollectionType ct;
        CollectionType ct2;
        IteratorExp astNode;
        OCLExpression<C> source = this.getCollectionSourceExpression(iteratorExpCS.getSource(), env);
        String name = iteratorExpCS.getSimpleNameCS().getValue();
        Variable vdcl = null;
        Variable vdcl1 = null;
        OCLExpression<C> expr = null;
        List iterators = null;
        if (iteratorExpCS.getVariable1() != null) {
            Object sourceType;
            vdcl = this.variableDeclarationCS(iteratorExpCS.getVariable1(), env, true);
            astNode = this.oclFactory.createIteratorExp();
            astNode.setName(name);
            iterators = (List)astNode.getIterator();
            if (vdcl.getType() == null && (sourceType = source.getType()) instanceof CollectionType) {
                ct2 = (CollectionType)sourceType;
                vdcl.setType(ct2.getElementType());
            }
            iterators.add(vdcl);
            if (iteratorExpCS.getVariable2() != null) {
                vdcl1 = this.variableDeclarationCS(iteratorExpCS.getVariable2(), env, true);
                if (vdcl1.getType() == null && (sourceType = source.getType()) instanceof CollectionType) {
                    ct2 = (CollectionType)sourceType;
                    vdcl1.setType(ct2.getElementType());
                }
                iterators.add(vdcl1);
            }
        } else {
            astNode = this.oclFactory.createIteratorExp();
            astNode.setName(name);
            iterators = (List)astNode.getIterator();
            ct = (CollectionType)source.getType();
            vdcl = this.genVariableDeclaration("iteratorExpCS", env, null, ct.getElementType(), null, false, true, false);
            iterators.add(vdcl);
        }
        expr = this.oclExpressionCS(iteratorExpCS.getBody(), env);
        this.TRACE("oclIteratorExpCS: ", name);
        if (name.equals("forAll") || name.equals("exists") || name.equals("one") || name.equals("isUnique")) {
            astNode.setType(env.getOCLStandardLibrary().getBoolean());
        } else if (name.equals("select") || name.equals("reject")) {
            astNode.setType(source.getType());
        } else if (name.equals("collect")) {
            Object elementType = expr.getType();
            while (elementType instanceof CollectionType) {
                ct2 = (CollectionType)elementType;
                elementType = ct2.getElementType();
            }
            if (source.getType() instanceof SequenceType || source.getType() instanceof OrderedSetType) {
                astNode.setType(this.getSequenceType(env, elementType));
            } else {
                astNode.setType(this.getBagType(env, elementType));
            }
        } else if (name.equals("collectNested")) {
            if (source.getType() instanceof SequenceType || source.getType() instanceof OrderedSetType) {
                astNode.setType(this.getSequenceType(env, expr.getType()));
            } else {
                astNode.setType(this.getBagType(env, expr.getType()));
            }
        } else if (name.equals("any")) {
            ct = (CollectionType)source.getType();
            astNode.setType(ct.getElementType());
        } else if (name.equals("sortedBy")) {
            if (source.getType() instanceof SequenceType || source.getType() instanceof BagType) {
                ct = (CollectionType)source.getType();
                astNode.setType(this.getSequenceType(env, ct.getElementType()));
            } else {
                ct = (CollectionType)source.getType();
                astNode.setType(this.getOrderedSetType(env, ct.getElementType()));
            }
        } else if (name.equals("closure")) {
            Object bodyType = expr.getType();
            if (bodyType instanceof CollectionType) {
                ct2 = (CollectionType)bodyType;
                bodyType = ct2.getElementType();
            }
            astNode.setType(this.getSetType(env, bodyType));
        }
        astNode.setBody(expr);
        astNode.setSource(source);
        env.deleteElement(vdcl.getName());
        if (vdcl1 != null) {
            env.deleteElement(vdcl1.getName());
        }
        return astNode;
    }

    protected IterateExp<C, PM> iterateExpCS(IterateExpCS iterateExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        String message;
        CollectionType ct;
        IterateExp astNode = null;
        OCLExpression<C> source = this.getCollectionSourceExpression(iterateExpCS.getSource(), env);
        Variable vdcl = null;
        Variable vdcl1 = null;
        OCLExpression<C> expr = null;
        vdcl = this.variableDeclarationCS(iterateExpCS.getVariable1(), env, true);
        if (iterateExpCS.getVariable2() != null) {
            vdcl1 = this.variableDeclarationCS(iterateExpCS.getVariable2(), env, true);
        }
        if (vdcl1 == null) {
            vdcl1 = vdcl;
            vdcl = null;
        }
        if (vdcl == null) {
            ct = (CollectionType)source.getType();
            vdcl = this.genVariableDeclaration("iterateExpCS", env, null, ct.getElementType(), null, false, true, false);
        }
        if (vdcl.getType() == null) {
            ct = (CollectionType)source.getType();
            vdcl.setType(ct.getElementType());
        }
        expr = this.oclExpressionCS(iterateExpCS.getBody(), env);
        this.TRACE("iterateExpCS", "iterate");
        astNode = this.oclFactory.createIterateExp();
        astNode.setName("iterate");
        List iterator = (List)astNode.getIterator();
        iterator.add(vdcl);
        astNode.setSource(source);
        astNode.setResult(vdcl1);
        astNode.setBody(expr);
        if (vdcl1.getType() == null) {
            message = OCLMessages.bind(OCLMessages.DeclarationType_ERROR_, vdcl1.getName());
            this.ERROR("iterateExpCS", message);
        }
        astNode.setType(vdcl1.getType());
        if (vdcl1.getInitExpression() == null) {
            message = OCLMessages.bind(OCLMessages.DeclarationNoInitExp_ERROR_, vdcl1.getName());
            this.ERROR("iterateExpCS", message);
        }
        if (vdcl.getInitExpression() != null) {
            message = OCLMessages.bind(OCLMessages.DeclarationInitExp_ERROR_, vdcl1.getName());
            this.ERROR("iterateExpCS", message);
        }
        env.deleteElement(vdcl.getName());
        env.deleteElement(vdcl1.getName());
        return astNode;
    }

    protected OCLExpression<C> modelPropertyCallExpCS(FeatureCallExpCS modelPropertyCallExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        OCLExpression<C> astNode = null;
        if (modelPropertyCallExpCS instanceof OperationCallExpCS) {
            astNode = this.operationCallExpCS((OperationCallExpCS)modelPropertyCallExpCS, env);
        } else {
            OCLExpression<C> source = this.oclExpressionCS(modelPropertyCallExpCS.getSource(), env);
            astNode = this.simpleNameCS(modelPropertyCallExpCS.getSimpleNameCS(), env, source);
            List<OCLExpression<C>> qualifiers = this.qualifiersCS((List<OCLExpressionCS>)modelPropertyCallExpCS.getArguments(), env, astNode);
            if (modelPropertyCallExpCS.getIsMarkedPreCS().isPre()) {
                if (astNode instanceof FeatureCallExp) {
                    ((FeatureCallExp)astNode).setMarkedPre(true);
                } else {
                    this.ERROR("modelPropertyCallExpCS", OCLMessages.IllegalAtPre_ERROR_);
                }
            }
            if (!qualifiers.isEmpty()) {
                if (astNode instanceof NavigationCallExp) {
                    this.setQualifiers(env, "modelPropertyCallExpCS", (NavigationCallExp)astNode, qualifiers);
                } else if (astNode instanceof LoopExp && this.getLoopBody(astNode) instanceof NavigationCallExp) {
                    NavigationCallExp nav = (NavigationCallExp)this.getLoopBody(astNode);
                    this.setQualifiers(env, "modelPropertyCallExpCS", nav, qualifiers);
                } else {
                    this.ERROR("modelPropertyCallExpCS", OCLMessages.bind(OCLMessages.IllegalQualifiers_ERROR_, this.computeInputString(modelPropertyCallExpCS)));
                }
            } else if (astNode instanceof AssociationClassCallExp) {
                this.checkNotReflexive(env, "modelPropertyCallExpCS", (AssociationClassCallExp)astNode);
            }
        }
        return astNode;
    }

    private OCLExpression<C> getLoopBody(OCLExpression<C> expr) {
        return ((LoopExp)expr).getBody();
    }

    protected OCLExpression<C> operationCallExpCS(OperationCallExpCS operationCallExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        boolean isImplicitCollect;
        OperationCallExp<C, O> astNode = null;
        ArrayList<OCLExpression<C>> args = new ArrayList<OCLExpression<C>>();
        String name = operationCallExpCS.getSimpleNameCS().getValue();
        int operator = operationCallExpCS.getAccessor().getValue();
        OCLExpression<C> source = null;
        if (operator == 3) {
            source = this.getCollectionSourceExpression(operationCallExpCS.getSource(), env);
        } else {
            OCLExpressionCS sourceCS = operationCallExpCS.getSource();
            if (sourceCS instanceof PathNameCS) {
                PathNameCS pathName = (PathNameCS)sourceCS;
                Object sourceType = env.lookupClassifier((List<String>)pathName.getSequenceOfNames());
                if (sourceType == null) {
                    String message = OCLMessages.bind(OCLMessages.UnrecognizedType_ERROR_, pathName.getSequenceOfNames());
                    this.ERROR("operatonCallExpCS", message);
                } else {
                    source = this.typeCS(sourceType, env);
                }
            } else {
                source = this.oclExpressionCS(operationCallExpCS.getSource(), env);
            }
        }
        String operationName = operationCallExpCS.getSimpleNameCS().getValue();
        if ("oclIsInState".equals(operationName)) {
            OCLExpressionCS arg;
            if (operationCallExpCS.getArguments().size() != 1) {
                this.ERROR("operationCallExpCS", OCLMessages.bind(OCLMessages.IsInStateSignature_ERROR_, this.computeInputString(operationCallExpCS)));
            }
            if (!((arg = (OCLExpressionCS)operationCallExpCS.getArguments().get(0)) instanceof StateExpCS)) {
                this.ERROR("operationCallExpCS", OCLMessages.bind(OCLMessages.IsInStateSignature_ERROR_, this.computeInputString(operationCallExpCS)));
            }
            args.add(this.stateExpCS(source, (StateExpCS)arg, env));
        } else {
            for (OCLExpressionCS arg : operationCallExpCS.getArguments()) {
                args.add(this.oclExpressionCS(arg, env));
            }
        }
        if (source == null) {
            VariableExp<C, PM> vexp = this.oclFactory.createVariableExp();
            Variable<C, PM> implicitSource = env.lookupImplicitSourceForOperation(operationName, args);
            if (implicitSource == null) {
                String errMessage = String.valueOf(name) + "(";
                int i = 0;
                while (i < args.size()) {
                    if (i > 0) {
                        errMessage = String.valueOf(errMessage) + ", ";
                    }
                    errMessage = String.valueOf(errMessage) + this.uml.getName(((OCLExpression)args.get(i)).getType());
                    ++i;
                }
                errMessage = String.valueOf(errMessage) + ")";
                String message = OCLMessages.bind(OCLMessages.IllegalSignature_ERROR_, errMessage);
                OCLParser.ERR(message);
            }
            vexp.setType(implicitSource.getType());
            vexp.setReferredVariable(implicitSource);
            vexp.setName(implicitSource.getName());
            source = vexp;
        }
        Object operationSourceType = source.getType();
        boolean bl = isImplicitCollect = operator == 2 && operationSourceType instanceof CollectionType;
        if (isImplicitCollect) {
            CollectionType ct = (CollectionType)operationSourceType;
            operationSourceType = ct.getElementType();
        }
        boolean isStatic = operationSourceType instanceof TypeType;
        astNode = this.genOperationCallExp(env, "operationCallExpCS", operationName, source, operationSourceType, args);
        if (isStatic) {
            TypeType typeType = (TypeType)operationSourceType;
            O operation = astNode.getReferredOperation();
            if (!typeType.oclOperations().contains(operation) && !this.uml.isStatic(operation)) {
                String message = OCLMessages.bind(OCLMessages.NonStaticOperation_ERROR_, operationName);
                this.ERROR("operationCallExpCS", message);
            }
        }
        astNode.setMarkedPre(operationCallExpCS.getIsMarkedPreCS().isPre());
        this.initPropertyPositions(astNode, operationCallExpCS.getSimpleNameCS());
        CallExp result = astNode;
        if (isImplicitCollect) {
            result = this.createImplicitCollect(source, astNode, env);
        }
        return result;
    }

    protected OCLExpression<C> messageExpCS(MessageExpCS messageExpCS, Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) throws SemanticException {
        EObject behavioralFeature;
        EList arguments;
        OCLExpression target = this.oclExpressionCS(messageExpCS.getTarget(), env);
        String name = messageExpCS.getSimpleNameCS().getValue();
        EList<OCLMessageArgCS> argsCS = messageExpCS.getArguments();
        if (argsCS.isEmpty()) {
            arguments = ECollections.emptyEList();
        } else {
            arguments = new BasicEList();
            for (OCLMessageArgCS argCS : argsCS) {
                OCLExpression arg;
                if (argCS.getExpression() == null) {
                    arg = this.oclFactory.createUnspecifiedValueExp();
                    this.initStartEndPositions(arg, argCS);
                    if (argCS.getTypeCS() == null) {
                        arg.setType(env.getOCLStandardLibrary().getOclVoid());
                    } else {
                        arg.setType(this.typeCS(argCS.getTypeCS(), env));
                        this.initTypePositions((UnspecifiedValueExp)arg, argCS.getTypeCS());
                    }
                } else {
                    arg = this.oclExpressionCS(argCS.getExpression(), env);
                }
                arguments.add(arg);
            }
        }
        O calledOperation = env.lookupOperation(target.getType(), name, arguments);
        Object receivedSignal = env.lookupSignal(target.getType(), name, arguments);
        if (calledOperation == null && receivedSignal == null) {
            this.ERROR("messageExpCS", OCLMessages.bind(OCLMessages.UnrecognizedMessageType_ERROR_, name));
        } else if (calledOperation != null && receivedSignal != null) {
            this.ERROR("messageExpCS", OCLMessages.bind(OCLMessages.AmbiguousMessageType_ERROR_, name));
        }
        MessageExp result = this.oclFactory.createMessageExp();
        this.initStartEndPositions(result, messageExpCS);
        this.initPropertyPositions(result, messageExpCS.getSimpleNameCS());
        result.setTarget(target);
        result.getArgument().addAll((Collection)arguments);
        if (calledOperation != null) {
            COA callAction = this.uml.createCallOperationAction(calledOperation);
            result.setCalledOperation(callAction);
            behavioralFeature = (EObject)calledOperation;
        } else {
            SSA sendAction = this.uml.createSendSignalAction(receivedSignal);
            result.setSentSignal(sendAction);
            behavioralFeature = (EObject)receivedSignal;
        }
        if (messageExpCS.getKind() == MessageExpKind.HAS_SENT_LITERAL) {
            result.setType(env.getOCLStandardLibrary().getBoolean());
        } else if (this.uml.isOperation(behavioralFeature)) {
            result.setType(this.getSequenceType(env, this.getOperationMessageType(env, calledOperation)));
        } else {
            result.setType(this.getSequenceType(env, this.getSignalMessageType(env, receivedSignal)));
        }
        return result;
    }

    private C getSetType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C elementType) {
        return TypeUtil.resolveSetType(env, elementType);
    }

    private C getOrderedSetType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C elementType) {
        return TypeUtil.resolveOrderedSetType(env, elementType);
    }

    private C getBagType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C elementType) {
        return TypeUtil.resolveBagType(env, elementType);
    }

    private C getSequenceType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C elementType) {
        return TypeUtil.resolveSequenceType(env, elementType);
    }

    private C getCollectionType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, CollectionKind kind, C elementType) {
        return TypeUtil.resolveCollectionType(env, kind, elementType);
    }

    private C getTupleType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, EList<? extends TypedElement<C>> parts) {
        return TypeUtil.resolveTupleType(env, parts);
    }

    private C getTypeType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C type) {
        return TypeUtil.resolveTypeType(env, type);
    }

    private C getOperationMessageType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, O operation) {
        return TypeUtil.resolveOperationMessageType(env, operation);
    }

    private C getSignalMessageType(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env, C signal) {
        return TypeUtil.resolveSignalMessageType(env, signal);
    }

    private C getElementType(C possibleCollectionType) {
        if (possibleCollectionType instanceof CollectionType) {
            return ((CollectionType)possibleCollectionType).getElementType();
        }
        return possibleCollectionType;
    }

    private CollectionKind getCollectionKind(C possibleCollectionType) {
        if (possibleCollectionType instanceof CollectionType) {
            return ((CollectionType)possibleCollectionType).getKind();
        }
        return null;
    }

    public static boolean isEscaped(String name) {
        return name != null && name.startsWith(OCL_ESCAPE_PREFIX);
    }

    public static String unescape(String name) {
        return name.substring(OCL_ESCAPE_LENGTH);
    }

    public static boolean equalName(String name, String elementName) {
        boolean result = name.equals(elementName);
        if (!result && OCLParser.isEscaped(name)) {
            result = OCLParser.unescape(name).equals(elementName);
        }
        return result;
    }
}

