/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.NormalizerImpl;
import com.ibm.icu.impl.RuleCharacterIterator;
import com.ibm.icu.impl.SortedSetRelation;
import com.ibm.icu.impl.UBiDiProps;
import com.ibm.icu.impl.UCaseProps;
import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.impl.UPropertyAliases;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.SymbolTable;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeFilter;
import com.ibm.icu.text.UnicodeMatcher;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import java.io.IOException;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.TreeSet;

public class UnicodeSet
extends UnicodeFilter
implements Freezable {
    private static final int LOW = 0;
    private static final int HIGH = 0x110000;
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 0x10FFFF;
    private int len;
    private int[] list;
    private int[] rangeList;
    private int[] buffer;
    TreeSet strings = new TreeSet();
    private String pat = null;
    private static final int START_EXTRA = 16;
    private static final int GROW_EXTRA = 16;
    private static final String ANY_ID = "ANY";
    private static final String ASCII_ID = "ASCII";
    private static final String ASSIGNED = "Assigned";
    private static UnicodeSet[] INCLUSIONS = null;
    static final VersionInfo NO_VERSION = VersionInfo.getInstance(0, 0, 0, 0);
    public static final int IGNORE_SPACE = 1;
    public static final int CASE = 2;
    public static final int CASE_INSENSITIVE = 2;
    public static final int ADD_CASE_MAPPINGS = 4;
    private boolean frozen;

    public UnicodeSet() {
        this.list = new int[17];
        this.list[this.len++] = 0x110000;
    }

    public UnicodeSet(UnicodeSet other) {
        this.set(other);
    }

    public UnicodeSet(int start, int end) {
        this();
        this.complement(start, end);
    }

    public UnicodeSet(String pattern) {
        this();
        this.applyPattern(pattern, null, null, 1);
    }

    public UnicodeSet(String pattern, boolean ignoreWhitespace) {
        this();
        this.applyPattern(pattern, null, null, ignoreWhitespace ? 1 : 0);
    }

    public UnicodeSet(String pattern, int options) {
        this();
        this.applyPattern(pattern, null, null, options);
    }

    public UnicodeSet(String pattern, ParsePosition pos, SymbolTable symbols) {
        this();
        this.applyPattern(pattern, pos, symbols, 1);
    }

    public UnicodeSet(String pattern, ParsePosition pos, SymbolTable symbols, int options) {
        this();
        this.applyPattern(pattern, pos, symbols, options);
    }

    public Object clone() {
        UnicodeSet result = new UnicodeSet(this);
        result.frozen = this.frozen;
        return result;
    }

    public UnicodeSet set(int start, int end) {
        this.checkFrozen();
        this.clear();
        this.complement(start, end);
        return this;
    }

    public UnicodeSet set(UnicodeSet other) {
        this.checkFrozen();
        this.list = (int[])other.list.clone();
        this.len = other.len;
        this.pat = other.pat;
        this.strings = (TreeSet)other.strings.clone();
        return this;
    }

    public final UnicodeSet applyPattern(String pattern) {
        this.checkFrozen();
        return this.applyPattern(pattern, null, null, 1);
    }

    public UnicodeSet applyPattern(String pattern, boolean ignoreWhitespace) {
        this.checkFrozen();
        return this.applyPattern(pattern, null, null, ignoreWhitespace ? 1 : 0);
    }

    public UnicodeSet applyPattern(String pattern, int options) {
        this.checkFrozen();
        return this.applyPattern(pattern, null, null, options);
    }

    public static boolean resemblesPattern(String pattern, int pos) {
        return pos + 1 < pattern.length() && pattern.charAt(pos) == '[' || UnicodeSet.resemblesPropertyPattern(pattern, pos);
    }

    private static void _appendToPat(StringBuffer buf, String s, boolean escapeUnprintable) {
        int i = 0;
        while (i < s.length()) {
            UnicodeSet._appendToPat(buf, UTF16.charAt(s, i), escapeUnprintable);
            i += UTF16.getCharCount(i);
        }
    }

    private static void _appendToPat(StringBuffer buf, int c, boolean escapeUnprintable) {
        if (escapeUnprintable && Utility.isUnprintable(c) && Utility.escapeUnprintable(buf, c)) {
            return;
        }
        switch (c) {
            case 36: 
            case 38: 
            case 45: 
            case 58: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 123: 
            case 125: {
                buf.append('\\');
                break;
            }
            default: {
                if (!UCharacterProperty.isRuleWhiteSpace(c)) break;
                buf.append('\\');
            }
        }
        UTF16.append(buf, c);
    }

    public String toPattern(boolean escapeUnprintable) {
        StringBuffer result = new StringBuffer();
        return this._toPattern(result, escapeUnprintable).toString();
    }

    private StringBuffer _toPattern(StringBuffer result, boolean escapeUnprintable) {
        if (this.pat != null) {
            int backslashCount = 0;
            int i = 0;
            while (i < this.pat.length()) {
                int c = UTF16.charAt(this.pat, i);
                i += UTF16.getCharCount(c);
                if (escapeUnprintable && Utility.isUnprintable(c)) {
                    if (backslashCount % 2 == 1) {
                        result.setLength(result.length() - 1);
                    }
                    Utility.escapeUnprintable(result, c);
                    backslashCount = 0;
                    continue;
                }
                UTF16.append(result, c);
                if (c == 92) {
                    ++backslashCount;
                    continue;
                }
                backslashCount = 0;
            }
            return result;
        }
        return this._generatePattern(result, escapeUnprintable, true);
    }

    public StringBuffer _generatePattern(StringBuffer result, boolean escapeUnprintable) {
        return this._generatePattern(result, escapeUnprintable, true);
    }

    public StringBuffer _generatePattern(StringBuffer result, boolean escapeUnprintable, boolean includeStrings) {
        int end;
        int start;
        int i;
        result.append('[');
        int count = this.getRangeCount();
        if (count > 1 && this.getRangeStart(0) == 0 && this.getRangeEnd(count - 1) == 0x10FFFF) {
            result.append('^');
            i = 1;
            while (i < count) {
                start = this.getRangeEnd(i - 1) + 1;
                end = this.getRangeStart(i) - 1;
                UnicodeSet._appendToPat(result, start, escapeUnprintable);
                if (start != end) {
                    if (start + 1 != end) {
                        result.append('-');
                    }
                    UnicodeSet._appendToPat(result, end, escapeUnprintable);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < count) {
                start = this.getRangeStart(i);
                end = this.getRangeEnd(i);
                UnicodeSet._appendToPat(result, start, escapeUnprintable);
                if (start != end) {
                    if (start + 1 != end) {
                        result.append('-');
                    }
                    UnicodeSet._appendToPat(result, end, escapeUnprintable);
                }
                ++i;
            }
        }
        if (includeStrings && this.strings.size() > 0) {
            Iterator it = this.strings.iterator();
            while (it.hasNext()) {
                result.append('{');
                UnicodeSet._appendToPat(result, (String)it.next(), escapeUnprintable);
                result.append('}');
            }
        }
        return result.append(']');
    }

    public int size() {
        int n = 0;
        int count = this.getRangeCount();
        int i = 0;
        while (i < count) {
            n += this.getRangeEnd(i) - this.getRangeStart(i) + 1;
            ++i;
        }
        return n + this.strings.size();
    }

    public boolean isEmpty() {
        return this.len == 1 && this.strings.size() == 0;
    }

    public boolean matchesIndexValue(int v) {
        int i = 0;
        while (i < this.getRangeCount()) {
            int high;
            int low = this.getRangeStart(i);
            if ((low & 0xFFFFFF00) == ((high = this.getRangeEnd(i)) & 0xFFFFFF00) ? (low & 0xFF) <= v && v <= (high & 0xFF) : (low & 0xFF) <= v || v <= (high & 0xFF)) {
                return true;
            }
            ++i;
        }
        if (this.strings.size() != 0) {
            Iterator it = this.strings.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                int c = UTF16.charAt(s, 0);
                if ((c & 0xFF) != v) continue;
                return true;
            }
        }
        return false;
    }

    public int matches(Replaceable text, int[] offset, int limit, boolean incremental) {
        if (offset[0] == limit) {
            if (this.contains(65535)) {
                return incremental ? 1 : 2;
            }
            return 0;
        }
        if (this.strings.size() != 0) {
            Iterator it = this.strings.iterator();
            boolean forward = offset[0] < limit;
            char firstChar = text.charAt(offset[0]);
            int highWaterLength = 0;
            while (it.hasNext()) {
                String trial = (String)it.next();
                char c = trial.charAt(forward ? 0 : trial.length() - 1);
                if (forward && c > firstChar) break;
                if (c != firstChar) continue;
                int len = UnicodeSet.matchRest(text, offset[0], limit, trial);
                if (incremental) {
                    int maxLen;
                    int n = maxLen = forward ? limit - offset[0] : offset[0] - limit;
                    if (len == maxLen) {
                        return 1;
                    }
                }
                if (len != trial.length()) continue;
                if (len > highWaterLength) {
                    highWaterLength = len;
                }
                if (forward && len < highWaterLength) break;
            }
            if (highWaterLength != 0) {
                offset[0] = offset[0] + (forward ? highWaterLength : -highWaterLength);
                return 2;
            }
        }
        return super.matches(text, offset, limit, incremental);
    }

    private static int matchRest(Replaceable text, int start, int limit, String s) {
        int maxLen;
        int slen = s.length();
        if (start < limit) {
            maxLen = limit - start;
            if (maxLen > slen) {
                maxLen = slen;
            }
            int i = 1;
            while (i < maxLen) {
                if (text.charAt(start + i) != s.charAt(i)) {
                    return 0;
                }
                ++i;
            }
        } else {
            maxLen = start - limit;
            if (maxLen > slen) {
                maxLen = slen;
            }
            --slen;
            int i = 1;
            while (i < maxLen) {
                if (text.charAt(start - i) != s.charAt(slen - i)) {
                    return 0;
                }
                ++i;
            }
        }
        return maxLen;
    }

    public void addMatchSetTo(UnicodeSet toUnionTo) {
        toUnionTo.addAll(this);
    }

    public int indexOf(int c) {
        if (c < 0 || c > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(c, 6));
        }
        int i = 0;
        int n = 0;
        int start;
        while (c >= (start = this.list[i++])) {
            int limit;
            if (c < (limit = this.list[i++])) {
                return n + c - start;
            }
            n += limit - start;
        }
        return -1;
    }

    public int charAt(int index) {
        if (index >= 0) {
            int len2 = this.len & 0xFFFFFFFE;
            int i = 0;
            while (i < len2) {
                int start;
                int count;
                if (index < (count = this.list[i++] - (start = this.list[i++]))) {
                    return start + index;
                }
                index -= count;
            }
        }
        return -1;
    }

    public UnicodeSet add(int start, int end) {
        this.checkFrozen();
        return this.add_unchecked(start, end);
    }

    private UnicodeSet add_unchecked(int start, int end) {
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        if (start < end) {
            this.add(this.range(start, end), 2, 0);
        } else if (start == end) {
            this.add(start);
        }
        return this;
    }

    public final UnicodeSet add(int c) {
        this.checkFrozen();
        return this.add_unchecked(c);
    }

    private final UnicodeSet add_unchecked(int c) {
        if (c < 0 || c > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(c, 6));
        }
        int i = this.findCodePoint(c);
        if ((i & 1) != 0) {
            return this;
        }
        if (c == this.list[i] - 1) {
            this.list[i] = c;
            if (c == 0x10FFFF) {
                this.ensureCapacity(this.len + 1);
                this.list[this.len++] = 0x110000;
            }
            if (i > 0 && c == this.list[i - 1]) {
                System.arraycopy(this.list, i + 1, this.list, i - 1, this.len - i - 1);
                this.len -= 2;
            }
        } else if (i > 0 && c == this.list[i - 1]) {
            int n = i - 1;
            this.list[n] = this.list[n] + 1;
        } else {
            if (this.len + 2 > this.list.length) {
                int[] temp = new int[this.len + 2 + 16];
                if (i != 0) {
                    System.arraycopy(this.list, 0, temp, 0, i);
                }
                System.arraycopy(this.list, i, temp, i + 2, this.len - i);
                this.list = temp;
            } else {
                System.arraycopy(this.list, i, this.list, i + 2, this.len - i);
            }
            this.list[i] = c;
            this.list[i + 1] = c + 1;
            this.len += 2;
        }
        this.pat = null;
        return this;
    }

    public final UnicodeSet add(String s) {
        this.checkFrozen();
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            this.strings.add(s);
            this.pat = null;
        } else {
            this.add_unchecked(cp, cp);
        }
        return this;
    }

    private static int getSingleCP(String s) {
        if (s.length() < 1) {
            throw new IllegalArgumentException("Can't use zero-length strings in UnicodeSet");
        }
        if (s.length() > 2) {
            return -1;
        }
        if (s.length() == 1) {
            return s.charAt(0);
        }
        int cp = UTF16.charAt(s, 0);
        if (cp > 65535) {
            return cp;
        }
        return -1;
    }

    public final UnicodeSet addAll(String s) {
        this.checkFrozen();
        int i = 0;
        while (i < s.length()) {
            int cp = UTF16.charAt(s, i);
            this.add_unchecked(cp, cp);
            i += UTF16.getCharCount(cp);
        }
        return this;
    }

    public final UnicodeSet retainAll(String s) {
        return this.retainAll(UnicodeSet.fromAll(s));
    }

    public final UnicodeSet complementAll(String s) {
        return this.complementAll(UnicodeSet.fromAll(s));
    }

    public final UnicodeSet removeAll(String s) {
        return this.removeAll(UnicodeSet.fromAll(s));
    }

    public static UnicodeSet from(String s) {
        return new UnicodeSet().add(s);
    }

    public static UnicodeSet fromAll(String s) {
        return new UnicodeSet().addAll(s);
    }

    public UnicodeSet retain(int start, int end) {
        this.checkFrozen();
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        if (start <= end) {
            this.retain(this.range(start, end), 2, 0);
        } else {
            this.clear();
        }
        return this;
    }

    public final UnicodeSet retain(int c) {
        return this.retain(c, c);
    }

    public final UnicodeSet retain(String s) {
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            boolean isIn = this.strings.contains(s);
            if (isIn && this.size() == 1) {
                return this;
            }
            this.clear();
            this.strings.add(s);
            this.pat = null;
        } else {
            this.retain(cp, cp);
        }
        return this;
    }

    public UnicodeSet remove(int start, int end) {
        this.checkFrozen();
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        if (start <= end) {
            this.retain(this.range(start, end), 2, 2);
        }
        return this;
    }

    public final UnicodeSet remove(int c) {
        return this.remove(c, c);
    }

    public final UnicodeSet remove(String s) {
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            this.strings.remove(s);
            this.pat = null;
        } else {
            this.remove(cp, cp);
        }
        return this;
    }

    public UnicodeSet complement(int start, int end) {
        this.checkFrozen();
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        if (start <= end) {
            this.xor(this.range(start, end), 2, 0);
        }
        this.pat = null;
        return this;
    }

    public final UnicodeSet complement(int c) {
        return this.complement(c, c);
    }

    public UnicodeSet complement() {
        this.checkFrozen();
        if (this.list[0] == 0) {
            System.arraycopy(this.list, 1, this.list, 0, this.len - 1);
            --this.len;
        } else {
            this.ensureCapacity(this.len + 1);
            System.arraycopy(this.list, 0, this.list, 1, this.len);
            this.list[0] = 0;
            ++this.len;
        }
        this.pat = null;
        return this;
    }

    public final UnicodeSet complement(String s) {
        this.checkFrozen();
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            if (this.strings.contains(s)) {
                this.strings.remove(s);
            } else {
                this.strings.add(s);
            }
            this.pat = null;
        } else {
            this.complement(cp, cp);
        }
        return this;
    }

    public boolean contains(int c) {
        if (c < 0 || c > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(c, 6));
        }
        int i = this.findCodePoint(c);
        return (i & 1) != 0;
    }

    private final int findCodePoint(int c) {
        if (c < this.list[0]) {
            return 0;
        }
        if (this.len >= 2 && c >= this.list[this.len - 2]) {
            return this.len - 1;
        }
        int lo = 0;
        int hi = this.len - 1;
        int i;
        while ((i = lo + hi >>> 1) != lo) {
            if (c < this.list[i]) {
                hi = i;
                continue;
            }
            lo = i;
        }
        return hi;
    }

    public boolean contains(int start, int end) {
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        int i = this.findCodePoint(start);
        return (i & 1) != 0 && end < this.list[i];
    }

    public final boolean contains(String s) {
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            return this.strings.contains(s);
        }
        return this.contains(cp);
    }

    public boolean containsAll(UnicodeSet c) {
        int n = c.getRangeCount();
        int i = 0;
        while (i < n) {
            if (!this.contains(c.getRangeStart(i), c.getRangeEnd(i))) {
                return false;
            }
            ++i;
        }
        return this.strings.containsAll(c.strings);
    }

    public boolean containsAll(String s) {
        int i = 0;
        while (i < s.length()) {
            int cp = UTF16.charAt(s, i);
            if (!this.contains(cp)) {
                if (this.strings.size() == 0) {
                    return false;
                }
                return this.containsAll(s, 0);
            }
            i += UTF16.getCharCount(cp);
        }
        return true;
    }

    private boolean containsAll(String s, int i) {
        if (i >= s.length()) {
            return true;
        }
        int cp = UTF16.charAt(s, i);
        if (this.contains(cp) && this.containsAll(s, i + UTF16.getCharCount(cp))) {
            return true;
        }
        Iterator it = this.strings.iterator();
        while (it.hasNext()) {
            String setStr = (String)it.next();
            if (!s.startsWith(setStr, i) || !this.containsAll(s, i + setStr.length())) continue;
            return true;
        }
        return false;
    }

    public String getRegexEquivalent() {
        if (this.strings.size() == 0) {
            return this.toString();
        }
        StringBuffer result = new StringBuffer("(?:");
        this._generatePattern(result, true, false);
        Iterator it = this.strings.iterator();
        while (it.hasNext()) {
            result.append('|');
            UnicodeSet._appendToPat(result, (String)it.next(), true);
        }
        return result.append(")").toString();
    }

    public boolean containsNone(int start, int end) {
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        int i = -1;
        while (start >= this.list[++i]) {
        }
        return (i & 1) == 0 && end < this.list[i];
    }

    public boolean containsNone(UnicodeSet c) {
        int n = c.getRangeCount();
        int i = 0;
        while (i < n) {
            if (!this.containsNone(c.getRangeStart(i), c.getRangeEnd(i))) {
                return false;
            }
            ++i;
        }
        return SortedSetRelation.hasRelation(this.strings, 5, c.strings);
    }

    public boolean containsNone(String s) {
        int i = 0;
        while (i < s.length()) {
            int cp = UTF16.charAt(s, i);
            if (this.contains(cp)) {
                return false;
            }
            i += UTF16.getCharCount(cp);
        }
        if (this.strings.size() == 0) {
            return true;
        }
        Iterator it = this.strings.iterator();
        while (it.hasNext()) {
            String item = (String)it.next();
            if (s.indexOf(item) < 0) continue;
            return false;
        }
        return true;
    }

    public final boolean containsSome(int start, int end) {
        return !this.containsNone(start, end);
    }

    public final boolean containsSome(UnicodeSet s) {
        return !this.containsNone(s);
    }

    public final boolean containsSome(String s) {
        return !this.containsNone(s);
    }

    public UnicodeSet addAll(UnicodeSet c) {
        this.checkFrozen();
        this.add(c.list, c.len, 0);
        this.strings.addAll(c.strings);
        return this;
    }

    public UnicodeSet retainAll(UnicodeSet c) {
        this.checkFrozen();
        this.retain(c.list, c.len, 0);
        this.strings.retainAll(c.strings);
        return this;
    }

    public UnicodeSet removeAll(UnicodeSet c) {
        this.checkFrozen();
        this.retain(c.list, c.len, 2);
        this.strings.removeAll(c.strings);
        return this;
    }

    public UnicodeSet complementAll(UnicodeSet c) {
        this.checkFrozen();
        this.xor(c.list, c.len, 0);
        SortedSetRelation.doOperation(this.strings, 5, c.strings);
        return this;
    }

    public UnicodeSet clear() {
        this.checkFrozen();
        this.list[0] = 0x110000;
        this.len = 1;
        this.pat = null;
        this.strings.clear();
        return this;
    }

    public int getRangeCount() {
        return this.len / 2;
    }

    public int getRangeStart(int index) {
        return this.list[index * 2];
    }

    public int getRangeEnd(int index) {
        return this.list[index * 2 + 1] - 1;
    }

    public UnicodeSet compact() {
        this.checkFrozen();
        if (this.len != this.list.length) {
            int[] temp = new int[this.len];
            System.arraycopy(this.list, 0, temp, 0, this.len);
            this.list = temp;
        }
        this.rangeList = null;
        this.buffer = null;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object o) {
        try {
            UnicodeSet that = (UnicodeSet)o;
            if (this.len != that.len) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= this.len) {
                    if (this.strings.equals(that.strings)) return true;
                    return false;
                }
                if (this.list[i] != that.list[i]) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        int result = this.len;
        int i = 0;
        while (i < this.len) {
            result *= 1000003;
            result += this.list[i];
            ++i;
        }
        return result;
    }

    public String toString() {
        return this.toPattern(true);
    }

    UnicodeSet applyPattern(String pattern, ParsePosition pos, SymbolTable symbols, int options) {
        boolean parsePositionWasNull;
        boolean bl = parsePositionWasNull = pos == null;
        if (parsePositionWasNull) {
            pos = new ParsePosition(0);
        }
        StringBuffer rebuiltPat = new StringBuffer();
        RuleCharacterIterator chars = new RuleCharacterIterator(pattern, symbols, pos);
        this.applyPattern(chars, symbols, rebuiltPat, options);
        if (chars.inVariable()) {
            UnicodeSet.syntaxError(chars, "Extra chars in variable value");
        }
        this.pat = rebuiltPat.toString();
        if (parsePositionWasNull) {
            int i = pos.getIndex();
            if ((options & 1) != 0) {
                i = Utility.skipWhitespace(pattern, i);
            }
            if (i != pattern.length()) {
                throw new IllegalArgumentException("Parse of \"" + pattern + "\" failed at " + i);
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    void applyPattern(RuleCharacterIterator chars, SymbolTable symbols, StringBuffer rebuiltPat, int options) {
        opts = 3;
        if ((options & 1) != 0) {
            opts |= 4;
        }
        pat = new StringBuffer();
        buf = null;
        usePat = false;
        scratch = null;
        backup = null;
        lastItem = '\u0000';
        lastChar = 0;
        mode = 0;
        op = '\u0000';
        invert = false;
        this.clear();
        while (mode != 2 && !chars.atEnd()) {
            block69: {
                block68: {
                    c = 0;
                    literal = false;
                    nested = null;
                    setMode = 0;
                    if (!UnicodeSet.resemblesPropertyPattern(chars, opts)) break block68;
                    setMode = 2;
                    break block69;
                }
                backup = chars.getPos(backup);
                c = chars.next(opts);
                literal = chars.isEscaped();
                if (c != 91 || literal) ** GOTO lbl51
                if (mode == 1) {
                    chars.setPos(backup);
                    setMode = 1;
                } else {
                    mode = 1;
                    pat.append('[');
                    backup = chars.getPos(backup);
                    c = chars.next(opts);
                    literal = chars.isEscaped();
                    if (c == 94 && !literal) {
                        invert = true;
                        pat.append('^');
                        backup = chars.getPos(backup);
                        c = chars.next(opts);
                        literal = chars.isEscaped();
                    }
                    if (c == 45) {
                        literal = true;
                    } else {
                        chars.setPos(backup);
                        continue;
lbl51:
                        // 1 sources

                        if (symbols != null && (m = symbols.lookupMatcher(c)) != null) {
                            try {
                                nested = (UnicodeSet)m;
                                setMode = 3;
                            }
                            catch (ClassCastException v0) {
                                UnicodeSet.syntaxError(chars, "Syntax error");
                            }
                        }
                    }
                }
            }
            if (setMode != 0) {
                if (lastItem == '\u0001') {
                    if (op != '\u0000') {
                        UnicodeSet.syntaxError(chars, "Char expected after operator");
                    }
                    this.add_unchecked(lastChar, lastChar);
                    UnicodeSet._appendToPat(pat, lastChar, false);
                    op = '\u0000';
                    lastItem = '\u0000';
                }
                if (op == '-' || op == '&') {
                    pat.append(op);
                }
                if (nested == null) {
                    if (scratch == null) {
                        scratch = new UnicodeSet();
                    }
                    nested = scratch;
                }
                switch (setMode) {
                    case 1: {
                        nested.applyPattern(chars, symbols, pat, options);
                        break;
                    }
                    case 2: {
                        chars.skipIgnored(opts);
                        nested.applyPropertyPattern(chars, pat, symbols);
                        break;
                    }
                    case 3: {
                        nested._toPattern(pat, false);
                    }
                }
                usePat = true;
                if (mode == 0) {
                    this.set(nested);
                    mode = 2;
                    break;
                }
                switch (op) {
                    case '-': {
                        this.removeAll(nested);
                        break;
                    }
                    case '&': {
                        this.retainAll(nested);
                        break;
                    }
                    case '\u0000': {
                        this.addAll(nested);
                    }
                }
                op = '\u0000';
                lastItem = '\u0002';
                continue;
            }
            if (mode == 0) {
                UnicodeSet.syntaxError(chars, "Missing '['");
            }
            if (literal) ** GOTO lbl-1000
            block11 : switch (c) {
                case 93: {
                    if (lastItem == '\u0001') {
                        this.add_unchecked(lastChar, lastChar);
                        UnicodeSet._appendToPat(pat, lastChar, false);
                    }
                    if (op == '-') {
                        this.add_unchecked(op, op);
                        pat.append(op);
                    } else if (op == '&') {
                        UnicodeSet.syntaxError(chars, "Trailing '&'");
                    }
                    pat.append(']');
                    mode = 2;
                    break;
                }
                case 45: {
                    if (op == '\u0000') {
                        if (lastItem != '\u0000') {
                            op = (char)c;
                            break;
                        }
                        this.add_unchecked(c, c);
                        c = chars.next(opts);
                        literal = chars.isEscaped();
                        if (c == 93 && !literal) {
                            pat.append("-]");
                            mode = 2;
                            break;
                        }
                    }
                    UnicodeSet.syntaxError(chars, "'-' not after char or set");
                }
                case 38: {
                    if (lastItem == '\u0002' && op == '\u0000') {
                        op = (char)c;
                        break;
                    }
                    UnicodeSet.syntaxError(chars, "'&' not after set");
                }
                case 94: {
                    UnicodeSet.syntaxError(chars, "'^' not after '['");
                }
                case 123: {
                    if (op != '\u0000') {
                        UnicodeSet.syntaxError(chars, "Missing operand after operator");
                    }
                    if (lastItem == '\u0001') {
                        this.add_unchecked(lastChar, lastChar);
                        UnicodeSet._appendToPat(pat, lastChar, false);
                    }
                    lastItem = '\u0000';
                    if (buf == null) {
                        buf = new StringBuffer();
                    } else {
                        buf.setLength(0);
                    }
                    ok = false;
                    while (!chars.atEnd()) {
                        c = chars.next(opts);
                        literal = chars.isEscaped();
                        if (c == 125 && !literal) {
                            ok = true;
                            break;
                        }
                        UTF16.append(buf, c);
                    }
                    if (buf.length() < 1 || !ok) {
                        UnicodeSet.syntaxError(chars, "Invalid multicharacter string");
                    }
                    this.add(buf.toString());
                    pat.append('{');
                    UnicodeSet._appendToPat(pat, buf.toString(), false);
                    pat.append('}');
                    break;
                }
                case 36: {
                    backup = chars.getPos(backup);
                    c = chars.next(opts);
                    literal = chars.isEscaped();
                    v1 = anchor = c == 93 && literal == false;
                    if (symbols == null && !anchor) {
                        c = 36;
                        chars.setPos(backup);
                    } else {
                        if (anchor && op == '\u0000') {
                            if (lastItem == '\u0001') {
                                this.add_unchecked(lastChar, lastChar);
                                UnicodeSet._appendToPat(pat, lastChar, false);
                            }
                            this.add_unchecked(65535);
                            usePat = true;
                            pat.append('$').append(']');
                            mode = 2;
                            break;
                        }
                        UnicodeSet.syntaxError(chars, "Unquoted '$'");
                    }
                }
                default: lbl-1000:
                // 2 sources

                {
                    switch (lastItem) {
                        case '\u0000': {
                            lastItem = '\u0001';
                            lastChar = c;
                            break block11;
                        }
                        case '\u0001': {
                            if (op == '-') {
                                if (lastChar >= c) {
                                    UnicodeSet.syntaxError(chars, "Invalid range");
                                }
                                this.add_unchecked(lastChar, c);
                                UnicodeSet._appendToPat(pat, lastChar, false);
                                pat.append(op);
                                UnicodeSet._appendToPat(pat, c, false);
                                op = '\u0000';
                                lastItem = '\u0000';
                                break block11;
                            }
                            this.add_unchecked(lastChar, lastChar);
                            UnicodeSet._appendToPat(pat, lastChar, false);
                            lastChar = c;
                            break block11;
                        }
                        case '\u0002': {
                            if (op != '\u0000') {
                                UnicodeSet.syntaxError(chars, "Set expected after operator");
                            }
                            lastChar = c;
                            lastItem = '\u0001';
                        }
                    }
                }
            }
        }
        if (mode != 2) {
            UnicodeSet.syntaxError(chars, "Missing ']'");
        }
        chars.skipIgnored(opts);
        if ((options & 2) != 0) {
            this.closeOver(2);
        }
        if (invert) {
            this.complement();
        }
        if (usePat) {
            rebuiltPat.append(pat.toString());
        } else {
            this._generatePattern(rebuiltPat, false, true);
        }
    }

    private static void syntaxError(RuleCharacterIterator chars, String msg) {
        throw new IllegalArgumentException("Error: " + msg + " at \"" + Utility.escape(chars.toString()) + '\"');
    }

    public void addAllTo(Collection target) {
        UnicodeSetIterator it = new UnicodeSetIterator(this);
        while (it.next()) {
            target.add(it.getString());
        }
    }

    public void addAll(Collection source) {
        this.checkFrozen();
        Iterator it = source.iterator();
        while (it.hasNext()) {
            this.add(it.next().toString());
        }
    }

    private void ensureCapacity(int newLen) {
        if (newLen <= this.list.length) {
            return;
        }
        int[] temp = new int[newLen + 16];
        System.arraycopy(this.list, 0, temp, 0, this.len);
        this.list = temp;
    }

    private void ensureBufferCapacity(int newLen) {
        if (this.buffer != null && newLen <= this.buffer.length) {
            return;
        }
        this.buffer = new int[newLen + 16];
    }

    private int[] range(int start, int end) {
        if (this.rangeList == null) {
            this.rangeList = new int[]{start, end + 1, 0x110000};
        } else {
            this.rangeList[0] = start;
            this.rangeList[1] = end + 1;
        }
        return this.rangeList;
    }

    private UnicodeSet xor(int[] other, int otherLen, int polarity) {
        int b;
        this.ensureBufferCapacity(this.len + otherLen);
        int i = 0;
        int j = 0;
        int k = 0;
        int a = this.list[i++];
        if (polarity == 1 || polarity == 2) {
            b = 0;
            if (other[j] == 0) {
                b = other[++j];
            }
        } else {
            b = other[j++];
        }
        while (true) {
            if (a < b) {
                this.buffer[k++] = a;
                a = this.list[i++];
                continue;
            }
            if (b < a) {
                this.buffer[k++] = b;
                b = other[j++];
                continue;
            }
            if (a == 0x110000) break;
            a = this.list[i++];
            b = other[j++];
        }
        this.buffer[k++] = 0x110000;
        this.len = k;
        int[] temp = this.list;
        this.list = this.buffer;
        this.buffer = temp;
        this.pat = null;
        return this;
    }

    private UnicodeSet add(int[] other, int otherLen, int polarity) {
        this.ensureBufferCapacity(this.len + otherLen);
        int i = 0;
        int j = 0;
        int k = 0;
        int a = this.list[i++];
        int b = other[j++];
        block6: while (true) {
            switch (polarity) {
                case 0: {
                    if (a < b) {
                        if (k > 0 && a <= this.buffer[k - 1]) {
                            a = UnicodeSet.max(this.list[i], this.buffer[--k]);
                        } else {
                            this.buffer[k++] = a;
                            a = this.list[i];
                        }
                        ++i;
                        polarity ^= 1;
                        continue block6;
                    }
                    if (b < a) {
                        if (k > 0 && b <= this.buffer[k - 1]) {
                            b = UnicodeSet.max(other[j], this.buffer[--k]);
                        } else {
                            this.buffer[k++] = b;
                            b = other[j];
                        }
                        ++j;
                        polarity ^= 2;
                        continue block6;
                    }
                    if (a == 0x110000) break block6;
                    if (k > 0 && a <= this.buffer[k - 1]) {
                        a = UnicodeSet.max(this.list[i], this.buffer[--k]);
                    } else {
                        this.buffer[k++] = a;
                        a = this.list[i];
                    }
                    ++i;
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    continue block6;
                }
                case 3: {
                    if (b <= a) {
                        if (a == 0x110000) break block6;
                        this.buffer[k++] = a;
                    } else {
                        if (b == 0x110000) break block6;
                        this.buffer[k++] = b;
                    }
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    continue block6;
                }
                case 1: {
                    if (a < b) {
                        this.buffer[k++] = a;
                        a = this.list[i++];
                        polarity ^= 1;
                        continue block6;
                    }
                    if (b < a) {
                        b = other[j++];
                        polarity ^= 2;
                        continue block6;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    continue block6;
                }
                case 2: {
                    if (b < a) {
                        this.buffer[k++] = b;
                        b = other[j++];
                        polarity ^= 2;
                        continue block6;
                    }
                    if (a < b) {
                        a = this.list[i++];
                        polarity ^= 1;
                        continue block6;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                }
                default: {
                    continue block6;
                }
            }
            break;
        }
        this.buffer[k++] = 0x110000;
        this.len = k;
        int[] temp = this.list;
        this.list = this.buffer;
        this.buffer = temp;
        this.pat = null;
        return this;
    }

    private UnicodeSet retain(int[] other, int otherLen, int polarity) {
        this.ensureBufferCapacity(this.len + otherLen);
        int i = 0;
        int j = 0;
        int k = 0;
        int a = this.list[i++];
        int b = other[j++];
        block6: while (true) {
            switch (polarity) {
                case 0: {
                    if (a < b) {
                        a = this.list[i++];
                        polarity ^= 1;
                        continue block6;
                    }
                    if (b < a) {
                        b = other[j++];
                        polarity ^= 2;
                        continue block6;
                    }
                    if (a == 0x110000) break block6;
                    this.buffer[k++] = a;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    continue block6;
                }
                case 3: {
                    if (a < b) {
                        this.buffer[k++] = a;
                        a = this.list[i++];
                        polarity ^= 1;
                        continue block6;
                    }
                    if (b < a) {
                        this.buffer[k++] = b;
                        b = other[j++];
                        polarity ^= 2;
                        continue block6;
                    }
                    if (a == 0x110000) break block6;
                    this.buffer[k++] = a;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    continue block6;
                }
                case 1: {
                    if (a < b) {
                        a = this.list[i++];
                        polarity ^= 1;
                        continue block6;
                    }
                    if (b < a) {
                        this.buffer[k++] = b;
                        b = other[j++];
                        polarity ^= 2;
                        continue block6;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    continue block6;
                }
                case 2: {
                    if (b < a) {
                        b = other[j++];
                        polarity ^= 2;
                        continue block6;
                    }
                    if (a < b) {
                        this.buffer[k++] = a;
                        a = this.list[i++];
                        polarity ^= 1;
                        continue block6;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                }
                default: {
                    continue block6;
                }
            }
            break;
        }
        this.buffer[k++] = 0x110000;
        this.len = k;
        int[] temp = this.list;
        this.list = this.buffer;
        this.buffer = temp;
        this.pat = null;
        return this;
    }

    private static final int max(int a, int b) {
        return a > b ? a : b;
    }

    private static synchronized UnicodeSet getInclusions(int src) {
        if (INCLUSIONS == null) {
            INCLUSIONS = new UnicodeSet[9];
        }
        if (INCLUSIONS[src] == null) {
            UnicodeSet incl = new UnicodeSet();
            switch (src) {
                case 1: {
                    UCharacterProperty.getInstance().addPropertyStarts(incl);
                    break;
                }
                case 2: {
                    UCharacterProperty.getInstance().upropsvec_addPropertyStarts(incl);
                    break;
                }
                case 8: {
                    UCharacterProperty.getInstance().addPropertyStarts(incl);
                    UCharacterProperty.getInstance().upropsvec_addPropertyStarts(incl);
                    break;
                }
                case 3: {
                    UCharacterProperty.getInstance().uhst_addPropertyStarts(incl);
                    break;
                }
                case 5: {
                    NormalizerImpl.addPropertyStarts(incl);
                    break;
                }
                case 6: {
                    try {
                        UCaseProps.getSingleton().addPropertyStarts(incl);
                        break;
                    }
                    catch (IOException e) {
                        throw new MissingResourceException(e.getMessage(), "", "");
                    }
                }
                case 7: {
                    try {
                        UBiDiProps.getSingleton().addPropertyStarts(incl);
                        break;
                    }
                    catch (IOException e) {
                        throw new MissingResourceException(e.getMessage(), "", "");
                    }
                }
                default: {
                    throw new IllegalStateException("UnicodeSet.getInclusions(unknown src " + src + ")");
                }
            }
            UnicodeSet.INCLUSIONS[src] = incl;
        }
        return INCLUSIONS[src];
    }

    private UnicodeSet applyFilter(Filter filter, int src) {
        this.clear();
        int startHasProperty = -1;
        UnicodeSet inclusions = UnicodeSet.getInclusions(src);
        int limitRange = inclusions.getRangeCount();
        int j = 0;
        while (j < limitRange) {
            int start = inclusions.getRangeStart(j);
            int end = inclusions.getRangeEnd(j);
            int ch = start;
            while (ch <= end) {
                if (filter.contains(ch)) {
                    if (startHasProperty < 0) {
                        startHasProperty = ch;
                    }
                } else if (startHasProperty >= 0) {
                    this.add_unchecked(startHasProperty, ch - 1);
                    startHasProperty = -1;
                }
                ++ch;
            }
            ++j;
        }
        if (startHasProperty >= 0) {
            this.add_unchecked(startHasProperty, 0x10FFFF);
        }
        return this;
    }

    private static String mungeCharName(String source) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            int ch = UTF16.charAt(source, i);
            i += UTF16.getCharCount(ch);
            if (UCharacterProperty.isRuleWhiteSpace(ch)) {
                if (buf.length() == 0 || buf.charAt(buf.length() - 1) == ' ') continue;
                ch = 32;
            }
            UTF16.append(buf, ch);
        }
        if (buf.length() != 0 && buf.charAt(buf.length() - 1) == ' ') {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public UnicodeSet applyIntPropertyValue(int prop, int value) {
        this.checkFrozen();
        if (prop == 8192) {
            this.applyFilter(new GeneralCategoryMaskFilter(value), 1);
        } else {
            this.applyFilter(new IntPropertyFilter(prop, value), UCharacterProperty.getInstance().getSource(prop));
        }
        return this;
    }

    public UnicodeSet applyPropertyAlias(String propertyAlias, String valueAlias) {
        return this.applyPropertyAlias(propertyAlias, valueAlias, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UnicodeSet applyPropertyAlias(String propertyAlias, String valueAlias, SymbolTable symbols) {
        int v;
        int p;
        boolean invert;
        boolean mustNotBeEmpty;
        block27: {
            this.checkFrozen();
            mustNotBeEmpty = false;
            invert = false;
            if (symbols != null && symbols instanceof XSymbolTable && ((XSymbolTable)symbols).applyPropertyAlias(propertyAlias, valueAlias, this)) {
                return this;
            }
            if (valueAlias.length() > 0) {
                p = UCharacter.getPropertyEnum(propertyAlias);
                if (p == 4101) {
                    p = 8192;
                }
                if (p >= 0 && p < 49 || p >= 4096 && p < 4117 || p >= 8192 && p < 8193) {
                    try {
                        v = UCharacter.getPropertyValueEnum(p, valueAlias);
                    }
                    catch (IllegalArgumentException e) {
                        if (p != 4098 && p != 4112 && p != 4113) {
                            throw e;
                        }
                        v = Integer.parseInt(Utility.deleteRuleWhiteSpace(valueAlias));
                        mustNotBeEmpty = true;
                    }
                    break block27;
                } else {
                    switch (p) {
                        case 12288: {
                            double value = Double.parseDouble(Utility.deleteRuleWhiteSpace(valueAlias));
                            this.applyFilter(new NumericValueFilter(value), 1);
                            return this;
                        }
                        case 16389: 
                        case 16395: {
                            int ch;
                            String buf = UnicodeSet.mungeCharName(valueAlias);
                            int n = ch = p == 16389 ? UCharacter.getCharFromExtendedName(buf) : UCharacter.getCharFromName1_0(buf);
                            if (ch == -1) {
                                throw new IllegalArgumentException("Invalid character name");
                            }
                            this.clear();
                            this.add_unchecked(ch);
                            return this;
                        }
                        case 16384: {
                            VersionInfo version = VersionInfo.getInstance(UnicodeSet.mungeCharName(valueAlias));
                            this.applyFilter(new VersionFilter(version), 2);
                            return this;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported property");
                }
            }
            try {
                p = 8192;
                v = UCharacter.getPropertyValueEnum(p, propertyAlias);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    p = 4106;
                    v = UCharacter.getPropertyValueEnum(p, propertyAlias);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    try {
                        p = UCharacter.getPropertyEnum(propertyAlias);
                    }
                    catch (IllegalArgumentException illegalArgumentException3) {
                        p = -1;
                    }
                    if (p >= 0 && p < 49) {
                        v = 1;
                        break block27;
                    }
                    if (p != -1) {
                        throw new IllegalArgumentException("Missing property value");
                    }
                    if (UPropertyAliases.compare(ANY_ID, propertyAlias) == 0) {
                        this.set(0, 0x10FFFF);
                        return this;
                    }
                    if (UPropertyAliases.compare(ASCII_ID, propertyAlias) == 0) {
                        this.set(0, 127);
                        return this;
                    }
                    if (UPropertyAliases.compare(ASSIGNED, propertyAlias) != 0) {
                        throw new IllegalArgumentException("Invalid property alias: " + propertyAlias + "=" + valueAlias);
                    }
                    p = 8192;
                    v = 1;
                    invert = true;
                }
            }
        }
        this.applyIntPropertyValue(p, v);
        if (invert) {
            this.complement();
        }
        if (mustNotBeEmpty && this.isEmpty()) {
            throw new IllegalArgumentException("Invalid property value");
        }
        return this;
    }

    private static boolean resemblesPropertyPattern(String pattern, int pos) {
        if (pos + 5 > pattern.length()) {
            return false;
        }
        return pattern.regionMatches(pos, "[:", 0, 2) || pattern.regionMatches(true, pos, "\\p", 0, 2) || pattern.regionMatches(pos, "\\N", 0, 2);
    }

    private static boolean resemblesPropertyPattern(RuleCharacterIterator chars, int iterOpts) {
        boolean result = false;
        Object pos = chars.getPos(null);
        int c = chars.next(iterOpts &= 0xFFFFFFFD);
        if (c == 91 || c == 92) {
            int d = chars.next(iterOpts & 0xFFFFFFFB);
            result = c == 91 ? d == 58 : d == 78 || d == 112 || d == 80;
        }
        chars.setPos(pos);
        return result;
    }

    private UnicodeSet applyPropertyPattern(String pattern, ParsePosition ppos, SymbolTable symbols) {
        String valueName;
        String propName;
        int close;
        int pos = ppos.getIndex();
        if (pos + 5 > pattern.length()) {
            return null;
        }
        boolean posix = false;
        boolean isName = false;
        boolean invert = false;
        if (pattern.regionMatches(pos, "[:", 0, 2)) {
            posix = true;
            if ((pos = Utility.skipWhitespace(pattern, pos + 2)) < pattern.length() && pattern.charAt(pos) == '^') {
                ++pos;
                invert = true;
            }
        } else if (pattern.regionMatches(true, pos, "\\p", 0, 2) || pattern.regionMatches(pos, "\\N", 0, 2)) {
            char c = pattern.charAt(pos + 1);
            invert = c == 'P';
            isName = c == 'N';
            pos = Utility.skipWhitespace(pattern, pos + 2);
            if (pos == pattern.length() || pattern.charAt(pos++) != '{') {
                return null;
            }
        } else {
            return null;
        }
        if ((close = pattern.indexOf(posix ? ":]" : "}", pos)) < 0) {
            return null;
        }
        int equals = pattern.indexOf(61, pos);
        if (equals >= 0 && equals < close && !isName) {
            propName = pattern.substring(pos, equals);
            valueName = pattern.substring(equals + 1, close);
        } else {
            propName = pattern.substring(pos, close);
            valueName = "";
            if (isName) {
                valueName = propName;
                propName = "na";
            }
        }
        this.applyPropertyAlias(propName, valueName, symbols);
        if (invert) {
            this.complement();
        }
        ppos.setIndex(close + (posix ? 2 : 1));
        return this;
    }

    private void applyPropertyPattern(RuleCharacterIterator chars, StringBuffer rebuiltPat, SymbolTable symbols) {
        String pat = chars.lookahead();
        ParsePosition pos = new ParsePosition(0);
        this.applyPropertyPattern(pat, pos, symbols);
        if (pos.getIndex() == 0) {
            UnicodeSet.syntaxError(chars, "Invalid property pattern");
        }
        chars.jumpahead(pos.getIndex());
        rebuiltPat.append(pat.substring(0, pos.getIndex()));
    }

    private static final void addCaseMapping(UnicodeSet set, int result, StringBuffer full) {
        if (result >= 0) {
            if (result > 31) {
                set.add(result);
            } else {
                set.add(full.toString());
                full.setLength(0);
            }
        }
    }

    public UnicodeSet closeOver(int attribute) {
        this.checkFrozen();
        if ((attribute & 6) != 0) {
            UCaseProps csp;
            try {
                csp = UCaseProps.getSingleton();
            }
            catch (IOException iOException) {
                return this;
            }
            UnicodeSet foldSet = new UnicodeSet(this);
            ULocale root = ULocale.ROOT;
            if ((attribute & 2) != 0) {
                foldSet.strings.clear();
            }
            int n = this.getRangeCount();
            StringBuffer full = new StringBuffer();
            int[] locCache = new int[1];
            int i = 0;
            while (i < n) {
                int cp;
                int start = this.getRangeStart(i);
                int end = this.getRangeEnd(i);
                if ((attribute & 2) != 0) {
                    cp = start;
                    while (cp <= end) {
                        csp.addCaseClosure(cp, foldSet);
                        ++cp;
                    }
                } else {
                    cp = start;
                    while (cp <= end) {
                        int result = csp.toFullLower(cp, null, full, root, locCache);
                        UnicodeSet.addCaseMapping(foldSet, result, full);
                        result = csp.toFullTitle(cp, null, full, root, locCache);
                        UnicodeSet.addCaseMapping(foldSet, result, full);
                        result = csp.toFullUpper(cp, null, full, root, locCache);
                        UnicodeSet.addCaseMapping(foldSet, result, full);
                        result = csp.toFullFolding(cp, full, 0);
                        UnicodeSet.addCaseMapping(foldSet, result, full);
                        ++cp;
                    }
                }
                ++i;
            }
            if (!this.strings.isEmpty()) {
                if ((attribute & 2) != 0) {
                    Iterator it = this.strings.iterator();
                    while (it.hasNext()) {
                        String str = UCharacter.foldCase((String)it.next(), 0);
                        if (csp.addStringCaseClosure(str, foldSet)) continue;
                        foldSet.add(str);
                    }
                } else {
                    BreakIterator bi = BreakIterator.getWordInstance(root);
                    Iterator it = this.strings.iterator();
                    while (it.hasNext()) {
                        String str = (String)it.next();
                        foldSet.add(UCharacter.toLowerCase(root, str));
                        foldSet.add(UCharacter.toTitleCase(root, str, bi));
                        foldSet.add(UCharacter.toUpperCase(root, str));
                        foldSet.add(UCharacter.foldCase(str, 0));
                    }
                }
            }
            this.set(foldSet);
        }
        return this;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public Object freeze() {
        this.frozen = true;
        return this;
    }

    public Object cloneAsThawed() {
        UnicodeSet result = (UnicodeSet)this.clone();
        result.frozen = false;
        return result;
    }

    private void checkFrozen() {
        if (this.frozen) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
    }

    private static interface Filter {
        public boolean contains(int var1);
    }

    private static class NumericValueFilter
    implements Filter {
        double value;

        NumericValueFilter(double value) {
            this.value = value;
        }

        public boolean contains(int ch) {
            return UCharacter.getUnicodeNumericValue(ch) == this.value;
        }
    }

    private static class GeneralCategoryMaskFilter
    implements Filter {
        int mask;

        GeneralCategoryMaskFilter(int mask) {
            this.mask = mask;
        }

        public boolean contains(int ch) {
            return (1 << UCharacter.getType(ch) & this.mask) != 0;
        }
    }

    private static class IntPropertyFilter
    implements Filter {
        int prop;
        int value;

        IntPropertyFilter(int prop, int value) {
            this.prop = prop;
            this.value = value;
        }

        public boolean contains(int ch) {
            return UCharacter.getIntPropertyValue(ch, this.prop) == this.value;
        }
    }

    private static class VersionFilter
    implements Filter {
        VersionInfo version;

        VersionFilter(VersionInfo version) {
            this.version = version;
        }

        public boolean contains(int ch) {
            VersionInfo v = UCharacter.getAge(ch);
            return v != NO_VERSION && v.compareTo(this.version) <= 0;
        }
    }

    public static abstract class XSymbolTable
    implements SymbolTable {
        public UnicodeMatcher lookupMatcher(int i) {
            return null;
        }

        public boolean applyPropertyAlias(String propertyName, String propertyValue, UnicodeSet result) {
            return false;
        }

        public char[] lookup(String s) {
            return null;
        }

        public String parseReference(String text, ParsePosition pos, int limit) {
            return null;
        }
    }
}

