/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.ICategory;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.util.ProgressMonitorUtil;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.IWizardContext;
import org.eclipse.wst.common.project.facet.ui.ProjectFacetsUiManager;
import org.eclipse.wst.common.project.facet.ui.internal.ChangeTargetedRuntimesDataModel;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;
import org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionPage;
import org.eclipse.wst.common.project.facet.ui.internal.ModifyFacetedProjectDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyFacetedProjectWizard
extends Wizard {
    protected IFacetedProject fproj;
    private final WizardContext context = new WizardContext();
    protected final FacetsSelectionPage facetsSelectionPage;
    private FacetPages[] facetPages = new FacetPages[0];
    private Composite pageContainer;
    private final List<IWizardPage> pagesToDispose = new ArrayList<IWizardPage>();
    private final ModifyFacetedProjectDataModel model;
    private final List<Runnable> delayedActions;

    public ModifyFacetedProjectWizard(IFacetedProject fproj) {
        this.model = new ModifyFacetedProjectDataModel(fproj);
        this.delayedActions = new ArrayList<Runnable>();
        this.fproj = fproj;
        Set base = null;
        if (this.fproj != null) {
            base = this.fproj.getProjectFacets();
            ChangeTargetedRuntimesDataModel rdm = this.model.getTargetedRuntimesDataModel();
            rdm.setTargetedRuntimes(this.fproj.getTargetedRuntimes());
            rdm.setPrimaryRuntime(this.fproj.getPrimaryRuntime());
        }
        this.facetsSelectionPage = new FacetsSelectionPage(this.context, base, this.model);
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(Resources.wizardTitle);
    }

    public final ModifyFacetedProjectDataModel getModel() {
        return this.model;
    }

    public void addPages() {
        if (this.fproj != null) {
            this.facetsSelectionPage.setInitialSelection(this.fproj.getProjectFacets());
            this.facetsSelectionPage.setFixedProjectFacets(this.fproj.getFixedProjectFacets());
        }
        this.facetsSelectionPage.addSelectedFacetsChangedListener(new Listener(){

            public void handleEvent(Event event) {
                ModifyFacetedProjectWizard.this.handleSelectedFacetsChangedEvent();
            }
        });
        this.addPage((IWizardPage)this.facetsSelectionPage);
    }

    public int getPageCount() {
        return this.getPages().length;
    }

    public IWizardPage[] getPages() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add((Object)this.facetsSelectionPage);
        int i = 0;
        while (i < this.facetPages.length) {
            list.addAll(this.facetPages[i].pages);
            ++i;
        }
        return list.toArray(new IWizardPage[list.size()]);
    }

    public IWizardPage getPage(String pageName) {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            IWizardPage page = pages[i];
            if (page.getName().equals(pageName)) {
                return page;
            }
            ++i;
        }
        return null;
    }

    public IWizardPage getStartingPage() {
        return this.getPages()[0];
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        int pos = -1;
        int i = 0;
        while (i < pages.length) {
            if (pages[i] == page) {
                pos = i;
            }
            ++i;
        }
        if (pos == pages.length - 1) {
            return null;
        }
        return pages[pos + 1];
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        int pos = -1;
        int i = 0;
        while (i < pages.length) {
            if (pages[i] == page) {
                pos = i;
            }
            ++i;
        }
        if (pos == 0) {
            return null;
        }
        return pages[pos - 1];
    }

    public boolean canFinish() {
        if (!this.facetsSelectionPage.isPageComplete()) {
            return false;
        }
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            if (!pages[i].isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void createPageControls(Composite container) {
        super.createPageControls(container);
        this.pageContainer = container;
        this.handleSelectedFacetsChangedEvent();
        this.executeDelayedActions();
    }

    public boolean performFinish() {
        int i = 0;
        while (i < this.facetPages.length) {
            for (IFacetWizardPage fp : this.facetPages[i].pages) {
                fp.transferStateToConfig();
            }
            ++i;
        }
        final IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ModifyFacetedProjectWizard.this.performFinish(monitor);
            }
        };
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IWorkspace ws = ResourcesPlugin.getWorkspace();
                    ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof CoreException) {
                IStatus st = ((CoreException)te).getStatus();
                ErrorDialog.openError((Shell)this.getShell(), (String)Resources.errDlgTitle, (String)st.getMessage(), (IStatus)st);
                FacetUiPlugin.log(st);
            }
            throw new RuntimeException(e.getTargetException());
        }
        return true;
    }

    protected void performFinish(IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)"", (int)20);
        try {
            ChangeTargetedRuntimesDataModel rdm = this.model.getTargetedRuntimesDataModel();
            boolean canSetRuntimesFirst = true;
            for (IProjectFacetVersion fv : this.fproj.getProjectFacets()) {
                for (IRuntime r : rdm.getTargetedRuntimes()) {
                    if (r.supports(fv)) continue;
                    canSetRuntimesFirst = false;
                    break;
                }
                if (!canSetRuntimesFirst) break;
            }
            ProgressMonitorUtil.subTask((IProgressMonitor)monitor, (String)Resources.taskConfiguringRuntimes);
            if (canSetRuntimesFirst) {
                this.fproj.setTargetedRuntimes(rdm.getTargetedRuntimes(), ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
                if (rdm.getPrimaryRuntime() != null) {
                    this.fproj.setPrimaryRuntime(rdm.getPrimaryRuntime(), ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
                } else {
                    ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)2);
                }
            } else {
                Set emptySet = Collections.emptySet();
                this.fproj.setTargetedRuntimes(emptySet, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
            }
            this.fproj.modify(this.facetsSelectionPage.getActions(), ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)16));
            if (!canSetRuntimesFirst) {
                ProgressMonitorUtil.subTask((IProgressMonitor)monitor, (String)Resources.taskConfiguringRuntimes);
                this.fproj.setTargetedRuntimes(rdm.getTargetedRuntimes(), ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                if (rdm.getPrimaryRuntime() != null) {
                    this.fproj.setPrimaryRuntime(rdm.getPrimaryRuntime(), ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
                } else {
                    ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                }
            }
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    public String getProjectName() {
        return this.fproj.getProject().getName();
    }

    public Object getConfig(IProjectFacetVersion fv, IFacetedProject.Action.Type type, String pjname) throws CoreException {
        return null;
    }

    public void syncWithPresetsModel(Combo combo) {
        this.facetsSelectionPage.syncWithPresetsModel(combo);
    }

    public void setCategoryExpandedState(final ICategory category, final boolean expanded) {
        if (this.facetsSelectionPage != null && this.facetsSelectionPage.panel != null) {
            this.facetsSelectionPage.panel.setCategoryExpandedState(category, true);
        } else {
            Runnable action = new Runnable(){

                public void run() {
                    ModifyFacetedProjectWizard.this.setCategoryExpandedState(category, expanded);
                }
            };
            this.delayedActions.add(action);
        }
    }

    public void dispose() {
        super.dispose();
        int i = 0;
        while (i < this.facetPages.length) {
            this.pagesToDispose.addAll(this.facetPages[i].pages);
            ++i;
        }
        for (IWizardPage page : this.pagesToDispose) {
            page.dispose();
        }
        this.model.dispose();
    }

    private void handleSelectedFacetsChangedEvent() {
        if (!this.facetsSelectionPage.isPageComplete()) {
            return;
        }
        Set<IProjectFacetVersion> base = this.getBaseFacets();
        Set<IFacetedProject.Action> actions = this.facetsSelectionPage.getActions();
        ArrayList<IFacetedProject.Action> sortedActions = new ArrayList<IFacetedProject.Action>(actions);
        ProjectFacetsManager.sort(base, sortedActions);
        ArrayList<FacetPages> newFacetPages = new ArrayList<FacetPages>();
        boolean[] markers = new boolean[this.facetPages.length];
        boolean changed = false;
        for (IFacetedProject.Action action : sortedActions) {
            IProjectFacetVersion fv = action.getProjectFacetVersion();
            FacetPages fp = this.findFacetPages(action, markers);
            if (fp == null) {
                IActionDefinition actiondef;
                try {
                    actiondef = fv.getActionDefinition(base, action.getType());
                }
                catch (CoreException e) {
                    FacetUiPlugin.log((Exception)((Object)e));
                    continue;
                }
                List<IFacetWizardPage> pages = ProjectFacetsUiManager.getWizardPages(actiondef.getId());
                if (!pages.isEmpty()) {
                    fp = new FacetPages();
                    fp.action = action;
                    fp.pages = pages;
                    for (IFacetWizardPage page : fp.pages) {
                        page.setWizard((IWizard)this);
                        page.setWizardContext(this.context);
                        page.setConfig(action.getConfig());
                        if (page.getControl() != null) continue;
                        page.createControl(this.pageContainer);
                        page.getControl().setVisible(false);
                    }
                    changed = true;
                }
            }
            if (fp == null) continue;
            newFacetPages.add(fp);
        }
        int i = 0;
        while (i < this.facetPages.length) {
            if (!markers[i]) {
                for (IFacetWizardPage page : this.facetPages[i].pages) {
                    page.setWizard(null);
                    this.pagesToDispose.add(page);
                }
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.facetPages = new FacetPages[newFacetPages.size()];
            newFacetPages.toArray(this.facetPages);
            this.pageContainer.layout(true, true);
        }
    }

    private FacetPages findFacetPages(IFacetedProject.Action action, boolean[] markers) {
        int i = 0;
        while (i < this.facetPages.length) {
            FacetPages fp = this.facetPages[i];
            if (fp.action == action) {
                markers[i] = true;
                return fp;
            }
            ++i;
        }
        return null;
    }

    private Set<IProjectFacetVersion> getBaseFacets() {
        if (this.fproj == null) {
            return Collections.emptySet();
        }
        return this.fproj.getProjectFacets();
    }

    private void executeDelayedActions() {
        for (Runnable r : this.delayedActions) {
            try {
                r.run();
            }
            catch (Exception e) {
                FacetUiPlugin.log(e);
            }
        }
    }

    private static final class FacetPages {
        public IFacetedProject.Action action;
        public List<IFacetWizardPage> pages;

        private FacetPages() {
        }
    }

    private static final class Resources
    extends NLS {
        public static String wizardTitle;
        public static String errDlgTitle;
        public static String taskConfiguringRuntimes;

        static {
            Resources.initializeMessages((String)ModifyFacetedProjectWizard.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WizardContext
    implements IWizardContext {
        private WizardContext() {
        }

        @Override
        public String getProjectName() {
            return ModifyFacetedProjectWizard.this.getProjectName();
        }

        @Override
        public Set<IProjectFacetVersion> getSelectedProjectFacets() {
            return ModifyFacetedProjectWizard.this.facetsSelectionPage.getSelectedProjectFacets();
        }

        @Override
        public boolean isProjectFacetSelected(IProjectFacetVersion fv) {
            return this.getSelectedProjectFacets().contains(fv);
        }

        @Override
        public Set<IFacetedProject.Action> getActions() {
            FacetsSelectionPage page = ModifyFacetedProjectWizard.this.facetsSelectionPage;
            return page.getActions();
        }

        @Override
        public IFacetedProject.Action getAction(IFacetedProject.Action.Type type, IProjectFacetVersion f) {
            for (IFacetedProject.Action action : this.getActions()) {
                if (action.getType() != type || action.getProjectFacetVersion() != f) continue;
                return action;
            }
            return null;
        }

        @Override
        public Object getConfig(IProjectFacetVersion fv, IFacetedProject.Action.Type type, String pjname) throws CoreException {
            Object config = ModifyFacetedProjectWizard.this.getConfig(fv, type, pjname);
            if (config == null) {
                Set base = ModifyFacetedProjectWizard.this.getBaseFacets();
                IActionDefinition def = fv.getActionDefinition(base, type);
                config = def.createConfigObject(fv, pjname);
            }
            return config;
        }
    }
}

