/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractDataModel {
    private final Map<String, List<IDataModelListener>> listeners = new HashMap<String, List<IDataModelListener>>();

    public synchronized void addListener(String event, IDataModelListener listener) {
        List<IDataModelListener> list = this.listeners.get(event);
        if (list == null) {
            list = new ArrayList<IDataModelListener>();
            this.listeners.put(event, list);
        }
        list.add(listener);
    }

    public synchronized void removeListener(String event, IDataModelListener listener) {
        List<IDataModelListener> list = this.listeners.get(event);
        if (list != null) {
            list.remove(listener);
        }
    }

    public synchronized void removeListener(IDataModelListener listener) {
        for (String property : this.listeners.keySet()) {
            this.removeListener(property, listener);
        }
    }

    protected void notifyListeners(String event) {
        List<IDataModelListener> listeners = this.listeners.get(event);
        if (listeners != null) {
            for (IDataModelListener listener : listeners) {
                listener.handleEvent();
            }
        }
    }

    public static interface IDataModelListener {
        public void handleEvent();
    }
}

