/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaFileContentProvider;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.IJpaRootContentNode;
import org.eclipse.jpt.core.internal.JpaCoreFactory;
import org.eclipse.jpt.core.internal.JpaFile;
import org.eclipse.jpt.core.internal.JptCorePlugin;

public class JpaFileContentRegistry {
    private JpaFileContentRegistry() {
    }

    public static IJpaFile getFile(IJpaProject jpaProject, IFile file) {
        IContentType contentType = null;
        try {
            contentType = file == null ? null : Platform.getContentTypeManager().findContentTypeFor(file.getContents(), file.getName());
        }
        catch (IOException e) {
            JptCorePlugin.log(e);
        }
        catch (CoreException e) {
            JptCorePlugin.log(e);
        }
        if (contentType == null) {
            return null;
        }
        String contentTypeId = contentType.getId();
        IJpaRootContentNode content = JpaFileContentRegistry.buildContent(jpaProject, file, contentTypeId);
        if (content == null) {
            return null;
        }
        JpaFile jpaFile = JpaCoreFactory.eINSTANCE.createJpaFile();
        jpaFile.setFile(file);
        jpaFile.setContentId(contentTypeId);
        jpaFile.setContent(content);
        return jpaFile;
    }

    private static IJpaRootContentNode buildContent(IJpaProject jpaProject, IFile file, String contentTypeId) {
        for (IJpaFileContentProvider provider : jpaProject.getPlatform().jpaFileContentProviders()) {
            if (!provider.contentType().equals(contentTypeId)) continue;
            return provider.buildRootContent(file);
        }
        return null;
    }
}

