/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.utility.internal.StringTools;

public class SimpleTextRange
implements ITextRange {
    private final int offset;
    private final int length;
    private final int lineNumber;

    public SimpleTextRange(int offset, int length, int lineNumber) {
        this.offset = offset;
        this.length = length;
        this.lineNumber = lineNumber;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean includes(int index) {
        return this.offset <= index && index < this.end();
    }

    public boolean touches(int index) {
        return this.includes(index) || index == this.end();
    }

    private int end() {
        return this.offset + this.length;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ITextRange)) {
            return false;
        }
        ITextRange r = (ITextRange)o;
        return r.getOffset() == this.offset && r.getLength() == this.length;
    }

    public int hashCode() {
        return this.offset ^ this.length;
    }

    public String toString() {
        String start = String.valueOf(this.offset);
        String end = String.valueOf(this.end());
        return StringTools.buildToStringFor((Object)this, (Object)(String.valueOf(start) + ", " + end));
    }
}

