/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.persistence;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.core.internal.XmlEObject;
import org.eclipse.jpt.core.internal.content.persistence.PersistencePackage;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.internal.emf.utilities.DOMUtilities;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class MappingFileRef
extends XmlEObject {
    protected static final String FILE_NAME_EDEFAULT = "";
    protected String fileName = "";

    protected MappingFileRef() {
    }

    protected EClass eStaticClass() {
        return PersistencePackage.Literals.MAPPING_FILE_REF;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String newFileName) {
        String oldFileName = this.fileName;
        this.fileName = newFileName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldFileName, (Object)this.fileName));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getFileName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setFileName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setFileName(FILE_NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return FILE_NAME_EDEFAULT == null ? this.fileName != null : !FILE_NAME_EDEFAULT.equals(this.fileName);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (fileName: ");
        result.append(this.fileName);
        result.append(')');
        return result.toString();
    }

    public ITextRange validationTextRange() {
        IDOMNode textNode = (IDOMNode)DOMUtilities.getChildTextNode((Node)this.node);
        return textNode == null ? this.buildTextRange(this.node) : this.buildTextRange(textNode);
    }

    public IJpaFile getMappingFile() {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.getJpaProject().getProject());
        IVirtualFolder virtualRootFolder = component.getRootFolder();
        IVirtualFile virtualMappingFile = virtualRootFolder.getFile((IPath)new Path(String.valueOf(this.getJpaProject().rootDeployLocation()) + '/' + this.fileName));
        IJpaFile mappingFile = null;
        IFile[] iFileArray = virtualMappingFile.getUnderlyingFiles();
        int n = iFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile underlyingFile = iFileArray[n2];
            IJpaFile jpaFile = JptCorePlugin.getJpaFile(underlyingFile);
            if (jpaFile != null) {
                if (mappingFile != null) {
                    return null;
                }
                mappingFile = jpaFile;
            }
            ++n2;
        }
        return mappingFile;
    }
}

