/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jdtutility;

import java.beans.Introspector;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jpt.core.internal.jdtutility.Attribute;

public class MethodAttribute
extends Attribute {
    public MethodAttribute(IMethod getMethod) {
        super((IMember)getMethod);
    }

    public IMethod getJdtMember() {
        return (IMethod)super.getJdtMember();
    }

    public MethodDeclaration bodyDeclaration(CompilationUnit astRoot) {
        String methodName = this.getName();
        MethodDeclaration[] methodDeclarationArray = this.declaringTypeDeclaration(astRoot).getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            if (methodDeclaration.getName().getFullyQualifiedName().equals(methodName) && methodDeclaration.parameters().size() == 0) {
                return methodDeclaration;
            }
            ++n2;
        }
        return null;
    }

    public boolean isMethod() {
        return true;
    }

    public String attributeName() {
        String methodName = super.getName();
        int beginIndex = 0;
        if (methodName.startsWith("get")) {
            beginIndex = 3;
        } else if (methodName.startsWith("is")) {
            beginIndex = 2;
        }
        return Introspector.decapitalize(methodName.substring(beginIndex));
    }

    public ITypeBinding typeBinding(CompilationUnit astRoot) {
        IMethodBinding methodBinding = this.bodyDeclaration(astRoot).resolveBinding();
        if (methodBinding != null) {
            return methodBinding.getReturnType();
        }
        return null;
    }
}

