/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.mappings;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.core.internal.IAttributeMapping;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.mappings.IAbstractJoinColumn;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.mappings.INonOwningMapping;
import org.eclipse.jpt.core.internal.mappings.IRelationshipMapping;
import org.eclipse.jpt.core.internal.mappings.ITable;
import org.eclipse.jpt.db.internal.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IJoinTable
extends ITable {
    public EList<IJoinColumn> getJoinColumns();

    public EList<IJoinColumn> getSpecifiedJoinColumns();

    public EList<IJoinColumn> getDefaultJoinColumns();

    public EList<IJoinColumn> getInverseJoinColumns();

    public EList<IJoinColumn> getSpecifiedInverseJoinColumns();

    public EList<IJoinColumn> getDefaultInverseJoinColumns();

    public IJoinColumn createJoinColumn(int var1);

    public IJoinColumn createInverseJoinColumn(int var1);

    public boolean containsSpecifiedJoinColumns();

    public boolean containsSpecifiedInverseJoinColumns();

    public IRelationshipMapping relationshipMapping();

    public static abstract class AbstractJoinColumnOwner
    implements IJoinColumn.Owner {
        private final IJoinTable joinTable;

        AbstractJoinColumnOwner(IJoinTable joinTable) {
            this.joinTable = joinTable;
        }

        protected IJoinTable getJoinTable() {
            return this.joinTable;
        }

        public IRelationshipMapping getRelationshipMapping() {
            return this.joinTable.relationshipMapping();
        }

        public boolean tableNameIsInvalid(String tableName) {
            return false;
        }

        public boolean tableIsAllowed() {
            return false;
        }

        public ITextRange validationTextRange() {
            return this.joinTable.validationTextRange();
        }

        public ITypeMapping getTypeMapping() {
            return this.joinTable.getOwner().getTypeMapping();
        }

        public Table dbTable(String tableName) {
            if (this.joinTable.getName() == null) {
                return null;
            }
            return this.joinTable.getName().equals(tableName) ? this.joinTable.dbTable() : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InverseJoinColumnOwner
    extends AbstractJoinColumnOwner {
        public InverseJoinColumnOwner(IJoinTable joinTable) {
            super(joinTable);
        }

        public List<IJoinColumn> joinColumns() {
            return this.getJoinTable().getInverseJoinColumns();
        }

        @Override
        public int indexOf(IAbstractJoinColumn joinColumn) {
            return this.joinColumns().indexOf(joinColumn);
        }

        @Override
        public IEntity targetEntity() {
            return this.getJoinTable().relationshipMapping().getResolvedTargetEntity();
        }

        @Override
        public String attributeName() {
            return this.getJoinTable().relationshipMapping().getPersistentAttribute().getName();
        }

        @Override
        public Table dbTable(String tableName) {
            Table dbTable = super.dbTable(tableName);
            if (dbTable != null) {
                return dbTable;
            }
            IEntity targetEntity = this.targetEntity();
            return targetEntity == null ? null : targetEntity.dbTable(tableName);
        }

        @Override
        public Table dbReferencedColumnTable() {
            IEntity targetEntity = this.targetEntity();
            return targetEntity == null ? null : targetEntity.primaryDbTable();
        }

        @Override
        public boolean isVirtual(IAbstractJoinColumn joinColumn) {
            return this.getJoinTable().getDefaultInverseJoinColumns().contains((Object)joinColumn);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JoinColumnOwner
    extends AbstractJoinColumnOwner {
        public JoinColumnOwner(IJoinTable joinTable) {
            super(joinTable);
        }

        public List<IJoinColumn> joinColumns() {
            return this.getJoinTable().getJoinColumns();
        }

        @Override
        public int indexOf(IAbstractJoinColumn joinColumn) {
            return this.joinColumns().indexOf(joinColumn);
        }

        @Override
        public IEntity targetEntity() {
            return this.getJoinTable().relationshipMapping().getEntity();
        }

        @Override
        public String attributeName() {
            IEntity targetEntity = this.getJoinTable().relationshipMapping().getResolvedTargetEntity();
            if (targetEntity == null) {
                return null;
            }
            String attributeName = this.getJoinTable().relationshipMapping().getPersistentAttribute().getName();
            Iterator<IPersistentAttribute> stream = targetEntity.getPersistentType().allAttributes();
            while (stream.hasNext()) {
                String mappedBy;
                IPersistentAttribute attribute = stream.next();
                IAttributeMapping mapping = attribute.getMapping();
                if (!(mapping instanceof INonOwningMapping) || (mappedBy = ((INonOwningMapping)mapping).getMappedBy()) == null || !mappedBy.equals(attributeName)) continue;
                return attribute.getName();
            }
            return null;
        }

        @Override
        public Table dbTable(String tableName) {
            Table dbTable = super.dbTable(tableName);
            if (dbTable != null) {
                return dbTable;
            }
            return this.getTypeMapping().dbTable(tableName);
        }

        @Override
        public Table dbReferencedColumnTable() {
            return this.getTypeMapping().primaryDbTable();
        }

        @Override
        public boolean isVirtual(IAbstractJoinColumn joinColumn) {
            return this.getJoinTable().getDefaultJoinColumns().contains((Object)joinColumn);
        }
    }
}

