/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.client.connector.http;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.cactus.WebRequest;
import org.apache.cactus.client.authentication.Authentication;
import org.apache.cactus.internal.client.connector.http.ConnectionHelper;
import org.apache.cactus.internal.client.connector.http.HttpUtil;
import org.apache.cactus.internal.configuration.Configuration;
import org.apache.cactus.internal.util.CookieUtil;
import org.apache.cactus.internal.util.UrlUtil;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.util.HttpURLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class HttpClientConnectionHelper
implements ConnectionHelper {
    private HttpMethod method;
    private String url;
    private static final JoinPoint.StaticPart ajc$tjp_0;

    public HttpClientConnectionHelper(String theURL) {
        this.url = theURL;
    }

    public java.net.HttpURLConnection connect(WebRequest webRequest, Configuration configuration) throws Throwable {
        WebRequest webRequest2 = webRequest;
        Configuration configuration2 = configuration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)webRequest2, (Object)configuration2);
        return (java.net.HttpURLConnection)HttpClientConnectionHelper.connect_aroundBody1$advice(this, webRequest2, configuration2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    private void addHttpPostParameters(WebRequest theRequest) {
        if (!theRequest.getParameterNamesPost().hasMoreElements()) {
            return;
        }
        Enumeration keys = theRequest.getParameterNamesPost();
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String[] values = theRequest.getParameterValuesPost(key);
            int i = 0;
            while (i < values.length) {
                parameters.add(new NameValuePair(key, values[i]));
                ++i;
            }
        }
        ((PostMethod)this.method).setRequestBody(parameters.toArray(new NameValuePair[parameters.size()]));
    }

    private void addHeaders(WebRequest theRequest) {
        Enumeration keys = theRequest.getHeaderNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String[] values = theRequest.getHeaderValues(key);
            StringBuffer fullHeaderValue = new StringBuffer(values[0]);
            int i = 1;
            while (i < values.length) {
                fullHeaderValue.append("," + values[i]);
                ++i;
            }
            this.method.addRequestHeader(key, fullHeaderValue.toString());
        }
    }

    private void addUserData(WebRequest theRequest) throws IOException {
        if (theRequest.getUserData() == null) {
            return;
        }
        ((PostMethod)this.method).setRequestBody(theRequest.getUserData());
    }

    static {
        Factory factory = new Factory("HttpClientConnectionHelper.java", Class.forName("org.apache.cactus.internal.client.connector.http.HttpClientConnectionHelper"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-connect-org.apache.cactus.internal.client.connector.http.HttpClientConnectionHelper-org.apache.cactus.WebRequest:org.apache.cactus.internal.configuration.Configuration:-theRequest:theConfiguration:-java.lang.Throwable:-java.net.HttpURLConnection-"), 75);
    }

    private static final java.net.HttpURLConnection connect_aroundBody0(HttpClientConnectionHelper httpClientConnectionHelper, WebRequest webRequest, Configuration configuration, JoinPoint joinPoint) {
        URL uRL = new URL(httpClientConnectionHelper.url);
        HttpState httpState = new HttpState();
        httpClientConnectionHelper.method = webRequest.getParameterNamesPost().hasMoreElements() || webRequest.getUserData() != null ? new PostMethod() : new GetMethod();
        Authentication authentication = webRequest.getAuthentication();
        if (authentication != null) {
            authentication.configure(httpState, httpClientConnectionHelper.method, webRequest, configuration);
        }
        uRL = HttpUtil.addHttpGetParameters(webRequest, uRL);
        httpClientConnectionHelper.method.setFollowRedirects(false);
        httpClientConnectionHelper.method.setPath(UrlUtil.getPath(uRL));
        httpClientConnectionHelper.method.setQueryString(UrlUtil.getQuery(uRL));
        httpClientConnectionHelper.method.setRequestHeader("Content-type", webRequest.getContentType());
        httpClientConnectionHelper.addHeaders(webRequest);
        if (webRequest.getUserData() != null) {
            httpClientConnectionHelper.addUserData(webRequest);
        } else {
            httpClientConnectionHelper.addHttpPostParameters(webRequest);
        }
        httpState.addCookies(CookieUtil.createHttpClientCookies(webRequest, uRL));
        HttpClient httpClient = new HttpClient();
        HostConfiguration hostConfiguration = new HostConfiguration();
        hostConfiguration.setHost(uRL.getHost(), uRL.getPort(), Protocol.getProtocol((String)uRL.getProtocol()));
        httpClient.setState(httpState);
        httpClient.executeMethod(hostConfiguration, httpClientConnectionHelper.method);
        return new HttpURLConnection(httpClientConnectionHelper.method, uRL);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object connect_aroundBody1$advice(HttpClientConnectionHelper this_, WebRequest ajc_aroundClosure, Configuration thisJoinPoint, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void result;
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            java.net.HttpURLConnection httpURLConnection = HttpClientConnectionHelper.connect_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
            StringBuffer stringBuffer = new StringBuffer(joinPoint2.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append(httpURLConnection);
            stringBuffer.append(']');
            log.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return httpURLConnection;
        }
        void var12_12 = result;
        return HttpClientConnectionHelper.connect_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
    }
}

