/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.jem.util.emf.workbench.FlexibleProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.javaee.core.internal.util.JavaeeResourceImpl;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class JEE5ModelProvider
implements IModelProvider {
    protected XMLResourceImpl writableResource;
    protected IProject proj;
    protected IPath defaultResourcePath;
    private static boolean resourceChangeListenerEnabled = false;
    private static HashMap<IProject, HashSet<IPath>> modelResources = new HashMap();

    protected ProjectResourceSet getResourceSet(IProject proj2) {
        return (ProjectResourceSet)WorkbenchResourceHelperBase.getResourceSet((IProject)this.proj);
    }

    public XMLResourceImpl getWritableResource() {
        return this.writableResource;
    }

    public void setWritableResource(XMLResourceImpl writableResource) {
        this.writableResource = writableResource;
    }

    private URI getModuleURI(URI uri) {
        URI moduleuri = ModuleURIUtil.fullyQualifyURI((IProject)this.proj, (String)this.getContentTypeDescriber());
        IPath requestPath = new Path(moduleuri.path()).append((IPath)new Path(uri.path()));
        URI resourceURI = URI.createURI((String)("module:" + requestPath.toString()));
        return resourceURI;
    }

    protected XMLResourceImpl getModelResource(IPath modelPath) {
        XMLResourceImpl res;
        block8: {
            if (this.writableResource != null) {
                return this.writableResource;
            }
            if (modelPath == null || modelPath.equals((Object)IModelProvider.FORCESAVE)) {
                modelPath = this.getDefaultResourcePath();
            }
            ProjectResourceSet resSet = this.getResourceSet(this.proj);
            IVirtualFolder container = ComponentCore.createComponent((IProject)this.proj).getRootFolder();
            String modelPathURI = modelPath.toString();
            URI uri = URI.createURI((String)modelPathURI);
            Path projURIPath = new Path("");
            projURIPath = projURIPath.append(container.getProjectRelativePath());
            projURIPath = projURIPath.addTrailingSeparator();
            projURIPath = projURIPath.append(modelPath);
            URI projURI = URI.createURI((String)projURIPath.toString());
            res = null;
            try {
                if (this.proj.getFile(projURI.toString()).exists()) {
                    res = (XMLResourceImpl)resSet.getResource(this.getModuleURI(uri), true);
                    HashSet<Object> currentResources = modelResources.get(this.proj);
                    if (currentResources == null) {
                        currentResources = new HashSet();
                    }
                    currentResources.add((IPath)new Path(uri.toString()));
                    modelResources.put(this.proj, currentResources);
                    if (!resourceChangeListenerEnabled) {
                        resourceChangeListenerEnabled = true;
                        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener(), 1);
                    }
                    break block8;
                }
                return this.createModelResource(modelPath, resSet, projURI);
            }
            catch (WrappedException ex) {
                if (ex.getCause() instanceof FileNotFoundException) {
                    return null;
                }
                throw ex;
            }
        }
        return res;
    }

    protected XMLResourceImpl createModelResource(IPath modelPath, ProjectResourceSet resourceSet, URI uri) {
        XMLResourceImpl res = (XMLResourceImpl)resourceSet.getResource(this.getModuleURI(uri), false);
        if (res == null || !res.isLoaded()) {
            res = (XMLResourceImpl)((FlexibleProjectResourceSet)resourceSet).createResource(this.getModuleURI(uri), WTPResourceFactoryRegistry.INSTANCE.getFactory(uri, this.getContentType(this.getContentTypeDescriber())));
            this.populateRoot(res, resourceSet.getProject().getName());
        }
        return res;
    }

    public void populateRoot(XMLResourceImpl res, String string) {
    }

    private IContentDescription getContentType(String contentTypeDescriber) {
        if (contentTypeDescriber != null) {
            return Platform.getContentTypeManager().getContentType(contentTypeDescriber).getDefaultDescription();
        }
        return null;
    }

    public IPath getDefaultResourcePath() {
        return this.defaultResourcePath;
    }

    public void setDefaultResourcePath(IPath defaultResourcePath) {
        this.defaultResourcePath = defaultResourcePath;
    }

    public Object getModelObject() {
        return this.getModelObject(this.getDefaultResourcePath());
    }

    public Object getModelObject(IPath modelPath) {
        return null;
    }

    protected String getContentTypeDescriber() {
        return null;
    }

    public IStatus validateEdit(IPath modelPath, Object context) {
        if (modelPath == null) {
            modelPath = this.getDefaultResourcePath();
        }
        IWorkspace work = ResourcesPlugin.getWorkspace();
        IFile file = WorkbenchResourceHelper.getFile((Resource)this.getModelResource(modelPath));
        if (file != null) {
            IFile[] files = new IFile[]{file};
            if (context == null) {
                context = IWorkspace.VALIDATE_PROMPT;
            }
            return work.validateEdit(files, context);
        }
        return Status.OK_STATUS;
    }

    public void modify(Runnable runnable, IPath modelPath) {
        try {
            try {
                JavaeeResourceImpl res = (JavaeeResourceImpl)this.getModelResource(modelPath);
                if (res != null) {
                    this.setWritableResource((XMLResourceImpl)res);
                }
                runnable.run();
                try {
                    if (res != null) {
                        if (modelPath != null && modelPath.equals((Object)IModelProvider.FORCESAVE)) {
                            res.save(Collections.EMPTY_MAP, true);
                        } else {
                            res.save(Collections.EMPTY_MAP);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setWritableResource(null);
            }
        }
        finally {
            this.setWritableResource(null);
        }
    }

    public void addListener(IModelProviderListener listener) {
    }

    public void removeListener(IModelProviderListener listener) {
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                IResourceDelta[] affectedChildren = delta.getAffectedChildren(6, 1);
                IResourceDelta projectDelta = null;
                IResource changedResource = null;
                IProject changedProject = null;
                IPath resourcePath = null;
                int i = 0;
                while (i < affectedChildren.length) {
                    projectDelta = affectedChildren[i];
                    changedResource = projectDelta.getResource();
                    changedProject = changedResource.getProject();
                    HashSet currentResources = (HashSet)modelResources.get(changedProject);
                    if (currentResources != null) {
                        if (changedResource == changedProject && projectDelta.getKind() == 2) {
                            modelResources.remove(changedProject);
                            if (modelResources.isEmpty()) {
                                resourceChangeListenerEnabled = false;
                                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                            }
                        } else {
                            Iterator iter = currentResources.iterator();
                            ArrayList<IPath> toUnload = new ArrayList<IPath>();
                            while (iter.hasNext()) {
                                resourcePath = (IPath)iter.next();
                                if (projectDelta.findMember(resourcePath) == null) continue;
                                toUnload.add(resourcePath);
                            }
                            if (toUnload.size() > 0) {
                                Resource current2 = null;
                                ProjectResourceSet resourceSet = JEE5ModelProvider.this.getResourceSet(changedProject);
                                URIConverter uriConverter = resourceSet.getURIConverter();
                                HashSet<URI> resourceURIs = new HashSet<URI>();
                                iter = toUnload.iterator();
                                while (iter.hasNext()) {
                                    resourceURIs.add(uriConverter.normalize(URI.createURI((String)((IPath)iter.next()).toString())));
                                }
                                for (Resource current2 : resourceSet.getResources()) {
                                    if (!resourceURIs.contains(current2.getURI())) continue;
                                    current2.unload();
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

