/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.serialize;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.ws.commons.serialize.XMLWriterImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class OrderedAttributeXMLWriter
extends XMLWriterImpl {
    public void startElement(String pNamespaceURI, String pLocalName, String pQName, final Attributes pAttrs) throws SAXException {
        Integer[] attributeNumbers = new Integer[pAttrs.getLength()];
        int i = 0;
        while (i < attributeNumbers.length) {
            attributeNumbers[i] = new Integer(i);
            ++i;
        }
        Arrays.sort(attributeNumbers, new Comparator(){

            public int compare(Object pNum1, Object pNum2) {
                int result;
                String uri2;
                int i1 = (Integer)pNum1;
                int i2 = (Integer)pNum2;
                String uri1 = pAttrs.getURI(i1);
                if (uri1 == null) {
                    uri1 = "";
                }
                if ((uri2 = pAttrs.getURI(i2)) == null) {
                    uri2 = "";
                }
                if ((result = uri1.compareTo(uri2)) == 0) {
                    result = pAttrs.getLocalName(i1).compareTo(pAttrs.getLocalName(i2));
                }
                return result;
            }
        });
        AttributesImpl orderedAttributes = new AttributesImpl();
        int i2 = 0;
        while (i2 < attributeNumbers.length) {
            int num = attributeNumbers[i2];
            orderedAttributes.addAttribute(pAttrs.getURI(num), pAttrs.getLocalName(num), pAttrs.getQName(num), pAttrs.getType(num), pAttrs.getValue(num));
            ++i2;
        }
        super.startElement(pNamespaceURI, pLocalName, pQName, orderedAttributes);
    }
}

