/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.internal.EMFModelValidationDebugOptions;
import org.eclipse.emf.validation.internal.EMFModelValidationStatusCodes;
import org.eclipse.emf.validation.internal.service.AbstractGetConstraintsOperation;
import org.eclipse.emf.validation.internal.service.GetBatchConstraintsOperation;
import org.eclipse.emf.validation.internal.service.GetLiveConstraintsOperation;
import org.eclipse.emf.validation.internal.service.IProviderDescriptor;
import org.eclipse.emf.validation.internal.service.IProviderOperation;
import org.eclipse.emf.validation.internal.util.Log;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.IModelConstraintProvider;

public class ConstraintCache
implements IModelConstraintProvider {
    private static final String NOT_A_FEATURE_NAME = "$none$";
    private final Map buckets = new WeakHashMap();
    private final Collection providers = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.validation.internal.service.ConstraintCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public IProviderDescriptor getDescriptor() {
        return new IProviderDescriptor(){

            public boolean provides(IProviderOperation operation) {
                return true;
            }

            public boolean isCacheEnabled() {
                return false;
            }

            public boolean isCache() {
                return true;
            }

            public boolean isXmlProvider() {
                return false;
            }

            public IModelConstraintProvider getProvider() {
                return ConstraintCache.this;
            }
        };
    }

    public Collection getProviders() {
        return this.providers;
    }

    public void addProvider(IProviderDescriptor provider) {
        if (!$assertionsDisabled && provider == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !provider.isCacheEnabled()) {
            throw new AssertionError();
        }
        this.getProviders().add(provider);
    }

    private EClassBucket getBucket(EClass clazz) {
        EClassBucket result = (EClassBucket)this.buckets.get(clazz);
        if (result == null) {
            result = new EClassBucket();
            this.buckets.put(clazz, result);
        }
        return result;
    }

    private Collection execute(AbstractGetConstraintsOperation operation) {
        Iterator iter = this.getProviders().iterator();
        while (iter.hasNext()) {
            IProviderDescriptor next = (IProviderDescriptor)iter.next();
            if (!next.provides(operation)) continue;
            try {
                operation.execute(next.getProvider());
            }
            catch (RuntimeException e) {
                Trace.catching(this.getClass(), "execute", e);
                Log.l7dWarning(61, EMFModelValidationStatusCodes.PROVIDER_FAILURE_MSG, e);
                iter.remove();
            }
        }
        return operation.getUnfilteredConstraints();
    }

    public Collection getLiveConstraints(Notification notification, Collection constraints) {
        if (!$assertionsDisabled && notification == null) {
            throw new AssertionError();
        }
        ArrayList result = constraints;
        if (result == null) {
            result = new ArrayList();
        }
        if (notification.getNotifier() instanceof EObject) {
            EClassBucket bucket;
            Collection cached;
            EObject eObject = (EObject)notification.getNotifier();
            EMFEventType eventType = EMFEventType.getInstance(notification.getEventType());
            String featureName = null;
            if (notification.getFeature() instanceof EStructuralFeature) {
                featureName = ((EStructuralFeature)notification.getFeature()).getName();
            }
            if ((cached = (bucket = this.getBucket(eObject.eClass())).getLiveConstraints(eventType, featureName)) == null) {
                if (Trace.shouldTrace(EMFModelValidationDebugOptions.CACHE)) {
                    Trace.trace(EMFModelValidationDebugOptions.CACHE, "Cache missed live constraints for: " + Trace.toString(new Object[]{this.qualifiedName(eObject.eClass()), eventType, featureName}));
                }
                GetLiveConstraintsOperation operation = new GetLiveConstraintsOperation();
                operation.setNotification(notification);
                cached = this.execute(operation);
                bucket.cacheLiveConstraints(eventType, featureName, cached);
            }
            result.addAll(cached);
        }
        return result;
    }

    public Collection getBatchConstraints(EObject eObject, Collection constraints) {
        EClassBucket bucket;
        Collection cached;
        ArrayList result = constraints;
        if (result == null) {
            result = new ArrayList();
        }
        if ((cached = (bucket = this.getBucket(eObject.eClass())).getBatchConstraints()) == null) {
            if (Trace.shouldTrace(EMFModelValidationDebugOptions.CACHE)) {
                Trace.trace(EMFModelValidationDebugOptions.CACHE, "Cache missed batch constraints for: " + this.qualifiedName(eObject.eClass()));
            }
            GetBatchConstraintsOperation operation = new GetBatchConstraintsOperation(false);
            operation.setTarget(eObject);
            cached = this.execute(operation);
            bucket.cacheBatchConstraints(cached);
        }
        result.addAll(bucket.getBatchConstraints());
        return result;
    }

    private String qualifiedName(EClass eClass) {
        StringBuffer result = new StringBuffer(32);
        this.appendQualifiedName(eClass.getEPackage(), result);
        result.append(eClass.getName());
        return result.toString();
    }

    private void appendQualifiedName(EPackage ePackage, StringBuffer buf) {
        if (ePackage.getESuperPackage() != null) {
            this.appendQualifiedName(ePackage.getESuperPackage(), buf);
        } else {
            buf.append(ePackage.getNsURI());
            buf.append('/');
        }
        buf.append(ePackage.getName());
        buf.append('.');
    }

    public void replace(IModelConstraint oldConstraint, IModelConstraint newConstraint) {
        if (Trace.shouldTrace(EMFModelValidationDebugOptions.CACHE)) {
            Trace.trace(EMFModelValidationDebugOptions.CACHE, "Cache replacing: " + oldConstraint + " with: " + newConstraint);
        }
        Iterator iter = this.buckets.values().iterator();
        while (iter.hasNext()) {
            EClassBucket next = (EClassBucket)iter.next();
            next.replace(oldConstraint, newConstraint);
        }
    }

    private static class EClassBucket {
        private Collection batchConstraints;
        private final Map liveConstraints = new HashMap();

        EClassBucket() {
        }

        Collection getBatchConstraints() {
            return this.batchConstraints;
        }

        void cacheBatchConstraints(Collection constraints) {
            this.batchConstraints = new ArrayList(constraints);
        }

        Collection getLiveConstraints(EMFEventType eventType, String featureName) {
            Map constraintMap;
            if (featureName == null) {
                featureName = ConstraintCache.NOT_A_FEATURE_NAME;
            }
            if ((constraintMap = (Map)this.liveConstraints.get(eventType)) != null) {
                return (Collection)constraintMap.get(featureName);
            }
            return null;
        }

        void cacheLiveConstraints(EMFEventType eventType, String featureName, Collection constraints) {
            HashMap constraintMap;
            if (featureName == null) {
                featureName = ConstraintCache.NOT_A_FEATURE_NAME;
            }
            if ((constraintMap = (HashMap)this.liveConstraints.get(eventType)) == null) {
                constraintMap = new HashMap();
                this.liveConstraints.put(eventType, constraintMap);
            }
            constraintMap.put(featureName, new ArrayList(constraints));
        }

        void replace(IModelConstraint oldConstraint, IModelConstraint newConstraint) {
            if (this.batchConstraints != null && this.batchConstraints.remove(oldConstraint)) {
                this.batchConstraints.add(newConstraint);
            }
            Iterator iter = this.liveConstraints.values().iterator();
            while (iter.hasNext()) {
                Map next = (Map)iter.next();
                Iterator nested = next.values().iterator();
                while (nested.hasNext()) {
                    Collection constraints = (Collection)nested.next();
                    if (constraints == null || !constraints.remove(oldConstraint)) continue;
                    constraints.add(newConstraint);
                }
            }
        }
    }
}

