/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.internal.service.AbstractGetConstraintsOperation;
import org.eclipse.emf.validation.internal.service.AbstractValidationContext;
import org.eclipse.emf.validation.service.IModelConstraintProvider;

public class GetLiveConstraintsOperation
extends AbstractGetConstraintsOperation {
    private EMFEventType eventType;
    private Notification notification;
    private List allEvents;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.validation.internal.service.GetLiveConstraintsOperation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected void setNotification(Notification notification) {
        this.setTarget((EObject)notification.getNotifier());
        EMFEventType newEventType = EMFEventType.getInstance(notification.getEventType());
        if (!$assertionsDisabled && (newEventType == null || newEventType.isNull())) {
            throw new AssertionError();
        }
        this.eventType = newEventType;
        this.notification = notification;
    }

    protected void setAllEvents(List events) {
        this.allEvents = Collections.unmodifiableList(events);
    }

    public final EMFEventType getEventType() {
        return this.eventType;
    }

    public final List getAllEvents() {
        return this.allEvents;
    }

    public final Notification getNotification() {
        return this.notification;
    }

    protected void executeImpl(IModelConstraintProvider provider, Collection constraints) {
        if (!$assertionsDisabled && provider == null) {
            throw new AssertionError();
        }
        provider.getLiveConstraints(this.getNotification(), constraints);
    }

    protected AbstractValidationContext createContext() {
        return new AbstractValidationContext(this){

            public EStructuralFeature getFeature() {
                EStructuralFeature result = null;
                if (this.getNotification().getFeature() instanceof EStructuralFeature) {
                    result = (EStructuralFeature)this.getNotification().getFeature();
                }
                return result;
            }

            public Object getFeatureNewValue() {
                Object result = null;
                if (!this.getEventType().isNull()) {
                    switch (this.getNotification().getEventType()) {
                        case 4: 
                        case 6: 
                        case 8: {
                            result = this.getNotification().getOldValue();
                            break;
                        }
                        default: {
                            result = this.getNotification().getNewValue();
                        }
                    }
                }
                return result;
            }

            public EMFEventType getEventType() {
                return GetLiveConstraintsOperation.this.getEventType();
            }

            public List getAllEvents() {
                return GetLiveConstraintsOperation.this.getAllEvents();
            }

            public Notification getNotification() {
                return GetLiveConstraintsOperation.this.getNotification();
            }
        };
    }
}

