/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.internal.util.Log;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.service.INotificationGenerator;

public class EventTypeService {
    private static EventTypeService instance;
    private static final String A_NAME = "name";
    private static final String A_FEATURE_SPECIFIC = "featureSpecific";
    private static final String A_NOTIFICATION_GENERATOR = "notificationGenerator";
    private final Map notificationGenerators = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.validation.service.EventTypeService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        instance = null;
    }

    private EventTypeService() {
    }

    public static EventTypeService getInstance() {
        if (instance == null) {
            instance = new EventTypeService();
        }
        return instance;
    }

    public void configureEventTypes(IConfigurationElement[] elements) {
        if (!$assertionsDisabled && elements == null) {
            throw new AssertionError();
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i].getName().equals("eventType")) {
                try {
                    String name = elements[i].getAttribute(A_NAME);
                    if (name != null && name.length() > 0) {
                        EMFEventType.addEventType(name, Boolean.valueOf(elements[i].getAttribute(A_FEATURE_SPECIFIC)));
                        String notificationGenerator = elements[i].getAttribute(A_NOTIFICATION_GENERATOR);
                        if (notificationGenerator != null && notificationGenerator.length() > 0) {
                            this.notificationGenerators.put(name, elements[i].createExecutableExtension(A_NOTIFICATION_GENERATOR));
                        }
                    }
                }
                catch (CoreException e) {
                    Trace.catching(this.getClass(), "configureEventTypes()", e);
                    Log.log(e.getStatus());
                }
            }
            ++i;
        }
    }

    public Collection getNotificationGenerators() {
        return Collections.unmodifiableCollection(this.notificationGenerators.values());
    }

    public INotificationGenerator getNotificationGenerator(String eventName) {
        return (INotificationGenerator)this.notificationGenerators.get(eventName);
    }
}

