/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.providers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.AbstractContributionItemProvider;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnDiagramEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class BpmnValidationProvider
extends AbstractContributionItemProvider {
    private static boolean constraintsActive = false;

    public static boolean shouldConstraintsBePrivate() {
        return false;
    }

    protected IAction createAction(String actionId, IWorkbenchPartDescriptor partDescriptor) {
        if ("validateAction".equals(actionId)) {
            return new ValidateAction(partDescriptor);
        }
        return super.createAction(actionId, partDescriptor);
    }

    static boolean isInDefaultEditorContext(Object object) {
        if (BpmnValidationProvider.shouldConstraintsBePrivate() && !constraintsActive) {
            return false;
        }
        if (object instanceof View) {
            return constraintsActive && BpmnDiagramEditPart.MODEL_ID.equals(BpmnVisualIDRegistry.getModelID((View)object));
        }
        return true;
    }

    public static class ValidateAction
    extends Action {
        public static final String MARKER_TYPE = "org.eclipse.stp.bpmn.diagram.diagnostic";
        public static final String VALIDATE_ACTION_KEY = "validateAction";
        private IWorkbenchPartDescriptor workbenchPartDescriptor;

        public ValidateAction(IWorkbenchPartDescriptor workbenchPartDescriptor) {
            this.setId(VALIDATE_ACTION_KEY);
            this.setText(BpmnDiagramMessages.BpmnValidationProvider_action_label);
            this.workbenchPartDescriptor = workbenchPartDescriptor;
        }

        public void run() {
            IWorkbenchPart workbenchPart = this.workbenchPartDescriptor.getPartPage().getActivePart();
            if (workbenchPart instanceof IDiagramWorkbenchPart) {
                final IDiagramWorkbenchPart part = (IDiagramWorkbenchPart)workbenchPart;
                try {
                    new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                            ValidateAction.runValidation((View)part.getDiagram());
                        }
                    }).run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    BpmnDiagramEditorPlugin.getInstance().logError("Validation action failed", e);
                }
            }
        }

        public static void runValidation(View view) {
            final View target = view;
            Runnable task = new Runnable(){

                public void run() {
                    try {
                        constraintsActive = true;
                        ValidateAction.validate(target);
                    }
                    finally {
                        constraintsActive = false;
                    }
                }
            };
            TransactionalEditingDomain txDomain = TransactionUtil.getEditingDomain((EObject)target);
            if (txDomain != null) {
                try {
                    txDomain.runExclusive(task);
                }
                catch (Exception e) {
                    BpmnDiagramEditorPlugin.getInstance().logError("Validation action failed", e);
                }
            } else {
                task.run();
            }
        }

        private static Diagnostic runEMFValidator(View target) {
            if (target.isSetElement() && target.getElement() != null) {
                return new Diagnostician(){

                    public String getObjectLabel(EObject eObject) {
                        return EMFCoreUtil.getQualifiedName((EObject)eObject, (boolean)true);
                    }
                }.validate(target.getElement());
            }
            return Diagnostic.OK_INSTANCE;
        }

        private static void validate(View target) {
            IStatus[] iStatusArray;
            IFile diagramFile = target.eResource() != null ? WorkspaceSynchronizer.getFile((Resource)target.eResource()) : null;
            try {
                if (diagramFile != null) {
                    diagramFile.deleteMarkers(MARKER_TYPE, true, 0);
                }
            }
            catch (CoreException e) {
                BpmnDiagramEditorPlugin.getInstance().logError(null, e);
            }
            Diagnostic diagnostic = ValidateAction.runEMFValidator(target);
            IBatchValidator validator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
            validator.setIncludeLiveConstraints(true);
            IStatus status = Status.OK_STATUS;
            if (target.isSetElement() && target.getElement() != null) {
                status = validator.validate((Object)target.getElement());
            }
            ArrayList allStatuses = new ArrayList();
            if (status.isMultiStatus()) {
                iStatusArray = status.getChildren();
            } else {
                IStatus[] iStatusArray2 = new IStatus[1];
                iStatusArray = iStatusArray2;
                iStatusArray2[0] = status;
            }
            allStatuses.addAll(Arrays.asList(iStatusArray));
            HashSet<EObject> targets = new HashSet<EObject>();
            Iterator it = diagnostic.getChildren().iterator();
            while (it.hasNext()) {
                targets.add(ValidateAction.getDiagnosticTarget((Diagnostic)it.next()));
            }
            for (Object nextStatus : allStatuses) {
                if (!(nextStatus instanceof IConstraintStatus)) continue;
                targets.add(((IConstraintStatus)nextStatus).getTarget());
            }
            Map viewMap = ValidateAction.buildElement2ViewMap(target, targets);
            for (Diagnostic nextDiagnostic : diagnostic.getChildren()) {
                List data = nextDiagnostic.getData();
                if (data.isEmpty() || !(data.get(0) instanceof EObject)) continue;
                EObject element = (EObject)data.get(0);
                View view = ValidateAction.findTargetView(element, viewMap);
                if (diagramFile == null) continue;
                ValidateAction.addMarker(diagramFile, view != null ? view : target, element, nextDiagnostic.getMessage(), ValidateAction.diagnosticToStatusSeverity(nextDiagnostic.getSeverity()));
            }
            for (Object nextStatusObj : allStatuses) {
                if (!(nextStatusObj instanceof IConstraintStatus)) continue;
                IConstraintStatus nextStatus = (IConstraintStatus)nextStatusObj;
                View view = ValidateAction.findTargetView(nextStatus.getTarget(), viewMap);
                if (diagramFile == null) continue;
                ValidateAction.addMarker(diagramFile, view != null ? view : target, nextStatus.getTarget(), nextStatus.getMessage(), nextStatus.getSeverity());
            }
        }

        private static View findTargetView(EObject targetElement, Map viewMap) {
            if (targetElement instanceof View) {
                return (View)targetElement;
            }
            EObject container = targetElement;
            while (container != null) {
                if (viewMap.containsKey(container)) {
                    return (View)viewMap.get(container);
                }
                container = container.eContainer();
            }
            return null;
        }

        private static Map buildElement2ViewMap(View view, Set targets) {
            HashMap map = new HashMap();
            ValidateAction.getElement2ViewMap(view, map, targets);
            if (!targets.isEmpty()) {
                HashSet<EObject> path = new HashSet<EObject>();
                block0: for (EObject nextNotMapped : targets) {
                    EObject container = nextNotMapped.eContainer();
                    while (container != null) {
                        if (map.containsKey(container)) continue block0;
                        path.add(container);
                        container = container.eContainer();
                    }
                }
                ValidateAction.getElement2ViewMap(view, map, path);
            }
            return map;
        }

        private static void getElement2ViewMap(View view, Map map, Set targets) {
            if (!map.containsKey(view.getElement()) && targets.remove(view.getElement())) {
                map.put(view.getElement(), view);
            }
            Iterator it = view.getChildren().iterator();
            while (it.hasNext()) {
                ValidateAction.getElement2ViewMap((View)it.next(), map, targets);
            }
            if (view instanceof Diagram) {
                it = ((Diagram)view).getEdges().iterator();
                while (it.hasNext()) {
                    ValidateAction.getElement2ViewMap((View)it.next(), map, targets);
                }
            }
        }

        private static void addMarker(IFile file, View view, EObject element, String message, int statusSeverity) {
            try {
                IMarker marker = file.createMarker(MARKER_TYPE);
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("location", (Object)EMFCoreUtil.getQualifiedName((EObject)element, (boolean)true));
                marker.setAttribute("elementId", (Object)ViewUtil.getIdStr((View)view));
                int markerSeverity = 0;
                if (statusSeverity == 2) {
                    markerSeverity = 1;
                } else if (statusSeverity == 4 || statusSeverity == 8) {
                    markerSeverity = 2;
                }
                marker.setAttribute("severity", markerSeverity);
            }
            catch (CoreException e) {
                BpmnDiagramEditorPlugin.getInstance().logError(null, e);
            }
        }

        private static EObject getDiagnosticTarget(Diagnostic diagnostic) {
            if (!diagnostic.getData().isEmpty()) {
                Object target = diagnostic.getData().get(0);
                return target instanceof EObject ? (EObject)target : null;
            }
            return null;
        }

        private static int diagnosticToStatusSeverity(int diagnosticSeverity) {
            if (diagnosticSeverity == 0) {
                return 0;
            }
            if (diagnosticSeverity == 1) {
                return 1;
            }
            if (diagnosticSeverity == 2) {
                return 2;
            }
            if (diagnosticSeverity == 4 || diagnosticSeverity == 8) {
                return 4;
            }
            return 1;
        }
    }
}

