/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.ui.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.server.generic.servertype.definition.Property;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.jst.server.generic.ui.internal.GenericServerComposite;
import org.eclipse.jst.server.generic.ui.internal.GenericServerCompositeDecorator;
import org.eclipse.jst.server.generic.ui.internal.GenericServerUIMessages;
import org.eclipse.jst.server.generic.ui.internal.SWTUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public abstract class ServerTypeDefinitionDecorator
implements GenericServerCompositeDecorator {
    protected static final String CONTEXT_RUNTIME = "runtime";
    protected static final String CONTEXT_SERVER = "server";
    private ServerRuntime fDefinition;
    private Map fProperties;
    private String fContext;
    private String fLastMessage;
    protected IWizardHandle fWizard;
    private List fPropertyControls = new ArrayList();

    public ServerTypeDefinitionDecorator(ServerRuntime definition, Map initialProperties, String context, IWizardHandle handle) {
        this.fDefinition = definition;
        this.fProperties = initialProperties;
        this.fContext = context;
        this.fWizard = handle;
    }

    public void decorate(GenericServerComposite composite) {
        Object properties = null;
        properties = this.fDefinition == null ? new ArrayList(0) : this.fDefinition.getProperty();
        int i = 0;
        while (i < properties.size()) {
            Property property = (Property)properties.get(i);
            if (this.fContext.equals(property.getContext())) {
                this.createPropertyControl(composite, property);
            }
            ++i;
        }
        Dialog.applyDialogFont((Control)composite);
    }

    private void createPropertyControl(Composite parent, Property property) {
        if ("directory".equals(property.getType())) {
            Text path = SWTUtil.createLabeledPath(property.getLabel(), this.getPropertyValue(property), parent);
            path.setData((Object)property);
            path.addModifyListener((ModifyListener)new PathModifyListener());
            this.registerControl((Control)path);
        } else if ("file".equals(property.getType())) {
            Text file = SWTUtil.createLabeledFile(property.getLabel(), this.getPropertyValue(property), parent);
            file.setData((Object)property);
            file.addModifyListener((ModifyListener)new PathModifyListener());
            this.registerControl((Control)file);
        } else if ("boolean".equals(property.getType())) {
            Button bool = SWTUtil.createLabeledCheck(property.getLabel(), "true".equals(this.getPropertyValue(property)), parent);
            bool.setData((Object)property);
            this.registerControl((Control)bool);
        } else if ("select".equals(property.getType())) {
            StringTokenizer tokenizer = new StringTokenizer(property.getDefault(), ",");
            int tokenCount = tokenizer.countTokens();
            String[] values = new String[tokenCount];
            int i = 0;
            while (tokenizer.hasMoreTokens() && i < tokenCount) {
                values[i] = tokenizer.nextToken();
                ++i;
            }
            Combo combo = SWTUtil.createLabeledCombo(property.getLabel(), values, parent);
            combo.setData((Object)property);
            this.registerControl((Control)combo);
        } else if ("combo".equals(property.getType())) {
            StringTokenizer tokenizer = new StringTokenizer(property.getDefault(), ",");
            int tokenCount = tokenizer.countTokens();
            String[] values = new String[tokenCount];
            int i = 0;
            while (tokenizer.hasMoreTokens() && i < tokenCount) {
                values[i] = tokenizer.nextToken();
                ++i;
            }
            Combo combo = SWTUtil.createLabeledEditableCombo(property.getLabel(), values, this.getPropertyValue(property), parent);
            combo.setData((Object)property);
            this.registerControl((Control)combo);
        } else {
            Text defaultText = SWTUtil.createLabeledText(property.getLabel(), this.getPropertyValue(property), parent);
            defaultText.setData((Object)property);
            this.registerControl((Control)defaultText);
        }
    }

    private void registerControl(Control control) {
        this.fPropertyControls.add(control);
    }

    private String getPropertyValue(Property property) {
        if (this.fProperties != null && !this.fProperties.isEmpty()) {
            return this.fDefinition.getResolver().resolveProperties((String)this.fProperties.get(property.getId()));
        }
        if ("combo".equals(property.getType())) {
            StringTokenizer tokenizer = new StringTokenizer(property.getDefault(), ",");
            if (tokenizer.hasMoreTokens()) {
                return this.fDefinition.getResolver().resolveProperties(tokenizer.nextToken());
            }
            return "";
        }
        return this.fDefinition.getResolver().resolveProperties(property.getDefault());
    }

    public Map getValues() {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        int i = 0;
        while (i < this.fPropertyControls.size()) {
            Property prop = (Property)((Control)this.fPropertyControls.get(i)).getData();
            if (this.fPropertyControls.get(i) instanceof Button) {
                Button button = (Button)this.fPropertyControls.get(i);
                propertyMap.put(prop.getId(), Boolean.toString(button.getSelection()));
            } else if (this.fPropertyControls.get(i) instanceof Combo) {
                Combo combo = (Combo)this.fPropertyControls.get(i);
                int index = combo.getSelectionIndex();
                if (index > 0) {
                    propertyMap.put(prop.getId(), combo.getItem(index));
                } else {
                    propertyMap.put(prop.getId(), combo.getText());
                }
            } else {
                Text text = (Text)this.fPropertyControls.get(i);
                propertyMap.put(prop.getId(), text.getText());
            }
            ++i;
        }
        return propertyMap;
    }

    private final class PathModifyListener
    implements ModifyListener {
        private PathModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String path = ((Text)e.widget).getText();
            if (path.length() < 1) {
                ServerTypeDefinitionDecorator.this.fLastMessage = GenericServerUIMessages.emptyPath;
                ServerTypeDefinitionDecorator.this.fWizard.setMessage(ServerTypeDefinitionDecorator.this.fLastMessage, 3);
            } else if (!this.pathExist(path)) {
                ServerTypeDefinitionDecorator.this.fLastMessage = NLS.bind((String)GenericServerUIMessages.invalidPath, (Object)path);
                ServerTypeDefinitionDecorator.this.fWizard.setMessage(ServerTypeDefinitionDecorator.this.fLastMessage, 3);
            } else {
                if (ServerTypeDefinitionDecorator.this.fLastMessage != null && ServerTypeDefinitionDecorator.this.fLastMessage.equals(ServerTypeDefinitionDecorator.this.fWizard.getMessage())) {
                    ServerTypeDefinitionDecorator.this.fLastMessage = null;
                    ServerTypeDefinitionDecorator.this.fWizard.setMessage(null, 0);
                }
                ServerTypeDefinitionDecorator.this.validate();
            }
        }

        private boolean pathExist(String path) {
            File f = new File(path);
            return f.exists();
        }
    }
}

