/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.validation.internal.ConfigurationConstants;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class TaskListUtility
implements ConfigurationConstants {
    protected static final int DEPTH_INFINITE = 2;
    protected static final int DEPTH_ZERO = 0;
    protected static final String VALIDATION_MARKER_TARGETOBJECT = "targetObject";
    private static final IMarker[] NO_MARKERS = new IMarker[0];

    public static IWorkspaceRoot getRoot() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root;
    }

    public static IMarker setPriority(IMarker item, int priority) throws CoreException {
        Map attrib = item.getAttributes();
        attrib.put("priority", new Integer(priority));
        item.setAttributes(attrib);
        return item;
    }

    public static IMarker addTask(String pluginId, IResource resource, String location, String messageId, String message, int markerType, String markerName, String targetObjectName, String groupName, int offset, int length) throws CoreException {
        if (message == null || resource == null || !resource.exists()) {
            return null;
        }
        int severity = TaskListUtility.getSeverity(markerType);
        IMarker item = null;
        item = markerName != null && markerName.length() > 0 ? resource.createMarker(markerName) : resource.createMarker("org.eclipse.wst.validation.problemmarker");
        boolean offsetSet = offset != -1 && length != -1;
        int size = offsetSet ? 10 : 8;
        String[] attribNames = new String[size];
        Object[] attribValues = new Object[size];
        attribNames[0] = "owner";
        attribValues[0] = pluginId;
        attribNames[1] = "validationSeverity";
        attribValues[1] = new Integer(markerType);
        attribNames[2] = VALIDATION_MARKER_TARGETOBJECT;
        attribValues[2] = targetObjectName == null ? "" : targetObjectName;
        attribNames[3] = "groupName";
        attribValues[3] = groupName == null ? "" : groupName;
        attribNames[4] = "message";
        attribValues[4] = message;
        attribNames[5] = "messageId";
        attribValues[5] = messageId;
        attribNames[6] = "severity";
        attribValues[6] = new Integer(severity);
        try {
            Integer lineNumber = Integer.valueOf(location);
            attribNames[7] = "lineNumber";
            attribValues[7] = lineNumber;
        }
        catch (NumberFormatException numberFormatException) {
            attribNames[7] = "location";
            attribValues[7] = location;
        }
        if (offsetSet) {
            attribNames[8] = "charStart";
            attribValues[8] = new Integer(offset);
            attribNames[9] = "charEnd";
            attribValues[9] = new Integer(offset + length);
        }
        item.setAttributes(attribNames, attribValues);
        return item;
    }

    public static IMarker addTask(String pluginId, IResource resource, String location, String messageId, String message, int markerType, String targetObjectName, String groupName, int offset, int length) throws CoreException {
        if (message == null || resource == null || !resource.exists()) {
            return null;
        }
        int severity = TaskListUtility.getSeverity(markerType);
        IMarker item = resource.createMarker("org.eclipse.wst.validation.problemmarker");
        boolean offsetSet = offset != -1 && length != -1;
        int size = offsetSet ? 10 : 8;
        String[] attribNames = new String[size];
        Object[] attribValues = new Object[size];
        attribNames[0] = "owner";
        attribValues[0] = pluginId;
        attribNames[1] = "validationSeverity";
        attribValues[1] = new Integer(markerType);
        attribNames[2] = VALIDATION_MARKER_TARGETOBJECT;
        attribValues[2] = targetObjectName == null ? "" : targetObjectName;
        attribNames[3] = "groupName";
        attribValues[3] = groupName == null ? "" : groupName;
        attribNames[4] = "message";
        attribValues[4] = message;
        attribNames[5] = "messageId";
        attribValues[5] = messageId;
        attribNames[6] = "severity";
        attribValues[6] = new Integer(severity);
        try {
            Integer lineNumber = Integer.valueOf(location);
            attribNames[7] = "lineNumber";
            attribValues[7] = lineNumber;
        }
        catch (NumberFormatException numberFormatException) {
            attribNames[7] = "location";
            attribValues[7] = location;
        }
        if (offsetSet) {
            attribNames[8] = "charStart";
            attribValues[8] = new Integer(offset);
            attribNames[9] = "charEnd";
            attribValues[9] = new Integer(offset + length);
        }
        item.setAttributes(attribNames, attribValues);
        return item;
    }

    private static int getSeverity(int severityEnumValue) {
        switch (severityEnumValue) {
            case 1: {
                return 2;
            }
            case 4: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return 1;
    }

    private static int getDepth(IResource resource) {
        if (resource instanceof IProject) {
            return 2;
        }
        if (resource instanceof IWorkspaceRoot) {
            return 2;
        }
        return 0;
    }

    public static IMarker[] getValidationTasks(int severity, IProject project) {
        return TaskListUtility.getValidationTasks((IResource)project, severity);
    }

    public static IMarker[] getValidationTasks(IResource resource, int severity) {
        return TaskListUtility.getValidationTasks(resource, severity, TaskListUtility.getDepth(resource));
    }

    public static boolean isOwner(IMarker marker, String ownerId) {
        Object owner;
        block4: {
            try {
                owner = marker.getAttribute("owner");
                if (owner != null && owner instanceof String) break block4;
                return false;
            }
            catch (CoreException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    LogEntry entry = ValidationPlugin.getLogEntry();
                    entry.setSourceID("TaskListUtility.isOwner(IMarker, ownerId)");
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
                return false;
            }
        }
        return ((String)owner).equals(ownerId);
    }

    private static IMarker[] getValidationTasks(IResource resource, int severity, int depth) {
        int validCount;
        IMarker[] tempMarkers;
        block18: {
            tempMarkers = null;
            validCount = 0;
            try {
                IMarker[] allMarkers = null;
                try {
                    allMarkers = resource.findMarkers("org.eclipse.wst.validation.problemmarker", true, depth);
                }
                catch (CoreException exc) {
                    Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        LogEntry entry = ValidationPlugin.getLogEntry();
                        entry.setSourceID("TaskListUtility.getValidationTasks(IResource, int)");
                        entry.setTargetException((Throwable)exc);
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                    return NO_MARKERS;
                }
                if (allMarkers.length == 0) break block18;
                tempMarkers = new IMarker[allMarkers.length];
                int i = 0;
                while (i < allMarkers.length) {
                    block20: {
                        IMarker marker;
                        block19: {
                            marker = allMarkers[i];
                            Integer filterSeverity = (Integer)marker.getAttribute("validationSeverity");
                            if (filterSeverity == null) {
                                LogEntry entry;
                                Logger logger;
                                try {
                                    marker.setAttribute("severity", TaskListUtility.getSeverity(severity));
                                    break block19;
                                }
                                catch (CoreException exc) {
                                    logger = ValidationPlugin.getPlugin().getMsgLogger();
                                    if (logger.isLoggingLevel(Level.SEVERE)) {
                                        entry = ValidationPlugin.getLogEntry();
                                        entry.setSourceID("TaskListUtility.getValidationTasks(int, IResource, int)");
                                        entry.setTargetException((Throwable)exc);
                                        logger.write(Level.SEVERE, (Object)entry);
                                    }
                                    break block20;
                                }
                                catch (Exception exc) {
                                    logger = ValidationPlugin.getPlugin().getMsgLogger();
                                    if (logger.isLoggingLevel(Level.SEVERE)) {
                                        entry = ValidationPlugin.getLogEntry();
                                        entry.setSourceID("TaskListUtility.getValidationTasks(int, IResource, int)");
                                        entry.setTargetException((Throwable)exc);
                                        logger.write(Level.SEVERE, (Object)entry);
                                    }
                                    break block20;
                                }
                            }
                            if ((severity & filterSeverity) == 0) break block20;
                        }
                        tempMarkers[validCount++] = marker;
                    }
                    ++i;
                }
            }
            catch (CoreException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block18;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("TaskListUtility.getValidationTasks(int, IResource, int)");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
        if (validCount == 0) {
            return NO_MARKERS;
        }
        IMarker[] validMarkers = new IMarker[validCount];
        System.arraycopy(tempMarkers, 0, validMarkers, 0, validCount);
        return validMarkers;
    }

    public static IMarker[] getValidationTasks(IResource resource, String messageOwner) {
        return TaskListUtility.getValidationTasks(resource, new String[]{messageOwner}, TaskListUtility.getDepth(resource));
    }

    public static IMarker[] getValidationTasks(IResource resource, String[] messageOwners) {
        return TaskListUtility.getValidationTasks(resource, messageOwners, TaskListUtility.getDepth(resource));
    }

    private static IMarker[] getValidationTasks(IResource resource, String[] messageOwners, int depth) {
        IMarker[] markers = TaskListUtility.getValidationTasks(resource, 7, depth);
        if (markers.length == 0) {
            return NO_MARKERS;
        }
        IMarker[] temp = new IMarker[markers.length];
        int validCount = 0;
        int i = 0;
        while (i < markers.length) {
            block7: {
                IMarker marker = markers[i];
                try {
                    Object owner = marker.getAttribute("owner");
                    if (owner == null || !(owner instanceof String)) break block7;
                    int j = 0;
                    while (j < messageOwners.length) {
                        String messageOwner = messageOwners[j];
                        if (((String)owner).equals(messageOwner)) {
                            temp[validCount++] = marker;
                            break;
                        }
                        ++j;
                    }
                }
                catch (CoreException exc) {
                    Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        LogEntry entry = ValidationPlugin.getLogEntry();
                        entry.setSourceID("TaskListUtility.getValidationTasks(project, String[])");
                        entry.setTargetException((Throwable)exc);
                        logger.write(Level.SEVERE, (Object)entry);
                    }
                    return NO_MARKERS;
                }
            }
            ++i;
        }
        IMarker[] result = new IMarker[validCount];
        System.arraycopy(temp, 0, result, 0, validCount);
        return result;
    }

    private static IMarker[] getValidationTasks(IResource resource, String[] messageOwner, String objectName, String groupName, int depth) throws CoreException {
        if (messageOwner == null || resource == null) {
            return NO_MARKERS;
        }
        int validCount = 0;
        IMarker[] validList = null;
        IMarker[] markers = TaskListUtility.getValidationTasks(resource, messageOwner, depth);
        if (markers != null) {
            validList = new IMarker[markers.length];
            int i = 0;
            while (i < markers.length) {
                Object group;
                Object targetObject;
                IMarker marker = markers[i];
                if ((objectName == null || (targetObject = marker.getAttribute(VALIDATION_MARKER_TARGETOBJECT)) != null && targetObject instanceof String && ((String)targetObject).equals(objectName)) && (groupName == null || (group = marker.getAttribute("groupName")) != null && group instanceof String && ((String)group).equals(groupName))) {
                    validList[validCount++] = marker;
                }
                ++i;
            }
        }
        if (validCount == 0) {
            return NO_MARKERS;
        }
        IMarker[] result = new IMarker[validCount];
        System.arraycopy(validList, 0, result, 0, validCount);
        return result;
    }

    public static void removeAllTasks(IResource resource) {
        block3: {
            if (resource == null) {
                return;
            }
            try {
                IMarker[] markers = TaskListUtility.getValidationTasks(resource, 7);
                ResourcesPlugin.getWorkspace().deleteMarkers(markers);
            }
            catch (CoreException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block3;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceID("WorkbenchMonitor.removeAllMessages(String[], IResource, String)");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    public static void removeAllTasks(IResource resource, String[] owners) throws CoreException {
        TaskListUtility.removeAllTasks(resource, owners, null);
    }

    public static void removeAllTasks(IResource resource, String owner, String objectName) throws CoreException {
        TaskListUtility.removeAllTasks(resource, new String[]{owner}, objectName);
    }

    public static void removeAllTasks(IResource resource, String[] owners, String objectName) throws CoreException {
        TaskListUtility.removeAllTasks(resource, owners, objectName, TaskListUtility.getDepth(resource));
    }

    protected static void removeAllTasks(IResource resource, String[] owners, String objectName, int depth) throws CoreException {
        TaskListUtility.removeTaskSubset(resource, owners, objectName, null, depth);
    }

    public static void removeTaskSubset(IResource resource, String[] owners, String objectName, String groupName) throws CoreException {
        TaskListUtility.removeTaskSubset(resource, owners, objectName, groupName, TaskListUtility.getDepth(resource));
    }

    protected static void removeTaskSubset(IResource resource, String[] owners, String objectName, String groupName, int depth) throws CoreException {
        if (owners == null || resource == null) {
            return;
        }
        IMarker[] allTasks = TaskListUtility.getValidationTasks(resource, owners, objectName, groupName, depth);
        if (allTasks.length > 0) {
            ResourcesPlugin.getWorkspace().deleteMarkers(allTasks);
        }
    }

    public static void updateOwner(String from, String to) throws CoreException {
        TaskListUtility.updateOwner(from, to, (IResource)TaskListUtility.getRoot());
    }

    public static void updateOwner(String from, String to, IResource resource) throws CoreException {
        IMarker[] ownedMarkers = TaskListUtility.getValidationTasks(resource, from);
        if (ownedMarkers == null) {
            return;
        }
        int i = 0;
        while (i < ownedMarkers.length) {
            IMarker marker = ownedMarkers[i];
            marker.setAttribute("owner", (Object)to);
            ++i;
        }
    }
}

