/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.InternalValidatorManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.TimeEntry;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.EnabledIncrementalValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.EnabledValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class ValidationBuilder
extends IncrementalProjectBuilder {
    public static final int NO_DELTA_CHANGE = -1;
    protected List referencedProjects;
    protected IWorkbenchContext workbenchContext = null;

    private IProject[] getAllReferencedProjects(IProject project, Set visitedProjects) {
        if (visitedProjects == null) {
            visitedProjects = new HashSet<IProject>();
        } else {
            if (visitedProjects.contains(project)) {
                return this.getReferencedProjects();
            }
            visitedProjects.add(project);
        }
        if (this.referencedProjects == null) {
            this.referencedProjects = new ArrayList();
        }
        try {
            if (project.isAccessible()) {
                IProject[] refProjArray = project.getReferencedProjects();
                this.collectReferecedProject(refProjArray);
                int i = 0;
                while (i < refProjArray.length) {
                    IProject refProject = refProjArray[i];
                    this.getAllReferencedProjects(refProject, visitedProjects);
                    ++i;
                }
            }
            return this.getReferencedProjects();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public IWorkbenchContext getWorkbenchContext() {
        if (this.workbenchContext == null) {
            this.workbenchContext = new WorkbenchContext();
            this.workbenchContext.setProject(this.getProject());
        }
        return this.workbenchContext;
    }

    private void collectReferecedProject(IProject[] refProjArray) {
        int i = 0;
        while (i < refProjArray.length) {
            IProject project = refProjArray[i];
            if (!this.referencedProjects.contains(project)) {
                this.referencedProjects.add(project);
            }
            ++i;
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        block4: {
            IProject currentProject = this.getProject();
            if (currentProject == null || !currentProject.isAccessible()) {
                return;
            }
            try {
                ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(currentProject);
                ValidatorMetaData[] vmds = prjp.getValidators();
                int i = 0;
                while (i < vmds.length) {
                    ValidatorMetaData vmd = vmds[i];
                    WorkbenchReporter.removeAllMessages((IResource)currentProject, vmd.getValidatorNames(), null);
                    ++i;
                }
            }
            catch (InvocationTargetException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block4;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("ValidatorManager.updateTaskList(" + currentProject.getName() + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() == null) break block4;
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    private IProject[] getReferencedProjects() {
        IProject[] refProjArray = new IProject[this.referencedProjects.size()];
        int i = 0;
        while (i < this.referencedProjects.size()) {
            refProjArray[i] = (IProject)this.referencedProjects.get(i);
            ++i;
        }
        return refProjArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IProject[] build(int kind, Map parameters, IProgressMonitor monitor) {
        IProject[] iProjectArray;
        IResourceDelta delta;
        Logger logger;
        int executionMap;
        long start;
        block18: {
            IProject[] iProjectArray2;
            block17: {
                IProject[] iProjectArray3;
                block16: {
                    IProject[] iProjectArray4;
                    block15: {
                        start = System.currentTimeMillis();
                        executionMap = 0;
                        logger = ValidationPlugin.getPlugin().getMsgLogger();
                        delta = null;
                        IProject project = this.getProject();
                        IProject[] referenced = this.getAllReferencedProjects(project, null);
                        try {
                            try {
                                boolean doFullBuild;
                                if (ValidatorManager.getManager().isSuspended(project)) {
                                    executionMap |= 1;
                                    iProjectArray4 = referenced;
                                    Object var14_16 = null;
                                    this.referencedProjects = null;
                                    break block15;
                                }
                                ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
                                delta = this.getDelta(project);
                                boolean bl = doFullBuild = kind == 6;
                                if (!doFullBuild && delta == null) {
                                    if (this.isReferencedProjectInDelta(referenced)) {
                                        this.performFullBuildForReferencedProjectChanged(monitor, prjp);
                                    } else {
                                        String[] msgParms = new String[]{project.getName()};
                                        monitor.subTask(ResourceHandler.getExternalizedMessage("VBF_STATUS_NULL_DELTA", msgParms));
                                        executionMap |= 4;
                                    }
                                    iProjectArray3 = referenced;
                                    break block16;
                                }
                                if (doFullBuild) {
                                    this.performFullBuild(monitor, prjp);
                                } else {
                                    if (delta.getAffectedChildren().length == 0) {
                                        if (this.isReferencedProjectInDelta(referenced)) {
                                            this.performFullBuildForReferencedProjectChanged(monitor, prjp);
                                        } else {
                                            executionMap |= 0x10;
                                        }
                                        iProjectArray2 = referenced;
                                        break block17;
                                    }
                                    EnabledIncrementalValidatorsOperation operation = new EnabledIncrementalValidatorsOperation(project, delta, true);
                                    operation.run(monitor);
                                }
                                iProjectArray = referenced;
                                break block18;
                            }
                            catch (InvocationTargetException exc) {
                                this.logInvocationTargetException(logger, exc);
                                executionMap |= 0x20;
                                IProject[] iProjectArray5 = referenced;
                                Object var14_20 = null;
                                this.referencedProjects = null;
                                if (!logger.isLoggingLevel(Level.FINE)) return iProjectArray5;
                                this.logBuilderTimeEntry(start, executionMap, logger, delta);
                                return iProjectArray5;
                            }
                            catch (Exception exc) {
                                this.logBuildError(logger, exc);
                                executionMap |= 0x40;
                                IProject[] iProjectArray6 = referenced;
                                Object var14_21 = null;
                                this.referencedProjects = null;
                                if (!logger.isLoggingLevel(Level.FINE)) return iProjectArray6;
                                this.logBuilderTimeEntry(start, executionMap, logger, delta);
                                return iProjectArray6;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var14_22 = null;
                            this.referencedProjects = null;
                            if (!logger.isLoggingLevel(Level.FINE)) throw throwable;
                            this.logBuilderTimeEntry(start, executionMap, logger, delta);
                            throw throwable;
                        }
                    }
                    if (!logger.isLoggingLevel(Level.FINE)) return iProjectArray4;
                    this.logBuilderTimeEntry(start, executionMap, logger, delta);
                    return iProjectArray4;
                }
                Object var14_17 = null;
                this.referencedProjects = null;
                if (!logger.isLoggingLevel(Level.FINE)) return iProjectArray3;
                this.logBuilderTimeEntry(start, executionMap, logger, delta);
                return iProjectArray3;
            }
            Object var14_18 = null;
            this.referencedProjects = null;
            if (!logger.isLoggingLevel(Level.FINE)) return iProjectArray2;
            this.logBuilderTimeEntry(start, executionMap, logger, delta);
            return iProjectArray2;
        }
        Object var14_19 = null;
        this.referencedProjects = null;
        if (!logger.isLoggingLevel(Level.FINE)) return iProjectArray;
        this.logBuilderTimeEntry(start, executionMap, logger, delta);
        return iProjectArray;
    }

    private boolean isReferencedProjectInDelta(IProject[] referenced) {
        IProject p = null;
        int i = 0;
        while (i < referenced.length) {
            p = referenced[i];
            IResourceDelta delta = this.getDelta(p);
            if (delta != null && delta.getAffectedChildren().length > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void performFullBuildForReferencedProjectChanged(IProgressMonitor monitor, ProjectConfiguration prjp) throws InvocationTargetException {
        this.performFullBuild(monitor, prjp, true);
    }

    private void performFullBuild(IProgressMonitor monitor, ProjectConfiguration prjp) throws InvocationTargetException {
        this.performFullBuild(monitor, prjp, false);
    }

    private void performFullBuild(IProgressMonitor monitor, ProjectConfiguration prjp, boolean onlyDependentValidators) throws InvocationTargetException {
        Object[] enabledValidators = prjp.getEnabledFullBuildValidators(true, onlyDependentValidators);
        if (enabledValidators != null && enabledValidators.length > 0) {
            Set enabledValidatorsSet = InternalValidatorManager.wrapInSet(enabledValidators);
            EnabledValidatorsOperation op = new EnabledValidatorsOperation(this.getProject(), enabledValidatorsSet, true);
            op.run(monitor);
        }
    }

    private void logInvocationTargetException(Logger logger, InvocationTargetException exc) {
        if (logger.isLoggingLevel(Level.SEVERE)) {
            LogEntry entry = ValidationPlugin.getLogEntry();
            entry.setSourceID("ValidationBuilder::build");
            entry.setTargetException((Throwable)exc);
            logger.write(Level.SEVERE, (Object)entry);
            if (exc.getTargetException() != null) {
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    private void logBuildError(Logger logger, Throwable exc) {
        if (logger.isLoggingLevel(Level.SEVERE) && !(exc instanceof OperationCanceledException)) {
            LogEntry entry = ValidationPlugin.getLogEntry();
            entry.setSourceID("ValidationBuilder.build(int, Map, IProgressMonitor)");
            entry.setTargetException(exc);
            logger.write(Level.SEVERE, (Object)entry);
        }
    }

    private void logBuilderTimeEntry(long start, int executionMap, Logger logger, IResourceDelta delta) {
        TimeEntry entry = ValidationPlugin.getTimeEntry();
        entry.setSourceID("ValidationBuilder.build(int, Map, IProgressMonitor)");
        entry.setProjectName(this.getProject().getName());
        entry.setExecutionMap(executionMap);
        entry.setElapsedTime(System.currentTimeMillis() - start);
        if (delta == null) {
            entry.setDetails("delta == null");
        }
        entry.setToolName("ValidationBuilder");
        logger.write(Level.FINE, (Object)entry);
    }
}

