/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.internal;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.ocl.ecore.internal.OCLDebugOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLEcorePlugin
extends EMFPlugin {
    public static final String EMPTY_STRING = "";
    private static final String PREFIX_THROWING = "THROWN ";
    private static final String SEPARATOR_SPACE = " ";
    private static final String PARENTHESIS_OPEN = "(";
    private static final String PARENTHESIS_CLOSE = ")";
    private static final String SEPARATOR_METHOD = "#";
    private static final String PREFIX_CATCHING = "CAUGHT ";
    private static OCLEcorePlugin INSTANCE = new OCLEcorePlugin();
    private static Implementation plugin;

    public OCLEcorePlugin() {
        super(new ResourceLocator[0]);
    }

    public static String getPluginId() {
        return OCLEcorePlugin.getPlugin() != null ? OCLEcorePlugin.getPlugin().getBundle().getSymbolicName() : "org.eclipse.ocl.ecore";
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static OCLEcorePlugin getInstance() {
        return INSTANCE;
    }

    public static void catching(Class<?> clazz, String methodName, Throwable throwable) {
        if (OCLEcorePlugin.shouldTrace(OCLDebugOptions.EXCEPTIONS_CATCHING)) {
            System.out.println(PREFIX_CATCHING + throwable.getMessage() + SEPARATOR_SPACE + PARENTHESIS_OPEN + clazz.getName() + SEPARATOR_METHOD + methodName + PARENTHESIS_CLOSE);
            throwable.printStackTrace(System.err);
        }
    }

    public static void throwing(Class<?> clazz, String methodName, Throwable throwable) {
        if (OCLEcorePlugin.shouldTrace(OCLDebugOptions.EXCEPTIONS_THROWING)) {
            System.out.println(PREFIX_THROWING + throwable.getMessage() + SEPARATOR_SPACE + PARENTHESIS_OPEN + clazz.getName() + SEPARATOR_METHOD + methodName + PARENTHESIS_CLOSE);
            throwable.printStackTrace(System.err);
        }
    }

    public static boolean shouldTrace(String option) {
        if (OCLEcorePlugin.getPlugin() != null) {
            if (OCLEcorePlugin.getPlugin().isDebugging()) {
                return Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)option));
            }
            return false;
        }
        return Boolean.getBoolean("org.eclipse.ocl.ecore.debug");
    }

    public static void error(int code, String message) {
        OCLEcorePlugin.error(code, message, null);
    }

    public static void error(int code, String message, Throwable throwable) {
        OCLEcorePlugin.log(4, code, message, throwable);
    }

    public static void info(String message) {
        OCLEcorePlugin.info(0, message);
    }

    public static void info(int code, String message) {
        OCLEcorePlugin.info(code, message, null);
    }

    public static void info(int code, String message, Throwable throwable) {
        OCLEcorePlugin.log(1, code, message, throwable);
    }

    public static void warning(int code, String message) {
        OCLEcorePlugin.warning(code, message, null);
    }

    public static void warning(int code, String message, Throwable throwable) {
        OCLEcorePlugin.log(2, code, message, throwable);
    }

    public static void log(int severity, int code, String message, Throwable throwable) {
        String msg = message == null ? EMPTY_STRING : message;
        try {
            if (OCLEcorePlugin.getPlugin() != null) {
                OCLEcorePlugin.getPlugin().log(new Status(severity, OCLEcorePlugin.getPluginId(), code, msg, throwable));
            } else if (OCLEcorePlugin.shouldTrace(OCLDebugOptions.DEBUG)) {
                switch (code) {
                    case 2: {
                        System.err.print("WARNING ");
                        break;
                    }
                    case 4: 
                    case 8: {
                        System.err.print("ERROR ");
                        break;
                    }
                    default: {
                        return;
                    }
                }
                System.err.print(code);
                System.err.print(": ");
                System.err.println(message);
                if (throwable != null) {
                    throwable.printStackTrace(System.err);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            OCLEcorePlugin.catching(OCLEcorePlugin.class, "log", iae);
        }
    }

    public static Resource.Factory getEcoreResourceFactory() {
        return new ResourceFactoryImpl(){

            public Resource createResource(URI uri) {
                return new ResourceImpl(uri){

                    public EObject getEObject(String uriFragment) {
                        return super.getEObject(URI.decode((String)uriFragment));
                    }
                };
            }
        };
    }

    static /* synthetic */ Implementation access$0() {
        return plugin;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }
    }
}

