/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.change.impl.ChangeDescriptionImpl;
import org.eclipse.emf.transaction.TransactionChangeDescription;
import org.eclipse.emf.workspace.internal.EMFWorkspacePlugin;
import org.eclipse.emf.workspace.internal.l10n.Messages;
import org.eclipse.osgi.util.NLS;

public class OperationChangeDescription
extends ChangeDescriptionImpl
implements TransactionChangeDescription {
    private boolean isRedone = true;
    private IUndoableOperation operation;
    private Reference info;

    public OperationChangeDescription(IUndoableOperation operation, IAdaptable info) {
        this.operation = operation;
        this.info = new WeakReference<IAdaptable>(info);
    }

    public boolean canApply() {
        return this.operation != null && (this.isRedone ? this.operation.canUndo() : this.operation.canRedo());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void apply() {
        try {
            try {
                this.operation.undo((IProgressMonitor)new NullProgressMonitor(), (IAdaptable)this.info.get());
            }
            catch (ExecutionException e) {
                EMFWorkspacePlugin.INSTANCE.log(new Status(4, EMFWorkspacePlugin.getPluginId(), 32, NLS.bind((String)Messages.rollbackFailed, (Object)this.operation.getLabel()), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.dispose();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.dispose();
            return;
        }
    }

    public void applyAndReverse() {
        try {
            if (this.isRedone) {
                this.operation.undo((IProgressMonitor)new NullProgressMonitor(), (IAdaptable)this.info.get());
                this.isRedone = false;
            } else {
                this.operation.redo((IProgressMonitor)new NullProgressMonitor(), (IAdaptable)this.info.get());
                this.isRedone = true;
            }
        }
        catch (ExecutionException e) {
            EMFWorkspacePlugin.INSTANCE.log(new Status(4, EMFWorkspacePlugin.getPluginId(), 32, NLS.bind((String)Messages.rollbackFailed, (Object)this.operation.getLabel()), (Throwable)e));
        }
    }

    public boolean isEmpty() {
        return false;
    }

    public void dispose() {
        this.operation = null;
        if (this.info != null) {
            this.info.clear();
            this.info = null;
        }
    }
}

