/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.model.IModuleFile;

public class ModuleFile
implements IModuleFile {
    protected IFile file;
    protected File file2;
    protected String name;
    protected IPath path;
    protected long stamp = -1L;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ModuleFile(IFile file, String name, IPath path) {
        this.file = file;
        this.name = name;
        this.path = path;
        if (file != null) {
            this.stamp = file.getModificationStamp() + file.getLocalTimeStamp();
        }
    }

    public ModuleFile(File file, String name, IPath path) {
        this.file2 = file;
        this.name = name;
        this.path = path;
        if (file != null) {
            this.stamp = this.file2.lastModified();
        }
    }

    public ModuleFile(IFile file, String name, IPath path, long stamp) {
        this.file = file;
        this.name = name;
        this.path = path;
        this.stamp = stamp;
    }

    public ModuleFile(String name, IPath path, long stamp) {
        this.name = name;
        this.path = path;
        this.stamp = stamp;
    }

    public long getModificationStamp() {
        return this.stamp;
    }

    public IPath getModuleRelativePath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IModuleFile)) {
            return false;
        }
        IModuleFile mf = (IModuleFile)obj;
        if (!this.name.equals(mf.getName())) {
            return false;
        }
        return this.path.equals((Object)mf.getModuleRelativePath());
    }

    public int hashCode() {
        return this.name.hashCode() * 37 + this.path.hashCode();
    }

    public Object getAdapter(Class cl) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(cl)) {
            return this.file;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.io.File");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(cl)) {
            return this.file2;
        }
        return null;
    }

    public String toString() {
        return "ModuleFile [" + this.name + ", " + this.path + ", " + this.stamp + "]";
    }
}

