/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.Trace;

public class ProjectProperties {
    private static final String PREFERENCE_FOLDER = ".settings";
    private static final String PREFERENCE_FILE = "org.eclipse.wst.server.core.prefs";
    private static final String SERVER_PROJECT_PREF = "org.eclipse.wst.server.core.isServerProject";
    protected IProject project;
    protected boolean serverProject = false;

    public ProjectProperties(IProject project) {
        this.project = project;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPreferences() {
        InputStream in;
        block14: {
            block13: {
                Trace.trace(5, "Loading project preferences: " + this.project);
                if (!this.project.isAccessible()) {
                    return;
                }
                in = null;
                try {
                    try {
                        IFile file;
                        block16: {
                            block15: {
                                file = this.project.getFolder(PREFERENCE_FOLDER).getFile(PREFERENCE_FILE);
                                if (file == null) break block15;
                                if (file.isAccessible()) break block16;
                            }
                            Object var5_4 = null;
                            break block13;
                        }
                        in = file.getContents();
                        Properties p = new Properties();
                        p.load(in);
                        String s = p.getProperty(SERVER_PROJECT_PREF);
                        if (s != null && "true".equals(s)) {
                            this.serverProject = true;
                            break block14;
                        }
                        this.serverProject = false;
                    }
                    catch (Exception e) {
                        Trace.trace(3, "Could not load preferences: " + e.getMessage());
                    }
                    break block14;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    try {
                        if (in == null) throw throwable;
                        in.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
            }
            try {}
            catch (Exception exception) {}
            if (in == null) return;
            in.close();
            return;
        }
        Object var5_6 = null;
        try {}
        catch (Exception exception) {
            return;
        }
        if (in == null) return;
        in.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void savePreferences(IProgressMonitor monitor) throws CoreException {
        IStatus status;
        IFile file;
        if (this.project == null) return;
        if (!this.project.isAccessible()) {
            return;
        }
        IFolder folder = this.project.getFolder(PREFERENCE_FOLDER);
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
        if ((file = this.project.getFolder(PREFERENCE_FOLDER).getFile(PREFERENCE_FILE)).exists() && file.isReadOnly() && (status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null)).getSeverity() == 4) {
            throw new CoreException(status);
        }
        Properties p = new Properties();
        p.put("eclipse.preferences.version", "1");
        if (this.serverProject) {
            p.put(SERVER_PROJECT_PREF, "true");
        } else {
            p.put(SERVER_PROJECT_PREF, "false");
        }
        InputStream in = null;
        try {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                p.store(out, null);
                in = new ByteArrayInputStream(out.toByteArray());
                if (file.exists()) {
                    file.setContents(in, true, true, monitor);
                } else {
                    file.create(in, true, monitor);
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, "", (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        in.close();
    }

    public IRuntime getRuntimeTarget() {
        return null;
    }

    public boolean isServerProject() {
        this.loadPreferences();
        return this.serverProject;
    }

    public void setServerProject(boolean b, IProgressMonitor monitor) throws CoreException {
        this.loadPreferences();
        this.serverProject = b;
        this.savePreferences(monitor);
    }

    public String toString() {
        return "ProjectProperties[" + this.project + "]";
    }
}

