/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.ecore2ecore.presentation;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.InitializeCopyCommand;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.emf.mapping.command.InitializeCopyOverrideCommand;
import org.eclipse.emf.mapping.domain.AdapterFactoryMappingDomain;
import org.eclipse.emf.mapping.domain.MappingDomain;
import org.eclipse.emf.mapping.domain.PluginAdapterFactoryMappingDomain;
import org.eclipse.emf.mapping.ecore2ecore.Ecore2EcoreFactory;
import org.eclipse.emf.mapping.ecore2ecore.presentation.Ecore2EcoreEditorPlugin;
import org.eclipse.emf.mapping.ecore2ecore.provider.Ecore2EcoreItemProviderAdapterFactory;
import org.eclipse.emf.mapping.presentation.MappingEditor;
import org.eclipse.emf.mapping.provider.MappingItemProviderAdapterFactory;
import org.eclipse.ui.part.FileEditorInput;

public class Ecore2EcoreEditor
extends MappingEditor {
    public Ecore2EcoreEditor() {
        this.topLabel = Ecore2EcoreEditorPlugin.INSTANCE.getString("_UI_InputEcore_label");
        this.bottomLabel = Ecore2EcoreEditorPlugin.INSTANCE.getString("_UI_OutputEcore_label");
    }

    protected AdapterFactoryMappingDomain createMappingDomain() {
        ComposedAdapterFactory mappingAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ResourceItemProviderAdapterFactory(), new MappingItemProviderAdapterFactory(), new Ecore2EcoreItemProviderAdapterFactory()});
        EcoreItemProviderAdapterFactory ecoreAdapterFactory = new EcoreItemProviderAdapterFactory();
        return new Ecore2EcoreMappingDomain((AdapterFactory)mappingAdapterFactory, (AdapterFactory)ecoreAdapterFactory, (AdapterFactory)ecoreAdapterFactory, (CommandStack)new BasicCommandStack(), null);
    }

    protected void handleMissingModelFile() {
        try {
            IFile mappingModelFile = this.modelFile.getFile().getParent().getFile((IPath)new Path(String.valueOf(new Path(this.modelFile.getName()).removeFileExtension().toOSString()) + ".mapper"));
            MappingRoot originalRootObject = (MappingRoot)((Resource)this.mappingDomain.getResourceSet().getResources().iterator().next()).getContents().get(0);
            this.modelFile = new FileEditorInput(mappingModelFile);
            Resource mappingModelResource = null;
            if (mappingModelFile.exists()) {
                this.mappingRoot = (MappingRoot)this.mappingDomain.loadResource(this.getURIFromFile(this.modelFile.getFile())).getContents().get(0);
            } else {
                mappingModelResource = this.mappingDomain.getResourceSet().createResource(URI.createFileURI((String)this.modelFile.getFile().getFullPath().toString()));
                this.mappingRoot = Ecore2EcoreFactory.eINSTANCE.createEcore2EcoreMappingRoot();
                mappingModelResource.getContents().add((Object)this.mappingRoot);
                this.mappingDomain.getResourceSet().getResources().add((Object)mappingModelResource);
                this.mappingRoot.getInputs().add((Object)originalRootObject);
                IFile outputModelFile = this.modelFile.getFile().getParent().getFile((IPath)new Path(String.valueOf(new Path(this.modelFile.getName()).removeFileExtension().toOSString()) + "_mapper_result.classside"));
                Resource outputResource = null;
                if (outputModelFile.exists()) {
                    outputResource = this.mappingDomain.loadResource(this.getURIFromFile(outputModelFile));
                } else {
                    outputResource = this.mappingDomain.getResourceSet().createResource(URI.createURI((String)this.getURIFromFile(outputModelFile)));
                    outputResource.getContents().add((Object)Ecore2EcoreFactory.eINSTANCE.createEcore2EcoreMappingRoot());
                    this.mappingRoot.getOutputs().addAll((Collection)outputResource.getContents());
                }
                this.doSave(null);
            }
            this.mappingRoot.setDomain((MappingDomain)this.mappingDomain);
            this.mappingRoot.setTopToBottom(true);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static class Ecore2EcoreInitializeCopyOverrideCommand
    extends InitializeCopyOverrideCommand {
        public Ecore2EcoreInitializeCopyOverrideCommand(MappingDomain domain, InitializeCopyCommand initializeCommand) {
            super(domain, initializeCommand);
        }

        public void execute() {
            super.execute();
        }
    }

    public static class Ecore2EcoreMappingDomain
    extends PluginAdapterFactoryMappingDomain {
        public Ecore2EcoreMappingDomain(AdapterFactory mappingDomainAdapterFactory, AdapterFactory topDomainAdapterFactory, AdapterFactory bottomDomainAdapterFactory, CommandStack commandStack, String mappingDomainKey) {
            super(mappingDomainAdapterFactory, topDomainAdapterFactory, bottomDomainAdapterFactory, commandStack, mappingDomainKey);
            this.setMappingEnablementFlags(65535);
        }

        protected Command createInitializeCopyOverrideCommand(InitializeCopyCommand initializeCopyCommand) {
            if (!this.isSameEditingDomainAdapterFactory) {
                return new Ecore2EcoreInitializeCopyOverrideCommand((MappingDomain)this, initializeCopyCommand);
            }
            return null;
        }
    }
}

