/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import org.eclipse.draw2d.geometry.Point;

public class PrecisionPoint
extends Point {
    public double preciseX;
    public double preciseY;

    public PrecisionPoint() {
    }

    public PrecisionPoint(Point copy) {
        if (copy instanceof PrecisionPoint) {
            PrecisionPoint precPt = (PrecisionPoint)copy;
            this.preciseX = precPt.preciseX;
            this.preciseY = precPt.preciseY;
            this.updateInts();
        } else {
            this.x = copy.x;
            this.preciseX = this.x;
            this.y = copy.y;
            this.preciseY = this.y;
        }
    }

    public PrecisionPoint(int x, int y) {
        super(x, y);
        this.preciseX = x;
        this.preciseY = y;
    }

    public PrecisionPoint(double x, double y) {
        super(x, y);
        this.preciseX = x;
        this.preciseY = y;
    }

    public Point getCopy() {
        return new PrecisionPoint(this.preciseX, this.preciseY);
    }

    public void performScale(double factor) {
        this.preciseX *= factor;
        this.preciseY *= factor;
        this.x = (int)Math.floor(this.preciseX + 1.0E-9);
        this.y = (int)Math.floor(this.preciseY + 1.0E-9);
    }

    public void performTranslate(int dx, int dy) {
        this.preciseX += (double)dx;
        this.preciseY += (double)dy;
        this.x = (int)Math.floor(this.preciseX + 1.0E-9);
        this.y = (int)Math.floor(this.preciseY + 1.0E-9);
    }

    public Point setLocation(Point pt) {
        if (pt instanceof PrecisionPoint) {
            this.preciseX = ((PrecisionPoint)pt).preciseX;
            this.preciseY = ((PrecisionPoint)pt).preciseY;
        } else {
            this.preciseX = pt.x;
            this.preciseY = pt.y;
        }
        this.x = (int)Math.floor(this.preciseX + 1.0E-9);
        this.y = (int)Math.floor(this.preciseY + 1.0E-9);
        return this;
    }

    public final void updateInts() {
        this.x = (int)Math.floor(this.preciseX + 1.0E-9);
        this.y = (int)Math.floor(this.preciseY + 1.0E-9);
    }
}

