/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test;

import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.context.ScenarioContext;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestExtension;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestRegistry;
import org.eclipse.wst.command.internal.env.core.ICommandFactory;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.selection.BooleanSelection;
import org.eclipse.wst.command.internal.env.core.selection.SelectionList;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceTester;
import org.eclipse.wst.ws.internal.wsrt.TestInfo;

public class ClientTestDelegateCommand
extends AbstractDataModelOperation {
    private WebServiceTestRegistry testRegistry = WebServiceTestRegistry.getInstance();
    private SelectionList testFacilities;
    private String jspFolder;
    private BooleanSelection[] methods;
    private String sampleServerTypeID;
    private IServer sampleExistingServer;
    private String proxyBean;
    private boolean runTestClient;
    private String sampleProject;
    private String sampleP;
    private String clientProject;
    private String clientP;
    private String clientC;
    private boolean clientNeedEAR;
    private String clientEarProjectName;
    private String clientEarComponentName;
    private TypeRuntimeServer serverIds;
    private String serviceProject;
    private String serviceP;
    private String wsdlServiceURL;
    private boolean isTestWidget = false;
    private String setEndpointMethod;
    private List endpoints;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        TestInfo testInfo;
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        String clientTestID = this.testFacilities.getSelection();
        WebServiceTestExtension wscte = (WebServiceTestExtension)this.testRegistry.getWebServiceExtensionsByName(clientTestID);
        IWebServiceTester iwst = (IWebServiceTester)wscte.getWebServiceExecutableExtension();
        status = this.commandFactoryExecution(iwst.generate(testInfo = this.getTestInfo()), env, monitor);
        if (status.getSeverity() == 4) {
            return status;
        }
        testInfo.setRunTestClient(this.runTestClient);
        status = this.commandFactoryExecution(iwst.launch(testInfo), env, monitor);
        if (status.getSeverity() == 4) {
            return status;
        }
        return status;
    }

    private IStatus commandFactoryExecution(ICommandFactory commandFactory, IEnvironment env, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        while (commandFactory.hasNext()) {
            AbstractDataModelOperation operation = commandFactory.getNextCommand();
            operation.setEnvironment(env);
            try {
                status = operation.execute(monitor, null);
            }
            catch (Exception exc) {
                status = StatusUtils.errorStatus((Throwable)exc);
            }
            if (status.getSeverity() != 4) continue;
            IStatusHandler sHandler = env.getStatusHandler();
            sHandler.reportError(status);
            return status;
        }
        return status;
    }

    private TestInfo getTestInfo() {
        int index;
        IServer serviceExistingServer = null;
        String serviceServerTypeID = null;
        if (this.serverIds != null && this.serverIds.getServerInstanceId() != null) {
            serviceExistingServer = ServerCore.findServer((String)this.serverIds.getServerInstanceId());
        }
        if (serviceExistingServer != null) {
            serviceServerTypeID = serviceExistingServer.getServerType().getId();
        }
        if (this.clientProject != null && (index = this.clientProject.indexOf("/")) != -1) {
            this.clientP = this.clientProject.substring(0, index);
            this.clientC = this.clientProject.substring(index + 1);
        }
        if (this.sampleProject != null && (index = this.sampleProject.indexOf("/")) != -1) {
            this.sampleP = this.sampleProject.substring(0, index);
        }
        TestInfo testInfo = new TestInfo();
        testInfo.setClientExistingServer(this.sampleExistingServer);
        testInfo.setClientServerTypeID(this.sampleServerTypeID);
        testInfo.setJspFolder(this.jspFolder);
        testInfo.setExternalBrowser(false);
        testInfo.setEndpoint(this.endpoints);
        testInfo.setGenerationProject(this.sampleP);
        testInfo.setProxyBean(this.proxyBean);
        testInfo.setSetEndpointMethod(this.setEndpointMethod);
        testInfo.setClientProject(this.clientP);
        testInfo.setClientModule(this.clientC);
        testInfo.setClientNeedEAR(this.clientNeedEAR);
        testInfo.setClientEARProject(this.clientEarProjectName);
        testInfo.setClientEARModule(this.clientEarComponentName);
        testInfo.setMethods(this.methods);
        if (serviceServerTypeID == null) {
            serviceServerTypeID = this.sampleServerTypeID;
            serviceExistingServer = this.sampleExistingServer;
        }
        testInfo.setServiceServerTypeID(serviceServerTypeID);
        testInfo.setServiceExistingServer(serviceExistingServer);
        testInfo.setServiceProject(this.getWSDLProject());
        testInfo.setWsdlServiceURL(this.wsdlServiceURL);
        return testInfo;
    }

    public void setTestFacility(SelectionList selection) {
        this.testFacilities = selection;
    }

    public void setFolder(String folder) {
    }

    public void setJspFolder(String jspFolder) {
        this.jspFolder = jspFolder;
    }

    public void setMethods(BooleanSelection[] methods) {
        this.methods = methods;
    }

    public void setRunTestClient(boolean runTestClient) {
        this.runTestClient = runTestClient;
    }

    public void setProxyBean(String proxyBean) {
        this.proxyBean = proxyBean;
    }

    public void setSampleProject(String sampleProject) {
        this.sampleProject = sampleProject;
    }

    public void setClientProject(String clientProject) {
        this.clientProject = clientProject;
    }

    public void setScenarioContext(ScenarioContext scenarioContext) {
    }

    public void setClientTestRegistry(WebServiceTestRegistry testRegistry) {
        this.testRegistry = testRegistry;
    }

    public void setSampleServerTypeID(String sampleServerTypeID) {
        this.sampleServerTypeID = sampleServerTypeID;
    }

    public void setSampleExistingServer(IServer sampleExistingServer) {
        this.sampleExistingServer = sampleExistingServer;
    }

    public void setClientTypeRuntimeServer(TypeRuntimeServer ids) {
    }

    public void setServiceTypeRuntimeServer(TypeRuntimeServer ids) {
        this.serverIds = ids;
    }

    public String getSampleServerTypeID() {
        return this.sampleServerTypeID;
    }

    public IServer getSampleExistingServer() {
        return this.sampleExistingServer;
    }

    public void setClientServer(String clientServer) {
    }

    public void setServerProject(String serviceProject) {
        this.serviceProject = serviceProject;
    }

    public String getWSDLProject() {
        int index;
        if (this.serviceProject != null && (index = this.serviceProject.indexOf("/")) != -1) {
            this.serviceP = this.serviceProject.substring(0, index);
            return this.serviceP;
        }
        return this.clientP;
    }

    public void setWsdlURI(String wsdlServiceURL) {
        this.wsdlServiceURL = wsdlServiceURL;
    }

    public void setGenerateProxy(boolean generateProxy) {
    }

    public boolean getIsTestWidget() {
        return this.isTestWidget;
    }

    public void setClientEarProjectName(String clientEarProjectName) {
        this.clientEarProjectName = clientEarProjectName;
    }

    public void setClientEarComponentName(String clientEarComponentName) {
        this.clientEarComponentName = clientEarComponentName;
    }

    public void setSetEndpointMethod(String setEndpointMethod) {
        this.setEndpointMethod = setEndpointMethod;
    }

    public void setEndpoint(String endpoint) {
        if (endpoint != null && endpoint.length() > 0) {
            Vector<String> v = new Vector<String>();
            v.add(endpoint);
            this.setEndpoints(v);
        }
    }

    public void setEndpoints(List endpoints) {
        this.endpoints = endpoints;
    }

    public boolean getClientNeedEAR() {
        return this.clientNeedEAR;
    }

    public void setClientNeedEAR(boolean clientNeedEAR) {
        this.clientNeedEAR = clientNeedEAR;
    }
}

