/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout.table;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.FlowBox;
import org.eclipse.jst.pagedesigner.css2.layout.LineBox;
import org.eclipse.jst.pagedesigner.css2.layout.table.CSSTRLayout;
import org.eclipse.jst.pagedesigner.css2.layout.table.CSSTableLayout2;
import org.eclipse.jst.pagedesigner.css2.layout.table.CachedTableCellLayout;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableCellInfo;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableRowInfo;

public class CSSTableCellLayout
extends CachedTableCellLayout {
    private CSSTableLayout2 _tableLayout;
    private TableRowInfo _rowinfo;
    private TableCellInfo _cellinfo;

    public CSSTableCellLayout(CSSFigure cssfigure) {
        super(cssfigure);
    }

    public void invalidate() {
        super.invalidate();
        this._tableLayout = null;
        this._rowinfo = null;
        this._cellinfo = null;
    }

    protected void endBlock() {
        if (this.isTable()) {
            this.verticalLayoutLines();
            this.layoutLines();
        } else {
            super.endBlock();
        }
    }

    protected void verticalLayoutLines() {
        List lines = this._blockBox.getFragments();
        String verticalStyle = this.getVerticalAlign();
        int linesHeight = 0;
        if (lines != null && !lines.isEmpty()) {
            FlowBox bottomBox = (FlowBox)lines.get(lines.size() - 1);
            FlowBox topBox = (FlowBox)lines.get(0);
            linesHeight = bottomBox._y + bottomBox.getHeight() - topBox._y;
        }
        int movement = 0;
        movement = "bottom".equals(verticalStyle) ? this._blockBox.getHeight() - linesHeight - this._blockBox.getBorderPaddingHeight() / 2 : ("top".equals(verticalStyle) ? 0 : (this._blockBox.getHeight() - linesHeight - this._blockBox.getBorderPaddingHeight()) / 2);
        if (lines != null) {
            int i = 0;
            int n = lines.size();
            while (i < n) {
                if (lines.get(i) instanceof LineBox) {
                    LineBox lineBox = (LineBox)lines.get(i);
                    int LineMovement = Math.max(lineBox._marginInsets.getHeight(), movement);
                    lineBox._y = lineBox._y + LineMovement - lineBox._marginInsets.getHeight();
                }
                ++i;
            }
        }
    }

    private String getVerticalAlign() {
        ICSSStyle style = this.getCSSStyle();
        if (style != null) {
            return style.getStyleProperty("vertical-align").toString();
        }
        return "middle";
    }

    public Rectangle getCellRect() {
        int vspacing;
        int hspacing;
        int columnIndex = this._cellinfo.getColumnIndex();
        int rowIndex = this._cellinfo.getRowIndex();
        int[] columnWidths = this._tableLayout.getColumnWidths();
        int x = hspacing = this._tableLayout.getHSpacing();
        int col = 0;
        while (col < columnIndex) {
            x += columnWidths[col];
            x += hspacing;
            ++col;
        }
        int[] rowHeights = this._tableLayout.getRowHeights();
        int y = vspacing = this._tableLayout.getVSpacing();
        int row = 0;
        while (row < rowIndex) {
            y += rowHeights[row];
            y += vspacing;
            ++row;
        }
        if (this._tableLayout.getCaptionInfo() != null && "top".equalsIgnoreCase(this._tableLayout.getCaptionInfo().getAlign())) {
            y += this._tableLayout.getCaptionSize().height;
        }
        int width = this._tableLayout.getCellWidth(this._cellinfo, columnWidths);
        int height = this._tableLayout.getCellHeight(this._cellinfo, rowHeights);
        Rectangle rect = new Rectangle(x, y, width, height);
        return rect;
    }

    public CSSTableLayout2 getTableLayoutContext() {
        LayoutManager parentLayout;
        IFigure parent = this.getCSSFigure().getParent();
        if (parent != null && (parentLayout = parent.getLayoutManager()) instanceof CSSTRLayout) {
            return ((CSSTRLayout)parentLayout).getTableLayoutContext();
        }
        return null;
    }

    public boolean initializeTableInfo() {
        this._rowinfo = null;
        this._cellinfo = null;
        this._tableLayout = this.getTableLayoutContext();
        if (this._tableLayout != null) {
            this._rowinfo = this._tableLayout.getRowInfo((CSSFigure)this.getCSSFigure().getParent());
            if (this._rowinfo != null) {
                this._cellinfo = this._rowinfo.getCellInfo(this.getCSSFigure());
                if (this._cellinfo != null) {
                    return true;
                }
            }
        }
        return false;
    }

    public CSSTableLayout2 getTableLayout() {
        return this._tableLayout;
    }

    public TableCellInfo getTableCellInfo() {
        return this._cellinfo;
    }
}

