/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.ICSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableCaptionInfo;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableCellInfo;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableInfoContext;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableItemInfo;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableRowGroupInfo;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableRowInfo;

public class TableInfo
extends TableItemInfo {
    List _tableHeaderGroups = new ArrayList();
    List _tableTRandTRGs = new ArrayList();
    List _tableFooterGroups = new ArrayList();
    TableCaptionInfo _caption;
    int _columnCount;
    int _rowCount;
    List _cells = null;
    private List _rows = null;
    int _tableWidth;
    int _availableWidth;
    int _tableHeight;
    private int[] _widthPercentage;
    private int[] _heightPercentage;
    boolean[] _widthSpecified;

    public TableInfo(ICSSFigure figure) {
        super(figure);
    }

    public List getTableHeaderGroups() {
        return this._tableHeaderGroups;
    }

    public List getTRandTRGs() {
        return this._tableTRandTRGs;
    }

    public List getTableFooterGroups() {
        return this._tableFooterGroups;
    }

    public int getColumnCount() {
        return this._columnCount;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    protected void constructTable() {
        TableRowGroupInfo groupInfo;
        List child = this.getFigure().getChildren();
        int i = 0;
        int size = child.size();
        while (i < size) {
            ICSSStyle style;
            IFigure childfigure = (IFigure)child.get(i);
            if (childfigure instanceof ICSSFigure && (style = ((ICSSFigure)childfigure).getCSSStyle()) != null) {
                TableRowGroupInfo groupInfo2;
                String display = style.getDisplay();
                if ("table-caption".equalsIgnoreCase(display)) {
                    this._caption = new TableCaptionInfo((ICSSFigure)childfigure);
                } else if ("table-row".equalsIgnoreCase(display)) {
                    TableRowInfo rowInfo = new TableRowInfo((ICSSFigure)childfigure);
                    this._tableTRandTRGs.add(rowInfo);
                } else if ("table-row-group".equalsIgnoreCase(display)) {
                    groupInfo2 = new TableRowGroupInfo((ICSSFigure)childfigure);
                    this._tableTRandTRGs.add(groupInfo2);
                } else if ("table-header-group".equalsIgnoreCase(display)) {
                    groupInfo2 = new TableRowGroupInfo((ICSSFigure)childfigure);
                    this._tableHeaderGroups.add(groupInfo2);
                } else if ("table-footer-group".equalsIgnoreCase(display)) {
                    groupInfo2 = new TableRowGroupInfo((ICSSFigure)childfigure);
                    this._tableFooterGroups.add(groupInfo2);
                }
            }
            ++i;
        }
        TableInfoContext context = new TableInfoContext();
        int i2 = 0;
        int size2 = this._tableHeaderGroups.size();
        while (i2 < size2) {
            groupInfo = (TableRowGroupInfo)this._tableHeaderGroups.get(i2);
            groupInfo.calculateRowGroup(context);
            ++i2;
        }
        i2 = 0;
        size2 = this._tableTRandTRGs.size();
        while (i2 < size2) {
            Object obj = this._tableTRandTRGs.get(i2);
            if (obj instanceof TableRowGroupInfo) {
                TableRowGroupInfo groupInfo3 = (TableRowGroupInfo)obj;
                groupInfo3.calculateRowGroup(context);
            } else {
                TableRowInfo rowInfo = (TableRowInfo)obj;
                rowInfo.calculateRow(context);
            }
            ++i2;
        }
        i2 = 0;
        size2 = this._tableFooterGroups.size();
        while (i2 < size2) {
            groupInfo = (TableRowGroupInfo)this._tableFooterGroups.get(i2);
            groupInfo.calculateRowGroup(context);
            ++i2;
        }
        context.finishTable();
        this._columnCount = context.getColumnCount();
        this._rowCount = context.getRowCount();
        this._widthPercentage = new int[this._columnCount];
        this._heightPercentage = new int[this._rowCount];
        this._widthSpecified = new boolean[this._columnCount];
        i2 = 0;
        while (i2 < this._columnCount) {
            this._widthSpecified[i2] = false;
            ++i2;
        }
    }

    public void setWidthPercentage(int columnIndex, int percentageValue) {
        if (percentageValue > this._widthPercentage[columnIndex]) {
            this._widthPercentage[columnIndex] = percentageValue;
        }
    }

    public void setHeightPercentage(int rowIndex, int percentageValue) {
        if (percentageValue > this._heightPercentage[rowIndex]) {
            this._heightPercentage[rowIndex] = percentageValue;
        }
    }

    public int[] getWidthPercentages() {
        return this._widthPercentage;
    }

    public int[] getHeightPercentages() {
        return this._heightPercentage;
    }

    public List getRows() {
        if (this._rows == null) {
            TableRowGroupInfo groupInfo;
            this._rows = new ArrayList();
            int i = 0;
            int size = this._tableHeaderGroups.size();
            while (i < size) {
                groupInfo = (TableRowGroupInfo)this._tableHeaderGroups.get(i);
                this._rows.addAll(groupInfo.getRowList());
                ++i;
            }
            i = 0;
            size = this._tableTRandTRGs.size();
            while (i < size) {
                Object obj = this._tableTRandTRGs.get(i);
                if (obj instanceof TableRowGroupInfo) {
                    TableRowGroupInfo groupInfo2 = (TableRowGroupInfo)obj;
                    this._rows.addAll(groupInfo2.getRowList());
                } else {
                    TableRowInfo rowInfo = (TableRowInfo)obj;
                    this._rows.add(rowInfo);
                }
                ++i;
            }
            i = 0;
            size = this._tableFooterGroups.size();
            while (i < size) {
                groupInfo = (TableRowGroupInfo)this._tableFooterGroups.get(i);
                this._rows.addAll(groupInfo.getRowList());
                ++i;
            }
        }
        return this._rows;
    }

    public List getCells() {
        if (this._cells == null) {
            TableRowGroupInfo groupInfo;
            this._cells = new ArrayList();
            int i = 0;
            int size = this._tableHeaderGroups.size();
            while (i < size) {
                groupInfo = (TableRowGroupInfo)this._tableHeaderGroups.get(i);
                groupInfo.getCells(this._cells);
                ++i;
            }
            i = 0;
            size = this._tableTRandTRGs.size();
            while (i < size) {
                Object obj = this._tableTRandTRGs.get(i);
                if (obj instanceof TableRowGroupInfo) {
                    TableRowGroupInfo groupInfo2 = (TableRowGroupInfo)obj;
                    groupInfo2.getCells(this._cells);
                } else {
                    TableRowInfo rowInfo = (TableRowInfo)obj;
                    rowInfo.getCells(this._cells);
                }
                ++i;
            }
            i = 0;
            size = this._tableFooterGroups.size();
            while (i < size) {
                groupInfo = (TableRowGroupInfo)this._tableFooterGroups.get(i);
                groupInfo.getCells(this._cells);
                ++i;
            }
        }
        return this._cells;
    }

    public void calculateWidth(int contentWidth, int availableWidth) {
        this._tableWidth = contentWidth;
        this._availableWidth = availableWidth;
        List cells = this.getCells();
        int i = 0;
        int size = cells.size();
        while (i < size) {
            TableCellInfo cellinfo = (TableCellInfo)cells.get(i);
            cellinfo.calculateWidth(this, this._tableWidth);
            ++i;
        }
    }

    public void calculateHeight(int contentHeight) {
        this._tableHeight = contentHeight;
        List rows = this.getRows();
        int i = 0;
        int size = rows.size();
        while (i < size) {
            TableRowInfo rowinfo = (TableRowInfo)rows.get(i);
            rowinfo.calculateHeight(this, this._tableHeight);
            ++i;
        }
        List cells = this.getCells();
        int i2 = 0;
        int size2 = cells.size();
        while (i2 < size2) {
            TableCellInfo cellinfo = (TableCellInfo)cells.get(i2);
            cellinfo.calculateHeight(this, this._tableHeight);
            ++i2;
        }
    }

    public int getTableWidth() {
        return this._tableWidth;
    }

    public TableRowGroupInfo findGroupInfo(CSSFigure figure) {
        TableRowGroupInfo groupInfo;
        int i = 0;
        int size = this._tableHeaderGroups.size();
        while (i < size) {
            groupInfo = (TableRowGroupInfo)this._tableHeaderGroups.get(i);
            if (figure == groupInfo.getFigure()) {
                return groupInfo;
            }
            ++i;
        }
        i = 0;
        size = this._tableTRandTRGs.size();
        while (i < size) {
            TableRowGroupInfo groupInfo2;
            Object obj = this._tableTRandTRGs.get(i);
            if (obj instanceof TableRowGroupInfo && figure == (groupInfo2 = (TableRowGroupInfo)obj).getFigure()) {
                return groupInfo2;
            }
            ++i;
        }
        i = 0;
        size = this._tableFooterGroups.size();
        while (i < size) {
            groupInfo = (TableRowGroupInfo)this._tableFooterGroups.get(i);
            if (figure == groupInfo.getFigure()) {
                return groupInfo;
            }
            ++i;
        }
        return null;
    }

    public TableRowInfo findRowInfo(CSSFigure figure) {
        TableRowInfo rowinfo;
        TableRowGroupInfo groupInfo;
        int i = 0;
        int size = this._tableHeaderGroups.size();
        while (i < size) {
            groupInfo = (TableRowGroupInfo)this._tableHeaderGroups.get(i);
            rowinfo = groupInfo.findRowInfo(figure);
            if (rowinfo != null) {
                return rowinfo;
            }
            ++i;
        }
        i = 0;
        size = this._tableTRandTRGs.size();
        while (i < size) {
            TableRowInfo info;
            Object obj = this._tableTRandTRGs.get(i);
            if (obj instanceof TableRowGroupInfo) {
                TableRowGroupInfo groupInfo2 = (TableRowGroupInfo)obj;
                TableRowInfo rowinfo2 = groupInfo2.findRowInfo(figure);
                if (rowinfo2 != null) {
                    return rowinfo2;
                }
            } else if (obj instanceof TableRowInfo && figure == (info = (TableRowInfo)obj).getFigure()) {
                return info;
            }
            ++i;
        }
        i = 0;
        size = this._tableFooterGroups.size();
        while (i < size) {
            groupInfo = (TableRowGroupInfo)this._tableFooterGroups.get(i);
            rowinfo = groupInfo.findRowInfo(figure);
            if (rowinfo != null) {
                return rowinfo;
            }
            ++i;
        }
        return null;
    }

    public boolean hasWidthPercentage() {
        int i = 0;
        while (i < this._widthPercentage.length) {
            if (this._widthPercentage[i] > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

