/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dom;

import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.EditPart;
import org.eclipse.jst.pagedesigner.commands.range.WorkNode;
import org.eclipse.jst.pagedesigner.dom.CaretMoveIterator;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.DOMRefPosition;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.EditValidateUtil;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.parts.TextEditPart;
import org.eclipse.jst.pagedesigner.utils.HTMLUtil;
import org.eclipse.jst.pagedesigner.validation.caret.ActionData;
import org.eclipse.jst.pagedesigner.validation.caret.IMovementMediator;
import org.eclipse.jst.pagedesigner.validation.caret.InlineEditingNavigationMediator;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRefPosition;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class EditHelper {
    public static final boolean INNER_DEBUG = false;
    public static final int OUT_OF_LEFT = 1;
    public static final int LEFT_NAME = 2;
    public static final int IN_MIDDLE = 3;
    public static final int RIGHT_NAME = 4;
    public static final int OUT_OF_RIGHT = 5;
    public static final EditHelper _instance = new EditHelper();

    private EditHelper() {
    }

    /*
     * Unable to fully structure code
     */
    public int getTextNextOffset(IDOMPosition position, boolean forward, boolean forEmpty) {
        block2: {
            EditValidateUtil.validPosition(position);
            Assert.isTrue((boolean)(EditModelQuery.isTransparentText(position.getContainerNode()) == false));
            text = (Text)position.getContainerNode();
            offset = position.getOffset();
            data = text.getNodeValue();
            if (!forward) ** GOTO lbl14
            while (offset < data.length() && HTMLUtil.isHTMLWhitespace(data.charAt(offset))) {
                ++offset;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                --offset;
lbl14:
                // 2 sources

                ** while (offset > 0 && HTMLUtil.isHTMLWhitespace((char)data.charAt((int)(offset - 1))))
            }
        }
        return offset;
    }

    public static EditHelper getInstance() {
        return _instance;
    }

    public static DesignPosition moveToNextEditPosition(int action, DesignPosition currentPosition, boolean forward) {
        IDOMPosition position = DOMPositionHelper.toDOMPosition(currentPosition);
        if ((position = EditHelper.moveToNextEditPosition(position, forward, new InlineEditingNavigationMediator(new ActionData(action, null)))) == null) {
            return currentPosition;
        }
        EditValidateUtil.validPosition(position);
        return DOMPositionHelper.toDesignPosition(position);
    }

    public static IDOMPosition moveToNextEditPosition(IDOMPosition currentPosition, boolean forward, IMovementMediator validator) {
        IDOMPosition result = null;
        CaretMoveIterator moveIterator = new CaretMoveIterator(null, validator, currentPosition, forward);
        result = moveIterator.moveToNextEditPosition(currentPosition, forward, validator);
        if (result == null) {
            result = currentPosition;
        }
        return result;
    }

    public static Node deleteNode(Node node) {
        if (node == null || node.getNodeName() == null) {
            return null;
        }
        String name = node.getLocalName();
        if (name != null && (name.equalsIgnoreCase("body") || name.equalsIgnoreCase("head") || name.equalsIgnoreCase("html"))) {
            return null;
        }
        Node parent = node.getParentNode();
        name = parent.getNodeName();
        if (parent != null && name != null && parent.getNodeName().equalsIgnoreCase("head")) {
            return null;
        }
        return parent.removeChild(node);
    }

    public static DOMRange normal(DOMRange range) {
        EditValidateUtil.validRange(range);
        IDOMPosition p1 = range.getStartPosition();
        IDOMPosition p2 = range.getEndPosition();
        if (EditModelQuery.getIndexedRegionLocation(p1) > EditModelQuery.getIndexedRegionLocation(p2)) {
            return new DOMRange(p2, p1);
        }
        return range;
    }

    public static IDOMPosition moveInto(Node node, IMovementMediator validator, boolean forward) {
        CaretMoveIterator moveIterator = new CaretMoveIterator(null, validator, new DOMRefPosition(node, !forward), forward);
        return moveIterator.moveIn(node);
    }

    public static IDOMPosition ensureDOMPosition(IDOMPosition position) {
        if (position instanceof DOMRefPosition) {
            return new DOMPosition(position.getContainerNode(), position.getOffset());
        }
        return position;
    }

    public void processText(Text currentNode, int pos1, int pos2, Node top, Stack workNode) {
        Assert.isTrue((pos1 <= pos2 ? 1 : 0) != 0);
        if (pos1 == pos2) {
            return;
        }
        int location1 = this.getLocation(currentNode, pos1, false);
        int location2 = this.getLocation(currentNode, pos2, false);
        if (location1 <= 3 && location2 >= 3) {
            workNode.push(new WorkNode(currentNode, pos1, pos2));
        }
    }

    public void collectNodes(Node currentNode, int pos1, int pos2, Node top, Stack result) {
        Assert.isTrue((pos1 <= pos2 ? 1 : 0) != 0);
        if (pos1 == pos2) {
            return;
        }
        if (EditModelQuery.isText(currentNode)) {
            this.processText((Text)currentNode, pos1, pos2, top, result);
        } else {
            int location1 = this.getLocation(currentNode, pos1, false);
            int location2 = this.getLocation(currentNode, pos2, false);
            if (location1 < 3 && location2 > 3) {
                result.push(new WorkNode(currentNode, pos1, pos2));
            } else if (location1 <= 3 && location2 >= 3) {
                if (currentNode.hasChildNodes()) {
                    Node child = currentNode.getFirstChild();
                    Stack myResult = new Stack();
                    while (child != null) {
                        this.collectNodes(child, pos1, pos2, top, myResult);
                        child = child.getNextSibling();
                    }
                    if (location1 < 3 && location2 >= 3 || location1 <= 3 && location2 > 3) {
                        WorkNode workNode = new WorkNode(currentNode, pos1, pos2);
                        while (myResult.size() > 0) {
                            WorkNode w = (WorkNode)myResult.remove(0);
                            if (w.getNode().getParentNode() == workNode.getNode()) {
                                w.setParent(workNode);
                            }
                            result.push(w);
                        }
                        result.push(workNode);
                    }
                } else if (location1 != 3 || location2 != 3) {
                    result.push(new WorkNode(currentNode, pos1, pos2));
                }
            }
        }
    }

    public int getLocation(Node currentNode, int pos, boolean isOffset) {
        if (EditModelQuery.getInstance().isSingleRegionNode(currentNode)) {
            int left = EditModelQuery.getNodeStartIndex(currentNode);
            int right = EditModelQuery.getNodeEndIndex(currentNode);
            if (isOffset) {
                pos += left;
            }
            if (pos <= left) {
                return 1;
            }
            if (left < pos && pos < right) {
                return 3;
            }
            return 5;
        }
        int left = EditModelQuery.getNodeStartIndex(currentNode);
        int left1 = EditModelQuery.getNodeStartNameEndIndex(currentNode);
        int right = EditModelQuery.getNodeEndNameStartIndex(currentNode);
        int right1 = EditModelQuery.getNodeEndIndex(currentNode);
        if (isOffset) {
            pos += left;
        }
        if (pos <= left) {
            return 1;
        }
        if (left < pos && pos < left1) {
            return 2;
        }
        if (left1 <= pos && pos <= right) {
            return 3;
        }
        if (right < pos && pos < right1) {
            return 4;
        }
        return 5;
    }

    public EditPart getEditPart(DesignPosition position, boolean forward) {
        if (position instanceof DesignRefPosition) {
            return ((DesignRefPosition)position).getRefPart();
        }
        EditPart container = position.getContainerPart();
        if (container instanceof TextEditPart) {
            return container;
        }
        if (container != null) {
            List children = container.getChildren();
            int i = 0;
            int n = children.size();
            while (i < n) {
                if (i == position.getOffset()) {
                    int index;
                    int n2 = index = forward ? i - 1 : i + 1;
                    if (index < 0) {
                        index = 0;
                    }
                    if (index >= children.size()) {
                        index = children.size() - 1;
                    }
                    return (EditPart)children.get(index);
                }
                ++i;
            }
        }
        return null;
    }

    public static IDOMPosition splitNode(IDOMPosition position) {
        if (EditValidateUtil.validPosition(position)) {
            Node container = null;
            if (position.getOffset() > 0) {
                if (position.isText()) {
                    container = position.getContainerNode();
                    if (position.getOffset() < ((Text)container).getLength()) {
                        position = DOMPositionHelper.splitText(position);
                    }
                } else if (position.getNextSiblingNode() != null) {
                    container = position.getContainerNode();
                    Node parent = container.getParentNode();
                    Document document = EditModelQuery.getDocumentNode(container);
                    Element newContainer = document.createElement(container.getNodeName());
                    Node node = position.getPreviousSiblingNode();
                    Node refNode = null;
                    while (node != null) {
                        Node prev = node.getPreviousSibling();
                        node = node.getParentNode().removeChild(node);
                        newContainer.insertBefore(node, refNode);
                        refNode = node;
                        node = prev;
                    }
                    parent.insertBefore(newContainer, container);
                    if (container.getNodeName().equalsIgnoreCase("p")) {
                        Element pNode = (Element)container;
                        String align = pNode.getAttribute("align");
                        if (align != null && !"".equalsIgnoreCase(align)) {
                            newContainer.setAttribute("align", align);
                        }
                        NodeList nodeList = pNode.getChildNodes();
                        int i = 0;
                        int size = nodeList.getLength();
                        while (i < size) {
                            Node tempNode = nodeList.item(i);
                            parent.insertBefore(tempNode, container);
                            ++i;
                        }
                    }
                    return new DOMRefPosition(newContainer, true);
                }
            }
        }
        return position;
    }

    public static int getLocation(IDOMPosition position) {
        if (position.getOffset() == 0) {
            return -1;
        }
        if (position.isText()) {
            if (position.getOffset() == ((Text)position.getContainerNode()).getLength()) {
                return 1;
            }
            return 0;
        }
        if (position.getOffset() == position.getContainerNode().getChildNodes().getLength()) {
            return 1;
        }
        return 0;
    }

    public static EditPart getPart(Node node) {
        if (node instanceof INodeNotifier) {
            ((INodeNotifier)node).getAdapterFor(EditPart.class);
        }
        return null;
    }
}

