/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolPaletteEntry;
import org.eclipse.jst.pagedesigner.elementedit.ElementEditFactoryRegistry;
import org.eclipse.jst.pagedesigner.elementedit.IElementEdit;
import org.eclipse.jst.pagedesigner.itemcreation.ItemCreationRequest;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.jst.pagedesigner.validation.caret.DropActionData;
import org.eclipse.jst.pagedesigner.validation.caret.IPositionMediator;
import org.eclipse.jst.pagedesigner.viewer.DefaultDropLocationStrategy;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.IDropLocationStrategy;

public abstract class DropEditPolicy
extends GraphicalEditPolicy {
    protected List _feedbackFigures;

    protected IPositionMediator createDropChildValidator(DropRequest r) {
        return null;
    }

    protected abstract DesignPosition findPosition(DropRequest var1);

    protected abstract IPositionMediator createDefaultDropChildValidator(DropActionData.DropData var1);

    protected final IPositionMediator getDropChildValidator(DropRequest r) {
        IPositionMediator mediator = this.createDropChildValidator(r);
        if (mediator == null) {
            DropActionData.DropData data = this.createDropData(r);
            if (data == null) {
                return null;
            }
            mediator = this.createDefaultDropChildValidator(data);
        }
        return mediator;
    }

    protected DropActionData.DropData createDropData(DropRequest request) {
        if (request instanceof GroupRequest) {
            NodeEditPart nodePart;
            TagIdentifier tagId;
            EditPart part;
            List editParts = ((GroupRequest)request).getEditParts();
            if (editParts.size() > 0 && (part = (EditPart)editParts.get(0)) instanceof NodeEditPart && (tagId = (nodePart = (NodeEditPart)part).getTagIdentifier()) != null) {
                ArrayList<TagIdentifier> tagIds = new ArrayList<TagIdentifier>();
                tagIds.add(tagId);
                return new DropActionData.DropData(tagIds);
            }
        } else if (request instanceof ItemCreationRequest) {
            TagToolPaletteEntry desc = ((ItemCreationRequest)request).getTagToolPaletteEntry();
            TagIdentifier tagId = TagIdentifierFactory.createJSPTagWrapper((String)desc.getURI(), (String)desc.getTagName());
            ArrayList<TagIdentifier> tagIds = new ArrayList<TagIdentifier>();
            tagIds.add(tagId);
            return new DropActionData.DropData(tagIds);
        }
        return null;
    }

    protected final IDropLocationStrategy createDropLocationStrategy(DropRequest r) {
        DropActionData.DropData dropData = this.createDropData(r);
        if (dropData != null && dropData.getTagIdentifiers().size() > 0) {
            IDropLocationStrategy strategy;
            TagIdentifier tagIdentifier = (TagIdentifier)dropData.getTagIdentifiers().get(0);
            IElementEdit elementEdit = ElementEditFactoryRegistry.getInstance().createElementEdit(tagIdentifier);
            if (elementEdit != null && (strategy = elementEdit.getDropRequestorLocationStrategy(tagIdentifier, this.getHost().getViewer())) != null) {
                return strategy;
            }
        }
        return new DefaultDropLocationStrategy(this.getHost().getViewer());
    }

    public void eraseTargetFeedback(Request request) {
        if (this._feedbackFigures != null) {
            for (IFigure figure : this._feedbackFigures) {
                if (figure == null) continue;
                this.removeFeedback(figure);
            }
            this._feedbackFigures.clear();
            this._feedbackFigures = null;
        }
    }

    public void showTargetFeedback(Request request) {
        DesignPosition position;
        if (request instanceof DropRequest && (position = this.findPosition((DropRequest)request)) != null) {
            this.eraseTargetFeedback(request);
            this._feedbackFigures = this.createDropLocationStrategy((DropRequest)request).showTargetFeedback(this.getHost(), position, (DropRequest)request);
        }
    }
}

