/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editpolicies;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.jst.pagedesigner.editpolicies.AbsolutePointLocator;
import org.eclipse.jst.pagedesigner.editpolicies.BasicLabelToolTip;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.jst.pagedesigner.parts.NonVisualComponentEditPart;
import org.eclipse.swt.graphics.Color;
import org.w3c.dom.Element;

public class NonVisualChildGraphicalEditPolicy
extends NonResizableEditPolicy {
    private static final int TOOLTIP_VERTICAL_OFFSET = 25;
    private static final Color HOVER_FEEDBACK_COLOR = ColorConstants.blue;
    protected BasicLabelToolTip _toolTip;
    protected boolean _showLabelFeedback;
    private RectangleFigure _mouseOverBorder;

    public void showTargetFeedback(Request request) {
        if ("selection hover".equals(request.getType())) {
            this.removeToolTipLabel();
            this.removeMouseOverBorder();
            Assert.isTrue((boolean)(request instanceof LocationRequest));
            this._showLabelFeedback = !((NodeEditPart)this.getHost()).isDragActive();
            this.showHoverFeedback((LocationRequest)request);
        } else {
            super.showTargetFeedback(request);
        }
    }

    public void eraseTargetFeedback(Request request) {
        this.removeToolTipLabel();
        this.removeMouseOverBorder();
    }

    protected void showHoverFeedback(LocationRequest request) {
        if (this._showLabelFeedback) {
            this.addMouseOverBorder();
            this._toolTip = new BasicLabelToolTip(this.getTooltipText());
            this.addFeedback((IFigure)this._toolTip);
            AbsolutePointLocator locator = AbsolutePointLocator.getInstance();
            locator.setReferencePoint(request.getLocation(), 0, 25);
            locator.setIntersectFigure(this.getFeedbackLayer());
            locator.relocate((IFigure)this._toolTip);
        }
    }

    protected String getTooltipText() {
        Element element = (Element)((NonVisualComponentEditPart)this.getHost()).getDOMNode();
        StringBuffer text = new StringBuffer(element.getTagName());
        return text.toString();
    }

    protected void addMouseOverBorder() {
        if (this._mouseOverBorder == null) {
            this._mouseOverBorder = new RectangleFigure();
            this._mouseOverBorder.setFill(false);
            this._mouseOverBorder.setOutline(true);
            this._mouseOverBorder.setLineWidth(1);
            this._mouseOverBorder.setForegroundColor(HOVER_FEEDBACK_COLOR);
        }
        this.addFeedback((IFigure)this._mouseOverBorder);
        IFigure hostFigure = this.getHostFigure();
        Rectangle r = hostFigure.getBounds().getCopy().expand(1, 1);
        hostFigure.translateToAbsolute((Translatable)r);
        this._mouseOverBorder.translateToRelative((Translatable)r);
        this._mouseOverBorder.setBounds(r);
    }

    protected void removeMouseOverBorder() {
        if (this._mouseOverBorder != null) {
            this.removeFeedback((IFigure)this._mouseOverBorder);
            this._mouseOverBorder = null;
        }
    }

    protected List createSelectionHandles() {
        return Collections.EMPTY_LIST;
    }

    protected void removeToolTipLabel() {
        if (this._toolTip != null) {
            this.removeFeedback((IFigure)this._toolTip);
            this._toolTip = null;
        }
    }
}

