/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.figurehandler;

import java.util.List;
import org.eclipse.jst.pagedesigner.css2.provider.ICSSWidgetProvider;
import org.eclipse.jst.pagedesigner.css2.widget.ComboWidgetProvider;
import org.eclipse.jst.pagedesigner.css2.widget.ListWidgetProvider;
import org.eclipse.jst.pagedesigner.figurehandler.WidgetFigureHandler;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.w3c.dom.Element;

public class SelectFigureHandler
extends WidgetFigureHandler {
    public String[] getOptionLabels(Element node) {
        List options = DOMUtil.getChildElementsByTagIgnoreCase(node, "option");
        String[] ret = new String[options.size()];
        int i = 0;
        while (i < ret.length) {
            Element option = (Element)options.get(i);
            ret[i] = DOMUtil.getTextElementValue(option);
            ++i;
        }
        return ret;
    }

    public String getSelectedLabels(Element node) {
        List options = DOMUtil.getChildElementsByTagIgnoreCase(node, "option");
        String result = null;
        int i = 0;
        int n = options.size();
        while (i < n) {
            Element option = (Element)options.get(i);
            if (option.hasAttribute("selected")) {
                result = DOMUtil.getTextElementValue(option);
            }
            ++i;
        }
        return result;
    }

    protected boolean isMultiple(Element node) {
        return DOMUtil.getAttributeIgnoreCase(node, "multiple") != null;
    }

    protected ICSSWidgetProvider initializeWidgetProvider(Element node) {
        String[] labels = this.getOptionLabels(node);
        String rows = DOMUtil.getAttributeIgnoreCase(node, "size");
        int rowsInt = 0;
        try {
            if (rows != null) {
                rowsInt = Integer.parseInt(rows);
            }
        }
        catch (Exception exception) {}
        if (this.isMultiple(node) || rowsInt > 1) {
            ListWidgetProvider provider = new ListWidgetProvider(this.getCSSStyle(node));
            provider.setOptions(labels);
            provider.setRows(rowsInt);
            return provider;
        }
        ComboWidgetProvider provider = new ComboWidgetProvider(this.getCSSStyle(node));
        provider.setOptions(labels);
        provider.setSelectedLabel(this.getSelectedLabels(node));
        return provider;
    }
}

