/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.range;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.jst.pagedesigner.parts.DocumentEditPart;
import org.eclipse.jst.pagedesigner.parts.TextEditPart;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.TextPosition;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class RangeUtil {
    public static Node appendAfter(Node child, Node reference) {
        Node next = reference.getNextSibling();
        if (next == null) {
            return reference.getParentNode().appendChild(child);
        }
        return reference.getParentNode().insertBefore(child, next);
    }

    public static Node insertBefore(Node child, Node reference) {
        return reference.getParentNode().insertBefore(child, reference);
    }

    public static Node insertElement(DesignPosition position, Element node) {
        EditPart containerEditPart = position.getContainerPart();
        int offset = position.getOffset();
        if (containerEditPart instanceof TextEditPart) {
            TextEditPart textPart = (TextEditPart)containerEditPart;
            String textData = textPart.getTextData();
            Node textNode = (Node)textPart.getModel();
            if (offset == 0) {
                return RangeUtil.insertBefore(node, textNode);
            }
            if (offset == textData.length()) {
                return RangeUtil.appendAfter(node, textNode);
            }
            String before = textData.substring(0, offset);
            String after = textData.substring(offset);
            textNode.setNodeValue(after);
            Node newnode = RangeUtil.insertBefore(node, textNode);
            Text t = textNode.getOwnerDocument().createTextNode(before);
            RangeUtil.insertBefore(t, newnode);
            return newnode;
        }
        return RangeUtil.insertIntoEditPart(containerEditPart, node, offset);
    }

    private static Node insertIntoEditPart(EditPart containerEditPart, Node node, int offset) {
        Node parent = (Node)containerEditPart.getModel();
        List childParts = containerEditPart.getChildren();
        if (offset >= childParts.size()) {
            return parent.appendChild(node);
        }
        Node child = (Node)((EditPart)childParts.get(offset)).getModel();
        return RangeUtil.insertBefore(node, child);
    }

    public static TextPosition insertText(DesignPosition position, String data) {
        position = RangeUtil.moveIntoText(position);
        int offset = position.getOffset();
        if (position.getContainerPart() instanceof TextEditPart) {
            TextEditPart textPart = (TextEditPart)position.getContainerPart();
            String textData = textPart.getTextData();
            String before = textData.substring(0, offset);
            String after = textData.substring(offset);
            if (data.startsWith(" ") && before.endsWith(" ")) {
                before = String.valueOf(before.substring(0, before.length() - 1)) + "&nbsp;";
            }
            if (after.startsWith(" ") && data.endsWith(" ")) {
                data = String.valueOf(data.substring(0, data.length() - 1)) + '\u00a0';
            }
            String nextData = String.valueOf(before) + data + after;
            IDOMText text = (IDOMText)textPart.getModel();
            text.setData(nextData);
            return new TextPosition(text, offset + data.length());
        }
        EditPart part = position.getContainerPart();
        Node parent = (Node)part.getModel();
        Text text = parent.getOwnerDocument().createTextNode(data);
        RangeUtil.insertIntoEditPart(part, text, offset);
        return new TextPosition((IDOMText)text, offset);
    }

    public static DesignPosition moveIntoText(DesignPosition position) {
        EditPart next;
        EditPart pre;
        EditPart container = position.getContainerPart();
        if (container instanceof TextEditPart) {
            return position;
        }
        if (position.getOffset() > 0 && (pre = (EditPart)container.getChildren().get(position.getOffset() - 1)) instanceof TextEditPart) {
            return new DesignPosition(pre, ((TextEditPart)pre).getTextData().length());
        }
        if (position.getOffset() < container.getChildren().size() && (next = (EditPart)container.getChildren().get(position.getOffset())) instanceof TextEditPart) {
            return new DesignPosition(next, 0);
        }
        return position;
    }

    public static DesignPosition moveOutFromText(DesignPosition position) {
        EditPart container = position.getContainerPart();
        if (container instanceof TextEditPart) {
            int offset = position.getOffset();
            String text = ((TextEditPart)container).getTextData();
            if (offset == 0) {
                return new DesignPosition(container.getParent(), container.getParent().getChildren().indexOf(container));
            }
            if (offset == text.length()) {
                return new DesignPosition(container.getParent(), container.getParent().getChildren().indexOf(container) + 1);
            }
        }
        return position;
    }

    public static void insertDocumentFragment(DesignPosition position, DocumentFragment fragment) {
    }

    public static boolean intersect(DesignRange range, EditPart part) {
        if (range == null || !range.isValid()) {
            return false;
        }
        range = RangeUtil.normalize(range);
        if (part instanceof DocumentEditPart) {
            return true;
        }
        EditPart parent = part.getParent();
        int index = parent.getChildren().indexOf(part);
        DesignPosition left = new DesignPosition(parent, index);
        DesignPosition right = new DesignPosition(parent, index + 1);
        int compare = RangeUtil.compareDesignPosition(left, range.getEndPosition());
        if (compare == 1 || compare == 0 || compare == Integer.MIN_VALUE) {
            return false;
        }
        compare = RangeUtil.compareDesignPosition(right, range.getStartPosition());
        return compare != -1 && compare != 0 && compare != Integer.MIN_VALUE;
    }

    public static DesignRange normalize(DesignRange range) {
        if (range == null || !range.isValid()) {
            return range;
        }
        int result = RangeUtil.compareDesignPosition(range.getStartPosition(), range.getEndPosition());
        if (result == 1) {
            return new DesignRange(range.getEndPosition(), range.getStartPosition());
        }
        return range;
    }

    public static int compareDesignPosition(DesignPosition p1, DesignPosition p2) {
        if (!p1.isValid() || !p2.isValid()) {
            return Integer.MIN_VALUE;
        }
        if (p1.equals(p2)) {
            return 0;
        }
        int offset1 = p1.getOffset();
        int offset2 = p2.getOffset();
        List a1 = RangeUtil.getAncesters(p1.getContainerPart());
        List a2 = RangeUtil.getAncesters(p2.getContainerPart());
        if (a1 == null || a2 == null) {
            return Integer.MIN_VALUE;
        }
        if (a1.get(0) != a2.get(0)) {
            return Integer.MIN_VALUE;
        }
        int i = 1;
        while (true) {
            EditPart p2a;
            EditPart p1a;
            if ((p1a = (EditPart)a1.get(i)) == (p2a = (EditPart)a2.get(i))) {
                if (p1a == null) {
                    return offset1 < offset2 ? -1 : (offset1 == offset2 ? 0 : 1);
                }
            } else {
                if (p1a != null) {
                    offset1 = p1a.getParent().getChildren().indexOf(p1a);
                }
                if (p2a != null) {
                    offset2 = p2a.getParent().getChildren().indexOf(p2a);
                }
                if (p1a == null && p2a == null || p1a != null && p2a != null) {
                    return offset1 < offset2 ? -1 : (offset1 == offset2 ? 0 : 1);
                }
                if (p1a == null) {
                    return offset1 <= offset2 ? -1 : 1;
                }
                return offset1 >= offset2 ? 1 : -1;
            }
            ++i;
        }
    }

    private static List getAncesters(EditPart part) {
        ArrayList<EditPart> list = new ArrayList<EditPart>();
        while (part != null) {
            list.add(part);
            if (part instanceof DocumentEditPart) break;
            part = part.getParent();
        }
        if (part == null) {
            return null;
        }
        Collections.reverse(list);
        list.add(null);
        return list;
    }

    public static EditPart findCommonAncester(EditPart part1, EditPart part2) {
        if (part1 == part2) {
            return part1;
        }
        List list1 = RangeUtil.getAncesters(part1);
        if (list1 == null) {
            return null;
        }
        List list2 = RangeUtil.getAncesters(part2);
        if (list2 == null) {
            return null;
        }
        if (list1.get(0) != list2.get(0)) {
            return null;
        }
        EditPart common = (EditPart)list1.get(0);
        int i = 1;
        while (true) {
            EditPart p1 = (EditPart)list1.get(i);
            EditPart p2 = (EditPart)list2.get(i);
            if (p1 == null || p2 == null) {
                return common;
            }
            if (p1 != p2) {
                return common;
            }
            common = p1;
            ++i;
        }
    }

    public static EditPart findCommonAncestor(DesignRange range) {
        if (!range.isValid()) {
            return null;
        }
        DesignPosition startPosition = range.getStartPosition();
        DesignPosition endPosition = range.getEndPosition();
        return RangeUtil.findCommonAncester(startPosition.getContainerPart(), endPosition.getContainerPart());
    }
}

