/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.tools;

import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.pagedesigner.commands.DeleteNodeCommand;
import org.eclipse.jst.pagedesigner.commands.SwitchSelectionCommand;
import org.eclipse.jst.pagedesigner.commands.nav.HorizontalMoveCommand;
import org.eclipse.jst.pagedesigner.commands.nav.ICaretPositionMover;
import org.eclipse.jst.pagedesigner.commands.nav.VerticalMoveCommand;
import org.eclipse.jst.pagedesigner.commands.range.CopyCommand;
import org.eclipse.jst.pagedesigner.commands.range.CutCommand;
import org.eclipse.jst.pagedesigner.commands.range.DeleteCommand;
import org.eclipse.jst.pagedesigner.commands.range.InsertCommand;
import org.eclipse.jst.pagedesigner.commands.range.KeyboardData;
import org.eclipse.jst.pagedesigner.commands.range.PasteCommand;
import org.eclipse.jst.pagedesigner.commands.range.SelectAllCommand;
import org.eclipse.jst.pagedesigner.editors.pagedesigner.PageDesignerResources;
import org.eclipse.jst.pagedesigner.parts.DocumentEditPart;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.jst.pagedesigner.requests.LocationModifierRequest;
import org.eclipse.jst.pagedesigner.viewer.HTMLGraphicalViewer;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Cursor;

public class RangeSelectionTool
extends SelectionTool {
    private LocationRequest _hoverRequest;

    protected boolean handleKeyDown(KeyEvent e) {
        if (this.isHoverActive()) {
            this.handleHoverStop();
        }
        this.setHoverActive(false);
        if ((e.stateMask & 0x10000) != 0) {
            return false;
        }
        Command command = null;
        KeyboardData keyCode = null;
        switch (e.keyCode) {
            case 0x100000B: {
                command = new SwitchSelectionCommand((IHTMLGraphicalViewer)this.getCurrentViewer());
                break;
            }
            case 0x1000001: {
                command = new VerticalMoveCommand((IHTMLGraphicalViewer)this.getCurrentViewer(), true, (e.stateMask & 0x20000) != 0);
                break;
            }
            case 0x1000002: {
                command = new VerticalMoveCommand((IHTMLGraphicalViewer)this.getCurrentViewer(), false, (e.stateMask & 0x20000) != 0);
                break;
            }
            case 0x1000003: {
                command = new HorizontalMoveCommand((IHTMLGraphicalViewer)this.getCurrentViewer(), false, (e.stateMask & 0x20000) != 0);
                break;
            }
            case 0x1000004: {
                command = new HorizontalMoveCommand((IHTMLGraphicalViewer)this.getCurrentViewer(), true, (e.stateMask & 0x20000) != 0);
                break;
            }
            case 127: {
                if ((e.stateMask & 0x20000) == 0) {
                    Object object;
                    ISelection selection;
                    if (this.getCurrentViewer().getSelection() != null && (selection = this.getCurrentViewer().getSelection()) instanceof StructuredSelection && !((object = ((StructuredSelection)selection).getFirstElement()) instanceof DocumentEditPart)) {
                        command = new DeleteNodeCommand((IHTMLGraphicalViewer)this.getCurrentViewer());
                    }
                    if (command != null) break;
                    command = new DeleteCommand(true, (IHTMLGraphicalViewer)this.getCurrentViewer());
                    break;
                }
                command = new CutCommand((IHTMLGraphicalViewer)this.getCurrentViewer());
                e.doit = false;
                break;
            }
            case 8: {
                command = new DeleteCommand(false, (IHTMLGraphicalViewer)this.getCurrentViewer());
                e.doit = false;
                break;
            }
            case 0x1000009: {
                if ((e.stateMask & 0x20000) != 0) {
                    command = new PasteCommand((IHTMLGraphicalViewer)this.getCurrentViewer());
                    e.doit = false;
                    break;
                }
                if ((e.stateMask & 0x40000) == 0) break;
                command = new CopyCommand((IHTMLGraphicalViewer)this.getCurrentViewer());
                e.doit = false;
                break;
            }
            case 10: 
            case 13: {
                keyCode = new KeyboardData(e.character, e.stateMask, (IHTMLGraphicalViewer)this.getCurrentViewer());
                command = new InsertCommand(PageDesignerResources.getInstance().getString("RangeSelectionTool.CommandLabel.Insert"), (IHTMLGraphicalViewer)this.getCurrentViewer(), keyCode);
                e.doit = false;
                break;
            }
            default: {
                if (e.keyCode == 97 && (e.stateMask & 0x40000) != 0) {
                    command = new SelectAllCommand("selectAll", (IHTMLGraphicalViewer)this.getCurrentViewer());
                    e.doit = false;
                    break;
                }
                if (this.getCurrentViewer() instanceof HTMLGraphicalViewer && ((HTMLGraphicalViewer)this.getCurrentViewer()).isInRangeMode() && !Character.isIdentifierIgnorable(e.character) && !Character.isISOControl(e.character) || e.character == '\r') {
                    keyCode = new KeyboardData(e.character, e.stateMask, (IHTMLGraphicalViewer)this.getCurrentViewer());
                    command = new InsertCommand(PageDesignerResources.getInstance().getString("RangeSelectionTool.CommandLabel.Insert"), (IHTMLGraphicalViewer)this.getCurrentViewer(), keyCode);
                    e.doit = false;
                    break;
                }
                return super.handleKeyDown(e);
            }
        }
        if (command != null) {
            command.execute();
            e.doit = false;
            if (command instanceof ICaretPositionMover && this.getCurrentViewer() instanceof HTMLGraphicalViewer) {
                ((HTMLGraphicalViewer)this.getCurrentViewer()).updateHorizontalPos();
            }
            return true;
        }
        return false;
    }

    protected void createHoverRequest() {
        this._hoverRequest = new LocationModifierRequest();
        this._hoverRequest.setType((Object)"selection hover");
    }

    protected Request getTargetHoverRequest() {
        if (this._hoverRequest == null) {
            this.createHoverRequest();
        }
        return this._hoverRequest;
    }

    protected void updateHoverRequest() {
        LocationModifierRequest request = (LocationModifierRequest)this.getTargetHoverRequest();
        request.setLocation(this.getLocation());
        request.setControlKeyPressed(this.getCurrentInput().isControlKeyDown());
    }

    protected void showHoverFeedback() {
        if (this.getTargetEditPart() instanceof NodeEditPart) {
            ((NodeEditPart)this.getTargetEditPart()).setDragActive(this.isInState(38));
        }
        super.showHoverFeedback();
    }

    protected boolean handleMove() {
        boolean handled = super.handleMove();
        EditPart targetEditPart = this.getTargetEditPart();
        if (this.isInState(1) && targetEditPart instanceof NodeEditPart) {
            LocationRequest request = new LocationRequest((Object)"selection.tracker.request");
            request.setLocation(this.getLocation());
            DragTracker selectionTracker = targetEditPart.getDragTracker((Request)request);
            this.setDragTracker(selectionTracker);
        }
        return handled;
    }

    protected Cursor calculateCursor() {
        Cursor nodeCursor;
        EditPart targetEditPart = this.getTargetEditPart();
        if (this.isInState(1) && targetEditPart instanceof NodeEditPart && (nodeCursor = ((NodeEditPart)targetEditPart).getCursor(this.getLocation())) != null && this.getDragTracker() == null) {
            return nodeCursor;
        }
        return super.calculateCursor();
    }
}

