/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.common.ui.internal.utils.ResourceUtils;
import org.eclipse.jst.jsf.common.ui.internal.utils.WebrootUtil;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectResolver
implements URIResolver {
    private static final String TLD_TAG_URI = "uri";
    private static final String URI_PREFIX_HTTP = "http";
    private static final String FILE_PROTOCOL = "file";
    private static Logger _log = PDPlugin.getLogger(ProjectResolver.class);
    private IProject _project = null;
    private String _fileBaseLocation = null;
    private static Map _uriMap = null;

    public ProjectResolver(IProject project) {
        this._project = project;
    }

    public void seekTld(IFolder path) {
        if (path == null) {
            return;
        }
        if (_uriMap == null) {
            _uriMap = new HashMap();
        }
        try {
            IResource[] res = path.members();
            if (res == null) {
                return;
            }
            int i = 0;
            while (i < res.length) {
                String ext;
                if (res[i] instanceof IFolder) {
                    this.seekTld((IFolder)res[i]);
                }
                if ("tld".equalsIgnoreCase(ext = res[i].getFileExtension())) {
                    IFile tldFile = (IFile)res[i];
                    String uri = this.getURIfromTLD(tldFile);
                    String locate = tldFile.getLocation().toOSString();
                    if (uri != null && _uriMap.get(uri) == null) {
                        _uriMap.put(uri, locate);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            _log.error("Error.ProjectResolver.GetlocationByURI.0", (Throwable)e);
        }
    }

    public void seekTld(File path) {
        if (path == null || !path.isDirectory()) {
            return;
        }
        if (_uriMap == null) {
            _uriMap = new HashMap();
        }
        try {
            File[] res = path.listFiles();
            if (res == null) {
                return;
            }
            int i = 0;
            while (i < res.length) {
                if (res[i] instanceof IFolder) {
                    this.seekTld(res[i]);
                }
                if (res[i].getName().endsWith(".tld")) {
                    String uri = this.getURIfromTLD(res[i]);
                    String locate = res[i].getCanonicalPath();
                    if (uri != null && _uriMap.get(uri) == null) {
                        _uriMap.put(uri, locate);
                    }
                }
                ++i;
            }
        }
        catch (IOException e1) {
            _log.error("Error.ProjectResolver.GetlocationByURI.0", (Throwable)e1);
        }
    }

    public String getURIfromTLD(File tldFile) {
        if (tldFile == null) {
            return null;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(tldFile);
        }
        catch (FileNotFoundException e) {
            _log.error("RenderingTraverser.Error.FileNotFound", (Throwable)e);
        }
        try {
            IDOMModel tldModel = (IDOMModel)PDPlugin.getModelManager().getModelForRead(tldFile.getAbsolutePath(), (InputStream)in, null);
            NodeList uriList = tldModel.getDocument().getElementsByTagName(TLD_TAG_URI);
            int i = 0;
            int n = uriList.getLength();
            if (i < n) {
                Node uri = uriList.item(i);
                String string = uri.getChildNodes().item(0).getNodeValue();
                return string;
            }
        }
        catch (UnsupportedEncodingException e1) {
            _log.error("RenderingTraverser.Error.UnsupportedEncoding", (Throwable)e1);
        }
        catch (IOException e1) {
            _log.error("RenderingTraverser.Error.IO", (Throwable)e1);
        }
        finally {
            ResourceUtils.ensureClosed((InputStream)in);
        }
        return null;
    }

    public String getURIfromTLD(IFile tldFile) {
        if (tldFile == null) {
            return null;
        }
        try {
            IDOMModel tldModel = (IDOMModel)this.getModelManager().getModelForRead(tldFile);
            NodeList uriList = tldModel.getDocument().getElementsByTagName(TLD_TAG_URI);
            int i = 0;
            int n = uriList.getLength();
            if (i < n) {
                Node uri = uriList.item(i);
                return uri.getChildNodes().item(0).getNodeValue();
            }
        }
        catch (IOException e) {
            _log.error("Error.ProjectResolver.GetlocationByURI.0", (Throwable)e);
        }
        catch (CoreException e1) {
            _log.error("Error.ProjectResolver.GetlocationByURI.0", (Throwable)e1);
        }
        return null;
    }

    public void initTldMap() {
        if (_uriMap == null) {
            _uriMap = new HashMap();
        }
        if (this._project == null) {
            return;
        }
        if (WebrootUtil.getWebContentFolder((IProject)this._project) == null) {
            return;
        }
        IFolder webinf = WebrootUtil.getWebContentFolder((IProject)this._project).getFolder("WEB-INF");
        if (webinf != null && webinf.exists()) {
            this.seekTld(webinf);
        }
        String locate = PDPlugin.getInstallLocation().append("/jsf-tld").toString();
        File jsfDir = new File(locate);
        this.seekTld(jsfDir);
    }

    public String getFileBaseLocation() {
        return this._fileBaseLocation;
    }

    public String getLocationByURI(String uri) {
        return this.getLocationByURI(uri, this.getFileBaseLocation());
    }

    private IModelManager getModelManager() {
        return StructuredModelManager.getModelManager();
    }

    private String getLocationFromWEBXML(String uri, String baseReference) {
        if (uri == null) {
            return null;
        }
        try {
            IFile webxml;
            if (uri.startsWith("/")) {
                uri = String.valueOf(this._project.getProject().getLocation().toString()) + "/" + WebrootUtil.getWebContentFolderName((IProject)this._project) + uri;
            }
            if (uri.startsWith(URI_PREFIX_HTTP) && (webxml = WebrootUtil.getWebContentFolder((IProject)this._project).getFolder("WEB-INF").getFile("web.xml")).exists()) {
                try {
                    IDOMModel xmlModel = (IDOMModel)this.getModelManager().getModelForRead(webxml);
                    NodeList taglibNodeList = xmlModel.getDocument().getElementsByTagName("taglib");
                    int i = 0;
                    int size = taglibNodeList.getLength();
                    while (i < size) {
                        Node taglibNode = taglibNodeList.item(i);
                        NodeList childList = taglibNode.getChildNodes();
                        String taguri = "";
                        String taglocation = "";
                        int j = 0;
                        int childSize = childList.getLength();
                        while (j < childSize) {
                            Node childTaglibNode = childList.item(j);
                            if ("taglib-uri".equalsIgnoreCase(childTaglibNode.getNodeName())) {
                                taguri = childTaglibNode.getChildNodes().item(0).getNodeValue();
                            }
                            if ("taglib-location".equalsIgnoreCase(childTaglibNode.getNodeName())) {
                                taglocation = childTaglibNode.getChildNodes().item(0).getNodeValue();
                            }
                            ++j;
                        }
                        if (uri.equalsIgnoreCase(taguri)) {
                            uri = String.valueOf(this._project.getProject().getLocation().toString()) + "/" + WebrootUtil.getWebContentFolderName((IProject)this._project) + taglocation;
                        }
                        ++i;
                    }
                    xmlModel.releaseFromRead();
                }
                catch (IOException e) {
                    _log.error("Error.ProjectResolver.GetlocationByURI.0", (Throwable)e);
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                    _log.error("Error.ProjectResolver.GetlocationByURI.0", (Throwable)e1);
                }
            }
        }
        catch (DOMException e1) {
            _log.error("Error.ProjectResolver.GetlocationByURI.0", (Throwable)e1);
        }
        if (this.isFileURL(uri)) {
            try {
                URL url = new URL(uri);
                return this.getPath(url);
            }
            catch (MalformedURLException e) {
                _log.error("Error.ProjectResolver.GetlocationByURI.0", (Throwable)e);
            }
        }
        return URIHelper.normalize((String)uri, (String)baseReference, (String)this.getRootLocationString());
    }

    public String getLocationByURI(String uri, String baseReference) {
        int columnIndex = uri.indexOf(":");
        int slashIndex = uri.indexOf("/");
        if (columnIndex != -1 && (slashIndex == -1 || columnIndex < slashIndex)) {
            return uri;
        }
        String result = this.getLocationFromWEBXML(uri, baseReference);
        if (result != null && !result.equals(uri)) {
            return result;
        }
        if (_uriMap == null) {
            this.initTldMap();
        }
        if (_uriMap != null) {
            return (String)_uriMap.get(uri);
        }
        return null;
    }

    private boolean isFileURL(String passedSpec) {
        if (passedSpec == null) {
            return false;
        }
        String spec = passedSpec.trim();
        if (spec.length() == 0) {
            return false;
        }
        String newProtocol = null;
        int index = 0;
        int limit = spec.length();
        while (index < limit) {
            char p = spec.charAt(index);
            if (p == '/') break;
            if (p == ':') {
                newProtocol = spec.substring(0, index);
                break;
            }
            ++index;
        }
        return newProtocol != null && newProtocol.compareToIgnoreCase(FILE_PROTOCOL) == 0;
    }

    private String getPath(URL url) {
        Path path;
        String ref = url.getRef() == null ? "" : "#" + url.getRef();
        String strPath = String.valueOf(url.getFile()) + ref;
        if (strPath.length() == 0) {
            path = Path.ROOT;
        } else {
            path = new Path(strPath);
            String query = null;
            StringTokenizer parser = new StringTokenizer(strPath, "?");
            int tokenCount = parser.countTokens();
            if (tokenCount == 2) {
                path = new Path((String)parser.nextElement());
                query = (String)parser.nextElement();
            }
            if (query == null && (tokenCount = (parser = new StringTokenizer(path.toString(), "#")).countTokens()) == 2) {
                path = new Path((String)parser.nextElement());
            }
        }
        return this.getPath((IPath)path, url.getHost());
    }

    private String getPath(IPath path, String host) {
        IPath newPath = path;
        String device = path.getDevice();
        if (device != null && device.length() > 0 && device.charAt(0) == '/') {
            String newDevice = device.substring(1);
            newPath = path.setDevice(newDevice);
        }
        if (path != null && host != null && host.length() != 0) {
            Path uncPath = new Path(host);
            uncPath = uncPath.append(path);
            newPath = uncPath.makeUNC(true);
        }
        return newPath.toString();
    }

    public String getLocationByURI(String uri, boolean resolveCrossProjectLinks) {
        return this.getLocationByURI(uri, this.getFileBaseLocation(), resolveCrossProjectLinks);
    }

    public String getLocationByURI(String uri, String baseReference, boolean resolveCrossProjectLinks) {
        return this.getLocationByURI(uri, baseReference);
    }

    public IProject getProject() {
        return this._project;
    }

    public IContainer getRootLocation() {
        return this._project;
    }

    protected String getRootLocationString() {
        return null;
    }

    public void setFileBaseLocation(String newFileBaseLocation) {
        this._fileBaseLocation = newFileBaseLocation;
    }

    public void setProject(IProject newProject) {
        this._project = newProject;
    }

    public InputStream getURIStream(String uri) {
        return null;
    }
}

