/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.validation.caret;

import java.util.List;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.parts.DocumentEditPart;
import org.eclipse.jst.pagedesigner.tools.ExposeHelper;
import org.eclipse.jst.pagedesigner.validation.caret.ActionData;
import org.eclipse.jst.pagedesigner.validation.caret.BasicMovementRule;
import org.eclipse.jst.pagedesigner.validation.caret.ContainerMoveInAndOutRule;
import org.eclipse.jst.pagedesigner.validation.caret.IMovementMediator;
import org.eclipse.jst.pagedesigner.validation.caret.IMovementRule;
import org.eclipse.jst.pagedesigner.validation.caret.IPositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.InlineEditingPositionMediator;
import org.eclipse.jst.pagedesigner.validation.caret.RootContainerPositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.HTMLGraphicalViewer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class InlineEditingNavigationMediator
extends InlineEditingPositionMediator
implements IMovementMediator {
    public InlineEditingNavigationMediator(ActionData actionData) {
        super(actionData);
    }

    protected void initRules() {
        super.initRules();
        this.addRule(new ContainerMoveInAndOutRule(this._actionData));
        this.addRule(new BasicMovementRule(this._actionData));
    }

    public boolean allowsMoveIn(Target target) {
        boolean result = true;
        List _rules = this.getRules();
        int i = 0;
        int n = _rules.size();
        while (i < n) {
            Object rule = _rules.get(i);
            if (rule instanceof IMovementRule) {
                result &= ((IMovementRule)rule).allowsMoveIn(target);
            } else if (rule instanceof IPositionRule) {
                result &= ((IPositionRule)rule).hasEditableArea(target);
            }
            if (!result) break;
            ++i;
        }
        return result;
    }

    public boolean allowsMoveOut(Target target) {
        boolean result = true;
        List _rules = this.getRules();
        int i = 0;
        int n = _rules.size();
        while (i < n) {
            Object rule = _rules.get(i);
            if (rule instanceof IMovementRule) {
                result &= ((IMovementRule)rule).allowsMoveOut(target);
            }
            if (!result) break;
            ++i;
        }
        return result;
    }

    public EditPart getRootConstainedEditableContainer(Target target) {
        EditPart part = target.getPart();
        while (part != null) {
            if (this.hasEditableArea(target) && !this.allowsMoveOut(target)) break;
            part = part.getParent();
            target = new Target(part);
        }
        if (part instanceof DocumentEditPart && RootContainerPositionRule.hasBasicContainers((Document)part.getModel())) {
            Node node = RootContainerPositionRule.getBasicContainer((Document)part.getModel());
            part = Target.resolvePart(node);
        }
        return part;
    }

    public EditPart getConstainedEditableContainer(Target target) {
        EditPart part = target.getPart();
        while (part != null) {
            if (this.hasEditableArea(target)) break;
            part = part.getParent();
            target = new Target(part);
        }
        if (part instanceof DocumentEditPart && RootContainerPositionRule.hasBasicContainers((Document)part.getModel())) {
            Node node = RootContainerPositionRule.getBasicContainer((Document)part.getModel());
            part = Target.resolvePart(node);
        }
        return part;
    }

    public EditPart getConstainedEditableContainer(DesignPosition position, Point p, GraphicalViewer viewer) {
        Rectangle rect = new Rectangle(p.x, p.y, 1, 1);
        Viewport port = ((HTMLGraphicalViewer)viewer).getViewport();
        Point viewLocation = port.getViewLocation();
        Point lastLocation = viewLocation.getCopy();
        new ExposeHelper((HTMLGraphicalViewer)viewer).exposeArea(rect);
        viewLocation = port.getViewLocation();
        Dimension offset = lastLocation.getDifference(viewLocation);
        p.translate(offset.width, offset.height);
        EditPart part = viewer.findObjectAt(p);
        if (part != null && !(part instanceof ScalableRootEditPart)) {
            while (part != null) {
                Target target = new Target(part);
                if (this.hasEditableArea(target) && (this.allowsMoveIn(target) || EditModelQuery.isChild(target.getNode(), position.getContainerNode()))) break;
                part = part.getParent();
            }
            if (part instanceof DocumentEditPart && RootContainerPositionRule.hasBasicContainers((Document)part.getModel())) {
                Node node = RootContainerPositionRule.getBasicContainer((Document)part.getModel());
                part = Target.resolvePart(node);
            }
            return part;
        }
        return null;
    }
}

