/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operation.extensionui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.IExtensibleViewFactory;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;

public class ExtensibleViewRegistry
extends RegistryReader {
    private static ExtensibleViewRegistry INSTANCE = null;
    private Map extendedViewerMap = null;
    private Map descriptorMap = null;

    private ExtensibleViewRegistry() {
        super("org.eclipse.wst.common.frameworks.ui", "extendedViewer");
    }

    public static ExtensibleViewRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExtensibleViewRegistry();
            INSTANCE.readRegistry();
        }
        return INSTANCE;
    }

    public Descriptor getDescriptor(String viewerID) {
        return (Descriptor)this.getDescriptorMap().get(viewerID);
    }

    public boolean readElement(IConfigurationElement element) {
        if (element.getName().equals("extendedViewer")) {
            Descriptor descriptor = new Descriptor(element);
            this.getDescriptorMap().put(descriptor.getViewerID(), descriptor);
            return true;
        }
        return false;
    }

    protected Map getExtendedViewerMap() {
        if (this.extendedViewerMap == null) {
            this.extendedViewerMap = new HashMap();
        }
        return this.extendedViewerMap;
    }

    protected Map getDescriptorMap() {
        if (this.descriptorMap == null) {
            this.descriptorMap = new HashMap();
        }
        return this.descriptorMap;
    }

    public class Descriptor {
        private String viewerID = null;
        private String parentViewerID = null;
        private String factoryClass = null;
        private String icon = null;
        private String label = null;
        private String functionGroupID = null;
        private String toStringCache = null;
        private IConfigurationElement element = null;

        public Descriptor(IConfigurationElement element) {
            this.element = element;
            this.viewerID = this.element.getAttribute("viewerID");
            this.parentViewerID = this.element.getAttribute("parentViewerID");
            this.factoryClass = this.element.getAttribute("factoryClass");
            this.icon = this.element.getAttribute("icon");
            this.label = this.element.getAttribute("label");
            this.functionGroupID = this.element.getAttribute("functionGroupID");
        }

        public IExtensibleViewFactory createFactoryInstance() {
            IExtensibleViewFactory factoryInstance = null;
            try {
                factoryInstance = (IExtensibleViewFactory)this.element.createExecutableExtension(this.getFactoryClass());
            }
            catch (CoreException e) {
                WTPUIPlugin.getLogger().logError((Throwable)e);
            }
            return factoryInstance;
        }

        public String getFactoryClass() {
            return this.factoryClass;
        }

        public String getFunctionGroupID() {
            return this.functionGroupID;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getLabel() {
            return this.label;
        }

        public String getParentViewerID() {
            return this.parentViewerID;
        }

        public String getViewerID() {
            return this.viewerID;
        }

        public String toString() {
            if (this.toStringCache == null) {
                this.toStringCache = "ExtensibleViewRegistry.Info [viewerID=\"" + this.getViewerID() + "\",parentViewerID=\"" + this.getParentViewerID() + "\",factoryClass=" + this.getFactoryClass() + "\",functionGroupID=\"" + this.getFunctionGroupID() + "\"]";
            }
            return this.toStringCache;
        }
    }

    protected static interface Elements {
        public static final String EXTENDED_VIEWER = "extendedViewer";
        public static final String VIEWER_ID = "viewerID";
        public static final String PARENT_VIEWER_ID = "parentViewerID";
        public static final String FACTORY_CLASS = "factoryClass";
        public static final String ICON = "icon";
        public static final String LABEL = "label";
        public static final String FUNCTION_GROUP_ID = "functionGroupID";
    }
}

