/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.symbols;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.IBeanInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.ISymbolConstants;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigManager;
import org.eclipse.jst.jsf.designtime.symbols.FileContextUtil;
import org.eclipse.jst.jsf.designtime.symbols.Messages;
import org.eclipse.jst.jsf.designtime.symbols.SymbolUtil;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;

public class DefaultBeanSymbolSourceProvider {
    private static DefaultBeanSymbolSourceProvider INSTANCE;

    public static DefaultBeanSymbolSourceProvider getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DefaultBeanSymbolSourceProvider();
        }
        return INSTANCE;
    }

    protected DefaultBeanSymbolSourceProvider() {
    }

    public ISymbol[] getSymbols(IAdaptable context, int symbolScopeMask) {
        IFile file = FileContextUtil.deriveIFileFromContext(context);
        if (file != null) {
            IProject myProject = file.getProject();
            List managedBeans = this.getManagedBeanSymbols(myProject, symbolScopeMask);
            return managedBeans.toArray(ISymbol.EMPTY_SYMBOL_ARRAY);
        }
        return ISymbol.EMPTY_SYMBOL_ARRAY;
    }

    public ISymbol getSymbol(String name, IAdaptable context, int symbolScopeMask) {
        return SymbolUtil.findSymbolByName(this.getSymbols(context, symbolScopeMask), name);
    }

    public ISymbol[] getSymbols(String prefix, IAdaptable context, int symbolScopeMask) {
        return SymbolUtil.filterSymbolsByPrefix(this.getSymbols(context, symbolScopeMask), prefix);
    }

    private List getManagedBeanSymbols(IProject iProject, int symbolScopeMask) {
        ArrayList<IBeanInstanceSymbol> symbols = new ArrayList<IBeanInstanceSymbol>();
        JSFAppConfigManager configManager = JSFAppConfigManager.getInstance(iProject);
        if (configManager != null) {
            for (ManagedBeanType bean : configManager.getManagedBeans()) {
                if (!this.isBeanScopeInMask(bean.getManagedBeanScope(), symbolScopeMask)) continue;
                String name = bean.getManagedBeanName().getTextContent();
                String detailedDescription = this.createAdditionalProposalInfo(bean);
                IBeanInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
                symbol.setName(name);
                symbol.setDetailedDescription(detailedDescription);
                symbol.setRuntimeSource(ERuntimeSource.MANAGED_BEAN_SYMBOL_LITERAL);
                try {
                    IJavaProject javaProject = JavaCore.create((IProject)iProject);
                    IType type = javaProject.findType(bean.getManagedBeanClass().getTextContent());
                    if (type != null) {
                        IJavaTypeDescriptor2 javaTypeDescriptor = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
                        javaTypeDescriptor.setType(type);
                        symbol.setJavaTypeDescriptor(javaTypeDescriptor);
                    }
                }
                catch (Exception exception) {}
                symbols.add(symbol);
            }
        }
        return symbols;
    }

    private String createAdditionalProposalInfo(ManagedBeanType beanType) {
        StringBuffer additionalInfo = new StringBuffer("<p><b>");
        additionalInfo.append(Messages.getString("DefaultBeanSymbolSourceProvider.AdditionalInformation.Name"));
        additionalInfo.append("</b>");
        additionalInfo.append(beanType.getManagedBeanName().getTextContent());
        additionalInfo.append("</p><p><b>");
        additionalInfo.append(Messages.getString("DefaultBeanSymbolSourceProvider.AdditionalInformation.Type"));
        additionalInfo.append(" </b>");
        additionalInfo.append(beanType.getManagedBeanClass().getTextContent());
        additionalInfo.append("</p><p><b>");
        additionalInfo.append(Messages.getString("DefaultBeanSymbolSourceProvider.AdditionalInformation.Scope"));
        additionalInfo.append("</b>");
        additionalInfo.append(beanType.getManagedBeanScope().getTextContent());
        additionalInfo.append("</p>");
        StringBuffer descBuffer = new StringBuffer();
        for (DescriptionType descType : beanType.getDescription()) {
            String appendString = descType.getTextContent();
            if (appendString == null) continue;
            descBuffer.append(appendString);
        }
        if (descBuffer.length() > 0) {
            additionalInfo.append("<p><b>");
            additionalInfo.append(Messages.getString("DefaultBeanSymbolSourceProvider.AdditionalInformation.Description"));
            additionalInfo.append("</b>");
            additionalInfo.append(descBuffer);
            additionalInfo.append("</p>");
        }
        return additionalInfo.toString();
    }

    private boolean isBeanScopeInMask(ManagedBeanScopeType scope, int scopeMask) {
        int testScope = ISymbolConstants.getMaskForString((String)scope.getTextContent());
        if (testScope != -1) {
            return (scopeMask & testScope) != 0;
        }
        return false;
    }
}

