/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.appconfig;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.common.util.JDTBeanIntrospector;
import org.eclipse.jst.jsf.common.util.JDTBeanProperty;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyNameType;
import org.eclipse.jst.jsf.validation.internal.appconfig.EObjectValidationVisitor;
import org.eclipse.jst.jsf.validation.internal.appconfig.PropertyNameValidationVisitor;

public class PropertyValidationVisitor
extends EObjectValidationVisitor {
    private final EStructuralFeature _parentClassName;

    public PropertyValidationVisitor(EStructuralFeature feature, EStructuralFeature parentClassName, String version) {
        super(feature, version);
        this._parentClassName = parentClassName;
    }

    protected void doValidate(EObject object, List messages, IFile file) {
    }

    protected EObjectValidationVisitor[] getChildNodeValidators() {
        return new EObjectValidationVisitor[]{new PropertyNameValidationVisitor((EStructuralFeature)FacesConfigPackage.eINSTANCE.getPropertyType_PropertyName(), this._parentClassName, this.getVersion())};
    }

    static String validateProperty(PropertyNameType object, IProject project, String parentClassType) {
        String signatureBeanProperty = null;
        try {
            String propertyName;
            JDTBeanIntrospector introspector;
            Map properties;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IType type = javaProject.findType(parentClassType);
            if (type != null && (properties = (introspector = new JDTBeanIntrospector(type)).getProperties()).containsKey(propertyName = object.getTextContent())) {
                JDTBeanProperty beanProperty = (JDTBeanProperty)properties.get(propertyName);
                signatureBeanProperty = beanProperty.getTypeSignature();
            }
        }
        catch (JavaModelException jme) {
            JSFCorePlugin.log(new Exception(jme), "Problem validating on parent: " + parentClassType);
        }
        return signatureBeanProperty;
    }
}

