/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.uml.util;

import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ocl.types.TupleType;

public class UMLTypeUtil {
    public static final String ANNOTATION_URI_CLASSIFIER = "http://www.eclipse.org/OCL/1.0.0/classifier";
    public static final String ANNOTATION_URI_MEMBER_ENDS = "http://www.eclipse.org/OCL/1.0.0/memberEnds";
    public static final String ANNOTATION_URI_ASSOCIATION_CLASS = "http://www.eclipse.org/OCL/1.0.0/associationClass";
    public static final String ANNOTATION_URI_OPERATION = "http://www.eclipse.org/OCL/1.0.0/operation";
    public static final String ANNOTATION_URI_QUALIFIERS = "http://www.eclipse.org/OCL/1.0.0/qualifiers";
    public static final String ANNOTATION_URI_SIGNALS = "http://www.eclipse.org/OCL/1.0.0/signals";

    private UMLTypeUtil() {
    }

    public static boolean isSignal(EClassifier classifier) {
        EAnnotation ann;
        boolean result = false;
        if (classifier != null && (ann = classifier.getEAnnotation(ANNOTATION_URI_CLASSIFIER)) != null) {
            result = "Signal".equals(ann.getDetails().get((Object)"kind"));
        }
        return result;
    }

    public static boolean isAssociationClass(EClassifier classifier) {
        EAnnotation ann;
        boolean result = false;
        if (classifier != null && (ann = classifier.getEAnnotation(ANNOTATION_URI_CLASSIFIER)) != null) {
            result = "AssociationClass".equals(ann.getDetails().get((Object)"kind"));
        }
        return result;
    }

    public static boolean isClass(EClassifier classifier) {
        EAnnotation ann;
        boolean result;
        boolean bl = result = classifier instanceof EClass && !(classifier instanceof TupleType);
        if (!result && classifier != null && (ann = classifier.getEAnnotation(ANNOTATION_URI_CLASSIFIER)) != null) {
            result = "Class".equals(ann.getDetails().get((Object)"kind"));
        }
        return result;
    }

    public static boolean isDataType(EClassifier classifier) {
        EAnnotation ann;
        boolean result;
        boolean bl = result = classifier instanceof EDataType || classifier instanceof TupleType || UMLTypeUtil.isEnumeration(classifier);
        if (!result && classifier != null && (ann = classifier.getEAnnotation(ANNOTATION_URI_CLASSIFIER)) != null) {
            result = "DataType".equals(ann.getDetails().get((Object)"kind"));
        }
        return result;
    }

    public static boolean isEnumeration(EClassifier classifier) {
        EAnnotation ann;
        boolean result = classifier instanceof EEnum;
        if (!result && classifier != null && (ann = classifier.getEAnnotation(ANNOTATION_URI_CLASSIFIER)) != null) {
            result = "Enumeration".equals(ann.getDetails().get((Object)"kind"));
        }
        return result;
    }

    public static boolean isQuery(EOperation operation) {
        EAnnotation ann;
        boolean result = true;
        if (operation != null && (ann = operation.getEAnnotation(ANNOTATION_URI_OPERATION)) != null) {
            result = !"false".equals(ann.getDetails().get((Object)"isQuery"));
        }
        return result;
    }

    public static EList getMemberEnds(EClass associationClass) {
        EAnnotation ann;
        EList result = ECollections.EMPTY_ELIST;
        if (associationClass != null && (ann = associationClass.getEAnnotation(ANNOTATION_URI_MEMBER_ENDS)) != null) {
            result = ann.getReferences();
        }
        return result;
    }

    public static EClass getAssociationClass(EReference reference) {
        EList references;
        EAnnotation ann;
        EClass result = null;
        if (reference != null && (ann = reference.getEAnnotation(ANNOTATION_URI_ASSOCIATION_CLASS)) != null && !(references = ann.getReferences()).isEmpty()) {
            result = (EClass)references.get(0);
        }
        return result;
    }

    public static EList getQualifiers(EStructuralFeature property) {
        EAnnotation ann;
        EList result = ECollections.EMPTY_ELIST;
        if (property != null && (ann = property.getEAnnotation(ANNOTATION_URI_QUALIFIERS)) != null) {
            result = ann.getContents();
        }
        return result;
    }

    public static EStructuralFeature getProperty(EStructuralFeature qualifier) {
        EAnnotation annotation;
        EStructuralFeature result = null;
        if (qualifier != null && qualifier.eContainer() instanceof EAnnotation && (annotation = (EAnnotation)qualifier.eContainer()).getEModelElement() instanceof EStructuralFeature) {
            result = (EStructuralFeature)annotation.getEModelElement();
        }
        return result;
    }

    public static EList getSignals(EClass eclass) {
        EAnnotation ann;
        EList result = ECollections.EMPTY_ELIST;
        if (eclass != null && (ann = eclass.getEAnnotation(ANNOTATION_URI_SIGNALS)) != null) {
            result = ann.getReferences();
        }
        return result;
    }

    public static void setSignal(EClassifier classifier, boolean isSignal) {
        if (classifier != null) {
            EAnnotation ann = classifier.getEAnnotation(ANNOTATION_URI_CLASSIFIER);
            if (isSignal) {
                if (ann == null) {
                    ann = EcoreFactory.eINSTANCE.createEAnnotation();
                    ann.setSource(ANNOTATION_URI_CLASSIFIER);
                    ann.setEModelElement((EModelElement)classifier);
                }
                ann.getDetails().put((Object)"kind", (Object)"Signal");
            } else if (ann != null) {
                ann.setEModelElement(null);
            }
        }
    }

    public static void setAssociationClass(EClassifier classifier, boolean isAssociationClass) {
        if (classifier != null) {
            EAnnotation ann = classifier.getEAnnotation(ANNOTATION_URI_CLASSIFIER);
            if (isAssociationClass) {
                if (ann == null) {
                    ann = EcoreFactory.eINSTANCE.createEAnnotation();
                    ann.setSource(ANNOTATION_URI_CLASSIFIER);
                    ann.setEModelElement((EModelElement)classifier);
                }
                ann.getDetails().put((Object)"kind", (Object)"AssociationClass");
            } else if (ann != null) {
                ann.setEModelElement(null);
            }
        }
    }

    public static void setClass(EClassifier classifier, boolean isClass) {
        if (classifier != null) {
            EAnnotation ann = classifier.getEAnnotation(ANNOTATION_URI_CLASSIFIER);
            if (isClass) {
                if (ann == null) {
                    ann = EcoreFactory.eINSTANCE.createEAnnotation();
                    ann.setSource(ANNOTATION_URI_CLASSIFIER);
                    ann.setEModelElement((EModelElement)classifier);
                }
                ann.getDetails().put((Object)"kind", (Object)"Class");
            } else if (ann != null) {
                ann.setEModelElement(null);
            }
        }
    }

    public static void setDataType(EClassifier classifier, boolean isDataType) {
        if (classifier != null) {
            EAnnotation ann = classifier.getEAnnotation(ANNOTATION_URI_CLASSIFIER);
            if (isDataType) {
                if (ann == null) {
                    ann = EcoreFactory.eINSTANCE.createEAnnotation();
                    ann.setSource(ANNOTATION_URI_CLASSIFIER);
                    ann.setEModelElement((EModelElement)classifier);
                }
                ann.getDetails().put((Object)"kind", (Object)"DataType");
            } else if (ann != null) {
                ann.setEModelElement(null);
            }
        }
    }

    public static void setEnumeration(EClassifier classifier, boolean isEnumeration) {
        if (classifier != null) {
            EAnnotation ann = classifier.getEAnnotation(ANNOTATION_URI_CLASSIFIER);
            if (isEnumeration) {
                if (ann == null) {
                    ann = EcoreFactory.eINSTANCE.createEAnnotation();
                    ann.setSource(ANNOTATION_URI_CLASSIFIER);
                    ann.setEModelElement((EModelElement)classifier);
                }
                ann.getDetails().put((Object)"kind", (Object)"Enumeration");
            } else if (ann != null) {
                ann.setEModelElement(null);
            }
        }
    }

    public static void setQuery(EOperation operation, boolean isQuery) {
        if (operation != null) {
            EAnnotation ann = operation.getEAnnotation(ANNOTATION_URI_OPERATION);
            if (!isQuery) {
                if (ann == null) {
                    ann = EcoreFactory.eINSTANCE.createEAnnotation();
                    ann.setSource(ANNOTATION_URI_OPERATION);
                    ann.setEModelElement((EModelElement)operation);
                }
                ann.getDetails().put((Object)"isQuery", (Object)"false");
            } else if (ann != null) {
                ann.setEModelElement(null);
            }
        }
    }

    public static void addMemberEnd(EClass associationClass, EReference memberEnd) {
        if (associationClass != null) {
            EAnnotation ann = associationClass.getEAnnotation(ANNOTATION_URI_MEMBER_ENDS);
            if (memberEnd != null) {
                if (ann == null) {
                    ann = EcoreFactory.eINSTANCE.createEAnnotation();
                    ann.setSource(ANNOTATION_URI_MEMBER_ENDS);
                    ann.setEModelElement((EModelElement)associationClass);
                }
                ann.getReferences().add((Object)memberEnd);
                UMLTypeUtil.setAssociationClass(memberEnd, associationClass);
            }
        }
    }

    public static void setAssociationClass(EReference reference, EClass associationClass) {
        if (reference != null) {
            EAnnotation ann = reference.getEAnnotation(ANNOTATION_URI_ASSOCIATION_CLASS);
            if (associationClass != null) {
                if (ann == null) {
                    ann = EcoreFactory.eINSTANCE.createEAnnotation();
                    ann.setSource(ANNOTATION_URI_ASSOCIATION_CLASS);
                    ann.setEModelElement((EModelElement)reference);
                }
                ann.getReferences().clear();
                ann.getReferences().add((Object)associationClass);
            }
        }
    }

    public static void addQualifier(EStructuralFeature property, EStructuralFeature qualifier) {
        if (property != null) {
            EAnnotation ann = property.getEAnnotation(ANNOTATION_URI_QUALIFIERS);
            if (qualifier != null) {
                if (ann == null) {
                    ann = EcoreFactory.eINSTANCE.createEAnnotation();
                    ann.setSource(ANNOTATION_URI_QUALIFIERS);
                    ann.setEModelElement((EModelElement)property);
                }
                ann.getContents().add((Object)qualifier);
            }
        }
    }

    public static void addSignal(EClass eclass, EClass signal) {
        if (eclass != null) {
            EAnnotation ann = eclass.getEAnnotation(ANNOTATION_URI_SIGNALS);
            if (signal != null) {
                if (ann == null) {
                    ann = EcoreFactory.eINSTANCE.createEAnnotation();
                    ann.setSource(ANNOTATION_URI_SIGNALS);
                    ann.setEModelElement((EModelElement)eclass);
                }
                ann.getReferences().add((Object)signal);
            }
        }
    }
}

