/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.PublishServerJob;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;

public class RemoveModuleAction
extends Action {
    protected IServer server;
    protected IModule module;
    protected Shell shell;

    public RemoveModuleAction(Shell shell, IServer server, IModule module) {
        super(Messages.actionRemove);
        this.shell = shell;
        this.server = server;
        this.module = module;
    }

    public void run() {
        if (MessageDialog.openConfirm((Shell)this.shell, (String)Messages.defaultDialogTitle, (String)Messages.dialogRemoveModuleConfirm)) {
            try {
                IServerWorkingCopy wc = this.server.createWorkingCopy();
                wc.modifyModules(null, new IModule[]{this.module}, null);
                this.server = wc.save(true, null);
                if (this.server.getServerState() != 4 && ((Server)this.server).getAutoPublishSetting() != 1) {
                    PublishServerJob publishJob = new PublishServerJob(this.server);
                    publishJob.schedule();
                }
            }
            catch (Exception e) {
                Trace.trace((byte)2, "Could not remove module", e);
            }
        }
    }
}

