/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.optional.sitraka.CovBase;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;

public class CovMerge
extends CovBase {
    private File tofile = null;
    private Vector filesets = new Vector();
    private boolean verbose;

    public void setTofile(File value) {
        this.tofile = value;
    }

    public void setVerbose(boolean flag) {
        this.verbose = flag;
    }

    public void addFileset(FileSet fs) {
        this.filesets.addElement(fs);
    }

    public void execute() throws BuildException {
        this.checkOptions();
        File paramfile = this.createParamFile();
        try {
            try {
                Commandline cmdl = new Commandline();
                cmdl.setExecutable(this.findExecutable("jpcovmerge"));
                if (this.verbose) {
                    cmdl.createArgument().setValue("-v");
                }
                cmdl.createArgument().setValue(this.getParamFileArgument() + paramfile.getAbsolutePath());
                if (this.isJProbe4Plus()) {
                    cmdl.createArgument().setValue(this.tofile.getPath());
                }
                LogStreamHandler handler = new LogStreamHandler((Task)this, 2, 1);
                Execute exec = new Execute((ExecuteStreamHandler)handler);
                this.log(cmdl.describeCommand(), 3);
                exec.setCommandline(cmdl.getCommandline());
                int exitValue = exec.execute();
                if (Execute.isFailure((int)exitValue)) {
                    throw new BuildException("JProbe Coverage Merging failed (" + exitValue + ")");
                }
                Object var7_7 = null;
                paramfile.delete();
            }
            catch (IOException e) {
                throw new BuildException("Failed to run JProbe Coverage Merge: " + e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            paramfile.delete();
            throw throwable;
        }
    }

    protected void checkOptions() throws BuildException {
        if (this.tofile == null) {
            throw new BuildException("'tofile' attribute must be set.");
        }
        if (this.getHome() == null || !this.getHome().isDirectory()) {
            throw new BuildException("Invalid home directory. Must point to JProbe home directory");
        }
        File jar = this.findCoverageJar();
        if (!jar.exists()) {
            throw new BuildException("Cannot find Coverage directory: " + this.getHome());
        }
    }

    protected File[] getSnapshots() {
        Vector<File> v = new Vector<File>();
        int size = this.filesets.size();
        int i = 0;
        while (i < size) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            ds.scan();
            String[] f = ds.getIncludedFiles();
            int j = 0;
            while (j < f.length) {
                String pathname = f[j];
                File file = new File(ds.getBasedir(), pathname);
                file = this.getProject().resolveFile(file.getPath());
                v.addElement(file);
                ++j;
            }
            ++i;
        }
        Object[] files = new File[v.size()];
        v.copyInto(files);
        return files;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File createParamFile() throws BuildException {
        File[] snapshots = this.getSnapshots();
        File file = this.createTempFile("jpcovm");
        file.deleteOnExit();
        FileWriter fw = null;
        try {
            try {
                fw = new FileWriter(file);
                PrintWriter pw = new PrintWriter(fw);
                int i = 0;
                while (true) {
                    if (i >= snapshots.length) {
                        if (!this.isJProbe4Plus()) {
                            pw.println(this.getProject().resolveFile(this.tofile.getPath()));
                        }
                        pw.flush();
                        break;
                    }
                    pw.println(snapshots[i].getAbsolutePath());
                    ++i;
                }
            }
            catch (IOException e) {
                throw new BuildException("I/O error while writing to " + file, (Throwable)e);
            }
            Object var7_7 = null;
            if (fw == null) return file;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (fw == null) throw throwable;
            try {
                fw.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        fw.close();
        return file;
    }
}

