/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObjectListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.db.internal.Catalog;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.db.internal.Database;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DTPDatabaseWrapper
extends Database {
    final ConnectionProfile profile;
    final org.eclipse.datatools.modelbase.sql.schema.Database dtpDatabase;
    private ICatalogObjectListener databaseListener;
    private Set<Catalog> catalogs;
    private Set<Schema> schemata;

    DTPDatabaseWrapper(ConnectionProfile profile, org.eclipse.datatools.modelbase.sql.schema.Database dtpDatabase) {
        this.dtpDatabase = dtpDatabase;
        this.profile = profile;
        this.initialize();
    }

    private void initialize() {
        if (this.connectionIsOnline()) {
            this.databaseListener = this.buildDatabaseListener();
            this.addCatalogObjectListener((ICatalogObject)this.dtpDatabase, this.databaseListener);
        }
    }

    @Override
    protected boolean connectionIsOnline() {
        return this.profile.isConnected();
    }

    private ICatalogObjectListener buildDatabaseListener() {
        return new ICatalogObjectListener(){

            public void notifyChanged(ICatalogObject database, int eventType) {
                if (database == DTPDatabaseWrapper.this.dtpDatabase) {
                    DTPDatabaseWrapper.this.refresh();
                    DTPDatabaseWrapper.this.profile.databaseChanged(DTPDatabaseWrapper.this, eventType);
                }
            }
        };
    }

    @Override
    void refresh() {
        this.disposeSchemata();
        this.disposeCatalogs();
        this.schemata = null;
        this.catalogs = null;
    }

    @Override
    void catalogChanged(Catalog catalog, int eventType) {
        this.profile.catalogChanged(catalog, this, eventType);
    }

    @Override
    void schemaChanged(Schema schema, int eventType) {
        this.profile.schemaChanged(schema, this, eventType);
    }

    @Override
    void tableChanged(Table table, Schema schema, int eventType) {
        this.profile.tableChanged(table, schema, this, eventType);
    }

    @Override
    protected void dispose() {
        this.removeCatalogObjectListener((ICatalogObject)this.dtpDatabase, this.databaseListener);
        this.disposeSchemata();
        this.disposeCatalogs();
    }

    private void disposeSchemata() {
        if (this.schemata != null) {
            Iterator<Schema> stream = this.schemata();
            while (stream.hasNext()) {
                stream.next().dispose();
            }
        }
    }

    private void disposeCatalogs() {
        if (this.catalogs != null) {
            Iterator<Catalog> stream = this.catalogs();
            while (stream.hasNext()) {
                stream.next().dispose();
            }
        }
    }

    @Override
    public String getName() {
        return this.dtpDatabase.getName();
    }

    @Override
    public String getVendor() {
        return this.dtpDatabase.getVendor();
    }

    @Override
    public String getVersion() {
        return this.dtpDatabase.getVersion();
    }

    @Override
    synchronized Set<Schema> getSchemata() {
        if (this.schemata == null) {
            this.schemata = this.buildSchemata();
        }
        return this.schemata;
    }

    private EList<org.eclipse.datatools.modelbase.sql.schema.Schema> dtpSchemata() {
        return this.dtpDatabase.getSchemas();
    }

    private Set<Schema> buildSchemata() {
        Set<Schema> result;
        if (this.supportsCatalogs()) {
            result = this.getSchemataForCatalogNamed(this.profile.getCatalogName());
        } else {
            EList<org.eclipse.datatools.modelbase.sql.schema.Schema> dtpSchemata = this.dtpSchemata();
            result = new HashSet<Schema>(dtpSchemata.size());
            for (org.eclipse.datatools.modelbase.sql.schema.Schema dtpSchema : dtpSchemata) {
                result.add(this.wrap(dtpSchema));
            }
        }
        return result;
    }

    @Override
    public boolean supportsCatalogs() {
        EList<org.eclipse.datatools.modelbase.sql.schema.Schema> dtpSchemata = this.dtpSchemata();
        return dtpSchemata == null || dtpSchemata.size() == 0;
    }

    private EList<org.eclipse.datatools.modelbase.sql.schema.Catalog> dtpCatalogs() {
        return this.dtpDatabase.getCatalogs();
    }

    @Override
    public String getDefaultCatalogName() {
        if (!this.supportsCatalogs()) {
            return "";
        }
        String userName = this.profile.getUserName();
        for (org.eclipse.datatools.modelbase.sql.schema.Catalog dtpCatalog : this.dtpCatalogs()) {
            if (dtpCatalog.getName().length() == 0) {
                return "";
            }
            if (dtpCatalog.getName().equals(userName)) {
                return userName;
            }
            if (!dtpCatalog.getName().equals(this.getName())) continue;
            return this.getName();
        }
        throw new NoSuchElementException();
    }

    @Override
    synchronized Set<Catalog> getCatalogs() {
        if (this.catalogs == null) {
            this.catalogs = this.buildCatalogs();
        }
        return this.catalogs;
    }

    private Set<Catalog> buildCatalogs() {
        EList<org.eclipse.datatools.modelbase.sql.schema.Catalog> dtpCatalogs = this.dtpCatalogs();
        if (dtpCatalogs == null) {
            return Collections.emptySet();
        }
        HashSet<Catalog> result = new HashSet<Catalog>(dtpCatalogs.size());
        for (org.eclipse.datatools.modelbase.sql.schema.Catalog dtpCatalog : dtpCatalogs) {
            result.add(this.wrap(dtpCatalog));
        }
        return result;
    }

    private Set<Schema> getSchemataForCatalogNamed(String catalogName) {
        Catalog catalog = this.catalogNamed(catalogName);
        return catalog != null ? catalog.buildSchemata() : Collections.emptySet();
    }
}

