/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.TransactionImpl;
import org.eclipse.emf.transaction.impl.TransactionValidator;
import org.eclipse.emf.transaction.internal.EMFTransactionPlugin;
import org.eclipse.emf.transaction.internal.Tracing;
import org.eclipse.emf.transaction.internal.l10n.Messages;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.IValidator;
import org.eclipse.emf.validation.service.ModelValidationService;

public class ReadWriteValidatorImpl
implements TransactionValidator {
    static final byte VALIDATION = 1;
    static final byte PRECOMMIT = 2;
    static final byte POSTCOMMIT = 4;
    private NotificationTree tree = null;
    private NotificationTree transactionToPrecommit = null;
    private final Map txToNode = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void add(InternalTransaction transaction) {
        byte notificationMask = ReadWriteValidatorImpl.computeNotificationMask(transaction);
        if (notificationMask > 0) {
            NotificationTree parent = this.findTree(transaction.getParent());
            NotificationTree newTree = null;
            if (transaction.getParent() == null) {
                newTree = this.tree = new NotificationTree(transaction, notificationMask);
            } else if (parent != null) {
                newTree = parent.addChild(transaction, notificationMask);
            }
            if (newTree != null) {
                this.txToNode.put(transaction, newTree);
                if (this.transactionToPrecommit == null && !transaction.isReadOnly()) {
                    this.transactionToPrecommit = newTree;
                }
            }
        }
    }

    public void remove(InternalTransaction transaction) {
        NotificationTree node = this.findTree(transaction);
        if (node != null) {
            if (transaction.isRollingBack()) {
                node.setRolledBack();
            } else {
                this.txToNode.remove(transaction);
                node.detachTransaction();
            }
        }
    }

    public synchronized List getNotificationsForValidation(Transaction tx) {
        NotificationTree nested;
        List result = null;
        if (this.tree != null && (nested = this.findTree(tx)) != null) {
            result = nested.collectNotifications((byte)1);
        }
        return result;
    }

    public synchronized List getNotificationsForPrecommit(Transaction tx) {
        List result = null;
        if (this.transactionToPrecommit != null && this.transactionToPrecommit == this.findTree(tx)) {
            result = this.transactionToPrecommit.collectNotifications((byte)2);
            this.transactionToPrecommit = null;
        }
        return result;
    }

    public synchronized List getNotificationsForPostcommit(Transaction tx) {
        NotificationTree nested;
        List result = null;
        if (this.tree != null && (nested = this.findTree(tx)) != null) {
            result = nested.collectNotifications((byte)4);
        }
        return result;
    }

    private NotificationTree findTree(Transaction tx) {
        NotificationTree result = null;
        if (this.tree != null) {
            result = (NotificationTree)this.txToNode.get(tx);
        }
        return result;
    }

    public IStatus validate(Transaction tx) {
        IStatus result;
        try {
            IValidator validator = this.createValidator();
            result = validator.validate((Collection)this.getNotificationsForValidation(tx));
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.ReadWriteValidatorImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Tracing.catching(clazz, "validate", e);
            result = new Status(4, EMFTransactionPlugin.getPluginId(), 30, Messages.validationFailure, (Throwable)e);
        }
        return result;
    }

    protected IValidator createValidator() {
        return ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
    }

    public void dispose() {
        this.tree = null;
        this.txToNode.clear();
        this.transactionToPrecommit = null;
    }

    private static byte computeNotificationMask(Transaction transaction) {
        byte result = 0;
        if (TransactionImpl.isNotificationEnabled(transaction)) {
            result = (byte)(result | 4);
        }
        if (TransactionImpl.isTriggerEnabled(transaction)) {
            result = (byte)(result | 2);
        }
        if (TransactionImpl.isValidationEnabled(transaction)) {
            result = (byte)(result | 1);
        }
        return result;
    }

    private static class NotificationTree {
        private final List children = new BasicEList.FastCompare();
        private int parentNotificationCount;
        private InternalTransaction transaction;
        private List notifications;
        private final byte notificationMask;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.ReadWriteValidatorImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        NotificationTree(InternalTransaction transaction, byte notificationMask) {
            if (!$assertionsDisabled && notificationMask <= 0) {
                throw new AssertionError((Object)"transaction must be collecting notifications");
            }
            this.transaction = transaction;
            InternalTransaction parent = (InternalTransaction)transaction.getParent();
            this.parentNotificationCount = parent == null ? 0 : parent.getNotifications().size();
            this.notificationMask = notificationMask;
        }

        NotificationTree addChild(InternalTransaction child, byte notificationMask) {
            NotificationTree result = new NotificationTree(child, notificationMask);
            this.children.add(result);
            return result;
        }

        List getChildren() {
            return this.children;
        }

        List collectNotifications(byte purpose) {
            ArrayList result;
            if ((this.notificationMask & purpose) == purpose) {
                result = new ArrayList();
                this.collectNotifications(result, purpose);
            } else {
                result = Collections.EMPTY_LIST;
            }
            return result;
        }

        private void collectNotifications(List notifications, byte purpose) {
            if ((this.notificationMask & purpose) == purpose) {
                int lastIndex = 0;
                List parentNotifications = this.getNotifications();
                Iterator iter = this.children.iterator();
                while (iter.hasNext()) {
                    NotificationTree next = (NotificationTree)iter.next();
                    notifications.addAll(parentNotifications.subList(lastIndex, next.parentNotificationCount));
                    lastIndex = next.parentNotificationCount;
                    next.collectNotifications(notifications, purpose);
                }
                notifications.addAll(parentNotifications.subList(lastIndex, parentNotifications.size()));
            }
        }

        void setRolledBack() {
            Iterator children = this.getChildren().iterator();
            List rollbackNotifications = this.transaction.getNotifications();
            Iterator iter = rollbackNotifications.iterator();
            this.notifications = new BasicEList.FastCompare();
            int i = 0;
            while (children.hasNext()) {
                NotificationTree child = (NotificationTree)children.next();
                int parentNotificationCount = child.parentNotificationCount;
                while (i < parentNotificationCount && iter.hasNext()) {
                    Notification next = (Notification)iter.next();
                    if (!this.isUndoableObjectChange(next)) {
                        this.notifications.add(next);
                    }
                    ++i;
                }
                child.parentNotificationCount = this.notifications.size();
            }
            while (iter.hasNext()) {
                Notification next = (Notification)iter.next();
                if (this.isUndoableObjectChange(next)) continue;
                this.notifications.add(next);
            }
        }

        private boolean isUndoableObjectChange(Notification notification) {
            block7: {
                block8: {
                    if (notification.getNotifier() instanceof EObject) break block7;
                    if (!(notification.getNotifier() instanceof Resource)) break block8;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.emf.ecore.resource.Resource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (notification.getFeatureID((Class)clazz) == 2) break block7;
                }
                return false;
            }
            return true;
        }

        List getNotifications() {
            return this.notifications != null ? this.notifications : this.transaction.getNotifications();
        }

        void detachTransaction() {
            if (this.notifications == null) {
                this.notifications = this.transaction.getNotifications();
            }
            this.transaction = null;
        }
    }
}

