/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectValidator;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class JavaFacetValidator
implements IFacetedProjectValidator {
    public static final String MARKER_ID = "org.eclipse.jst.common.frameworks.javaVersionMismatch";
    public static final String ATTR_FACET_VERSION = "facetVersion";
    public static final String ATTR_COMPILER_LEVEL = "compilerLevel";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void validate(IFacetedProject fproj) throws CoreException {
        String level = JavaFacetUtils.getCompilerLevel(fproj.getProject());
        IProjectFacetVersion fv = fproj.getInstalledVersion(JavaFacetUtils.JAVA_FACET);
        if (JavaFacetUtils.compilerLevelToFacet(level) != fv) {
            IMarker marker = fproj.createErrorMarker(MARKER_ID, Resources.versionsDontMatch);
            marker.setAttribute(ATTR_FACET_VERSION, (Object)fv.getVersionString());
            marker.setAttribute(ATTR_COMPILER_LEVEL, (Object)level);
        }
    }

    private static final class Resources
    extends NLS {
        public static String versionsDontMatch;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.common.project.facet.JavaFacetValidator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.jst.common.project.facet.JavaFacetValidator$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }
    }
}

