/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.wst.common.ui.properties.internal.provisional.ISection;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetPage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class GeneralViewSection
implements ISection,
ISelectionChangedListener {
    private PageBook pageBook = null;
    private Map mapPartToRec = new HashMap();
    private PageRec defaultPageRec;
    private PageRec activeRec;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        FillLayout layout = new FillLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 4;
        parent.setLayout((Layout)layout);
        this.pageBook = new PageBook(parent, 2048);
        this.createDefaultPage();
        if (this.defaultPageRec != null) {
            this.showPageRec(this.defaultPageRec);
        }
    }

    protected void showPageRec(PageRec pageRec) {
        if (this.activeRec == pageRec) {
            return;
        }
        if (this.activeRec != null && pageRec != null && this.activeRec.page == pageRec.page) {
            this.activeRec = pageRec;
            return;
        }
        this.activeRec = pageRec;
        Control pageControl = this.activeRec.page.getControl();
        if (pageControl != null && !pageControl.isDisposed()) {
            this.pageBook.showPage(pageControl);
        }
    }

    private PageRec createPage(IWorkbenchPart part) {
        PageRec rec = this.doCreatePage(part);
        if (rec != null) {
            this.mapPartToRec.put(part, rec);
        }
        return rec;
    }

    protected PageRec doCreatePage(IWorkbenchPart part) {
        if (part instanceof StructuredTextEditor) {
            return null;
        }
        Object obj = part.getAdapter(IPropertySheetPage.class);
        if (obj instanceof IPropertySheetPage) {
            IPropertySheetPage page = (IPropertySheetPage)obj;
            page.createControl((Composite)this.getPageBook());
            return new PageRec(part, page);
        }
        return null;
    }

    private void createDefaultPage() {
        PropertySheetPage defaultPage = new PropertySheetPage();
        defaultPage.createControl((Composite)this.getPageBook());
        this.defaultPageRec = new PageRec(null, (IPropertySheetPage)defaultPage);
    }

    protected PageBook getPageBook() {
        return this.pageBook;
    }

    protected PageRec getPageRec(Object part) {
        return (PageRec)this.mapPartToRec.get(part);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        IEditorPart subPage;
        if (part instanceof MultiPageEditorPart && (subPage = (IEditorPart)part.getAdapter(IEditorPart.class)) != null) {
            PageRec rec = this.getPageRec(subPage);
            if (rec == null) {
                rec = this.createPage((IWorkbenchPart)subPage);
            }
            if (rec != null) {
                this.showPageRec(rec);
            } else {
                this.showPageRec(this.defaultPageRec);
            }
        }
        this.activeRec.page.selectionChanged(part, selection);
    }

    public void aboutToBeShown() {
        this.refresh();
    }

    public void aboutToBeHidden() {
    }

    public void dispose() {
        this.activeRec = null;
        if (this.defaultPageRec != null) {
            this.defaultPageRec.page.dispose();
            this.defaultPageRec = null;
        }
        Map clone = (Map)((HashMap)this.mapPartToRec).clone();
        for (PageRec rec : clone.values()) {
            this.removePage(rec);
        }
    }

    private void removePage(PageRec rec) {
        this.mapPartToRec.remove(rec.part);
        Control control = rec.page.getControl();
        if (control != null && !control.isDisposed()) {
            control.dispose();
        }
        this.doDestroyPage(rec.part, rec);
    }

    protected void doDestroyPage(IWorkbenchPart part, PageRec rec) {
        IPropertySheetPage page = rec.page;
        page.dispose();
        rec.dispose();
    }

    public int getMinimumHeight() {
        return -1;
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void refresh() {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setInput((IWorkbenchPart)event.getSource(), event.getSelection());
    }

    protected static class PageRec {
        public IWorkbenchPart part;
        public IPropertySheetPage page;

        public PageRec(IWorkbenchPart part, IPropertySheetPage page) {
            this.part = part;
            this.page = page;
        }

        public void dispose() {
            this.part = null;
            this.page = null;
        }
    }
}

