/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jem.internal.beaninfo.core.BeaninfoEntry;
import org.eclipse.jem.internal.beaninfo.core.SearchpathEntry;
import org.eclipse.jem.internal.beaninfo.ui.BPBeaninfoListElement;
import org.eclipse.jem.internal.beaninfo.ui.BPSearchListElement;
import org.eclipse.jem.internal.beaninfo.ui.BeanInfoUIMessages;
import org.eclipse.jem.internal.beaninfo.ui.BeaninfoPathsBlock;
import org.eclipse.jem.internal.beaninfo.ui.PackageOnlyContentProvider;
import org.eclipse.jem.internal.beaninfo.ui.PackagesWorkbookPage;
import org.eclipse.jem.internal.beaninfo.ui.SearchPathListLabelProvider;
import org.eclipse.jem.internal.beaninfo.ui.TypedViewerFilter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class BeaninfoEntrySearchpathDialog
extends Dialog {
    protected BPBeaninfoListElement infoElement;
    protected IJavaProject jProject;
    private Composite top;
    private Table table;
    private TableViewer tableViewer;
    private Label label;
    private Composite buttonsBar;
    private Button upbutton;
    private Button downButton;
    private Button choosePackagesButton;
    private Button removeButton;
    private List tableElements;
    private boolean enabled = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public BeaninfoEntrySearchpathDialog(Shell parentShell, BPBeaninfoListElement infoElement, IJavaProject jProject) {
        super(parentShell);
        this.infoElement = infoElement;
        this.jProject = jProject;
        this.tableElements = new ArrayList();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MessageFormat.format(BeanInfoUIMessages.SearchPathDialog_ModifySearchPaths, this.infoElement.getEntry().getPath().toString()));
    }

    protected Control createDialogArea(Composite parent) {
        this.top = new Composite(parent, 0);
        this.top.setLayoutData((Object)new GridData(1808));
        this.top.setLayout((Layout)new GridLayout(2, false));
        this.label = new Label(this.top, 0);
        this.label.setText(BeanInfoUIMessages.SearchPathDialog_Desc_Label);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.label.setLayoutData((Object)gd);
        this.createTable();
        this.createButtonsBar();
        this.updatePackagesList();
        this.updateButtons();
        return this.top;
    }

    private void createTable() {
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.grabExcessVerticalSpace = true;
        gridData1.verticalAlignment = 4;
        this.table = new Table(this.top, 2818);
        this.table.setLayoutData((Object)gridData1);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BeaninfoEntrySearchpathDialog.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new SearchPathListLabelProvider(this.jProject));
        this.tableViewer.setInput((Object)this.tableElements);
    }

    private void createButtonsBar() {
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginLeft = 3;
        rowLayout.fill = true;
        GridData gridData2 = new GridData();
        gridData2.grabExcessVerticalSpace = true;
        gridData2.verticalAlignment = 4;
        gridData2.horizontalAlignment = 1;
        this.buttonsBar = new Composite(this.top, 0);
        this.buttonsBar.setLayoutData((Object)gridData2);
        this.buttonsBar.setLayout((Layout)rowLayout);
        this.upbutton = new Button(this.buttonsBar, 0);
        this.upbutton.setText(BeanInfoUIMessages.BeaninfoPathsBlock_UI__searchpath_up_button);
        this.upbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List selected = BeaninfoPathsBlock.getSelectedList(BeaninfoEntrySearchpathDialog.this.tableViewer.getSelection());
                Iterator selItr = selected.iterator();
                while (selItr.hasNext()) {
                    Object element = selItr.next();
                    int oldIndex = BeaninfoEntrySearchpathDialog.this.tableElements.indexOf(element);
                    if (oldIndex <= 0) continue;
                    BeaninfoEntrySearchpathDialog.this.tableElements.remove(element);
                    BeaninfoEntrySearchpathDialog.this.tableElements.add(--oldIndex, element);
                }
                BeaninfoEntrySearchpathDialog.this.tableViewer.refresh();
                BeaninfoEntrySearchpathDialog.this.pageChanged();
            }
        });
        this.downButton = new Button(this.buttonsBar, 0);
        this.downButton.setText(BeanInfoUIMessages.BeaninfoPathsBlock_UI__searchpath_down_button);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List selected = BeaninfoPathsBlock.getSelectedList(BeaninfoEntrySearchpathDialog.this.tableViewer.getSelection());
                Iterator selItr = selected.iterator();
                while (selItr.hasNext()) {
                    Object element = selItr.next();
                    int oldIndex = BeaninfoEntrySearchpathDialog.this.tableElements.indexOf(element);
                    if (oldIndex >= BeaninfoEntrySearchpathDialog.this.tableElements.size() - 1) continue;
                    BeaninfoEntrySearchpathDialog.this.tableElements.remove(element);
                    BeaninfoEntrySearchpathDialog.this.tableElements.add(++oldIndex, element);
                }
                BeaninfoEntrySearchpathDialog.this.tableViewer.refresh();
                BeaninfoEntrySearchpathDialog.this.pageChanged();
            }
        });
        new Label(this.buttonsBar, 0);
        this.choosePackagesButton = new Button(this.buttonsBar, 0);
        this.choosePackagesButton.setText(BeanInfoUIMessages.SearchPathDialog_ChoosePackages);
        this.choosePackagesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List elementsToAdd = BeaninfoEntrySearchpathDialog.this.choosePackages();
                if (elementsToAdd != null && !elementsToAdd.isEmpty()) {
                    BeaninfoEntrySearchpathDialog.this.tableElements.addAll(elementsToAdd);
                    BeaninfoEntrySearchpathDialog.this.tableViewer.refresh();
                    BeaninfoEntrySearchpathDialog.this.table.getDisplay().asyncExec(new Runnable(this, elementsToAdd){
                        final /* synthetic */ 4 this$1;
                        private final /* synthetic */ List val$elementsToAdd;
                        {
                            this.this$1 = var1_1;
                            this.val$elementsToAdd = list;
                        }

                        public void run() {
                            BeaninfoEntrySearchpathDialog.access$0(4.access$0(this.this$1)).setSelection((ISelection)new StructuredSelection(this.val$elementsToAdd));
                        }
                    });
                }
            }

            static /* synthetic */ BeaninfoEntrySearchpathDialog access$0(4 var0) {
                return var0.BeaninfoEntrySearchpathDialog.this;
            }
        });
        new Label(this.buttonsBar, 0);
        this.removeButton = new Button(this.buttonsBar, 0);
        this.removeButton.setText(BeanInfoUIMessages.SearchPathDialog_Remove);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List selected = BeaninfoPathsBlock.getSelectedList(BeaninfoEntrySearchpathDialog.this.tableViewer.getSelection());
                BeaninfoEntrySearchpathDialog.this.tableElements.removeAll(selected);
                BeaninfoEntrySearchpathDialog.this.tableViewer.refresh();
                BeaninfoEntrySearchpathDialog.this.pageChanged();
            }
        });
    }

    protected void pageChanged() {
    }

    protected void updateButtons() {
        if (this.top != null && !this.top.isDisposed()) {
            this.upbutton.setEnabled(this.enabled && this.canMoveUp());
            this.downButton.setEnabled(this.enabled && this.canMoveDown());
            this.removeButton.setEnabled(this.enabled && !this.tableViewer.getSelection().isEmpty());
            this.choosePackagesButton.setEnabled(this.enabled);
        }
    }

    private boolean canMoveDown() {
        int[] indc = this.table.getSelectionIndices();
        int k = this.tableElements.size() - 1;
        int i = indc.length - 1;
        while (i >= 0) {
            if (indc[i] != k) {
                return true;
            }
            --i;
            --k;
        }
        return false;
    }

    private boolean canMoveUp() {
        int[] indc = this.table.getSelectionIndices();
        int i = 0;
        while (i < indc.length) {
            if (indc[i] != i) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void updatePackagesList() {
        if (this.infoElement.getEntry().getKind() == 100) {
            this.label.setText(BeanInfoUIMessages.SearchPathDialog_NotEditable_INFO_);
            this.updateEnabledState(false);
            return;
        }
        this.tableElements.clear();
        this.tableElements.addAll(Arrays.asList(this.infoElement.getSearchpaths()));
        this.tableViewer.refresh();
    }

    private void updateEnabledState(boolean b) {
        this.enabled = b;
        if (this.top != null && !this.top.isDisposed()) {
            this.label.setEnabled(this.enabled);
            this.table.setEnabled(this.enabled);
            this.updateButtons();
        }
    }

    protected void okPressed() {
        if (this.table.isEnabled()) {
            this.infoElement.setSearchpaths(this.tableElements.toArray(new BPSearchListElement[this.tableElements.size()]));
        }
        super.okPressed();
    }

    private List choosePackages() {
        IPackageFragmentRoot[] roots = this.getBeaninfoRoots();
        ArrayList<String> newPackageNames = new ArrayList<String>();
        if (roots != null) {
            PackagesWorkbookPage.ChoosePackagesSelectionValidator validator = new PackagesWorkbookPage.ChoosePackagesSelectionValidator();
            Class[] classArray = new Class[2];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IPackageFragmentRoot");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.IPackageFragment");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            Class[] acceptedClasses = classArray;
            Object[] rejectedFragments = this.getFilteredExistingEntries(roots);
            TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedFragments){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (super.select(viewer, parentElement, element)) {
                        if (element instanceof IPackageFragment) {
                            IPackageFragment pkg = (IPackageFragment)element;
                            try {
                                return pkg.hasChildren();
                            }
                            catch (JavaModelException javaModelException) {
                                return false;
                            }
                        }
                        return true;
                    }
                    return false;
                }
            };
            PackageOnlyContentProvider provider = new PackageOnlyContentProvider();
            JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
            dialog.setTitle(BeanInfoUIMessages.BeaninfoPathsBlock_UI__addsearchpath_title);
            dialog.setValidator((ISelectionStatusValidator)validator);
            dialog.setMessage(BeanInfoUIMessages.BeaninfoPathsBlock_UI__addsearchpath_description);
            dialog.addFilter((ViewerFilter)filter);
            dialog.setInput(Arrays.asList(this.getBeaninfoRoots()));
            if (dialog.open() == 0) {
                Object[] elements = dialog.getResult();
                int i = 0;
                while (i < elements.length) {
                    newPackageNames.add(((IPackageFragment)elements[i]).getElementName());
                    ++i;
                }
            }
        } else {
            final List existingPackagenames = this.getFilteredExistingEntries();
            IInputValidator validator = new IInputValidator(){

                public String isValid(String newText) {
                    if (existingPackagenames.contains(newText)) {
                        return BeanInfoUIMessages.SearchPathDialog_PackagePresent_INFO_;
                    }
                    IStatus status = JavaConventions.validatePackageName((String)newText);
                    return status.getSeverity() == 0 ? null : status.getMessage();
                }
            };
            InputDialog dialog = new InputDialog(this.getShell(), BeanInfoUIMessages.SearchPathDialog_InputDialog_Title, BeanInfoUIMessages.SearchPathDialog_InputDialog_Message, null, validator);
            if (dialog.open() == 0) {
                newPackageNames.add(dialog.getValue());
            }
        }
        if (newPackageNames.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<BPSearchListElement> newElements = new ArrayList<BPSearchListElement>(newPackageNames.size());
        int i = 0;
        while (i < newPackageNames.size()) {
            newElements.add(new BPSearchListElement(new SearchpathEntry((String)newPackageNames.get(i)), false, false, false));
            ++i;
        }
        return newElements;
    }

    protected IPackageFragmentRoot[] getBeaninfoRoots() {
        IPackageFragmentRoot[] roots = null;
        if (this.infoElement.getEntry().getKind() != 100) {
            IClasspathEntry resolved = JavaCore.getResolvedClasspathEntry((IClasspathEntry)((BeaninfoEntry)this.infoElement.getEntry()).getClasspathEntry());
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(resolved.getPath());
            if (res != null && res.exists()) {
                if (res instanceof IProject) {
                    IJavaProject jp = (IJavaProject)JavaCore.create((IResource)res);
                    try {
                        if (jp != null) {
                            roots = jp.getPackageFragmentRoots();
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                } else {
                    IProject containingProject = res.getProject();
                    IJavaProject jp = JavaCore.create((IProject)containingProject);
                    if (jp != null) {
                        try {
                            IPackageFragmentRoot root = jp.findPackageFragmentRoot(resolved.getPath());
                            if (root != null) {
                                roots = new IPackageFragmentRoot[]{root};
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                    }
                }
            }
        }
        return roots;
    }

    protected Object[] getFilteredExistingEntries(IPackageFragmentRoot[] roots) {
        List entries = this.tableElements;
        ArrayList fragments = new ArrayList(entries.size());
        Iterator itr = entries.iterator();
        while (itr.hasNext()) {
            BPSearchListElement elem = (BPSearchListElement)itr.next();
            fragments.addAll(this.getPackages(elem, roots));
        }
        return fragments.toArray();
    }

    protected List getFilteredExistingEntries() {
        List entries = this.tableElements;
        ArrayList<String> names = new ArrayList<String>(entries.size());
        Iterator itr = entries.iterator();
        while (itr.hasNext()) {
            BPSearchListElement elem = (BPSearchListElement)itr.next();
            names.add(((SearchpathEntry)elem.getEntry()).getPackage());
        }
        return names;
    }

    protected List getPackages(BPSearchListElement element, IPackageFragmentRoot[] roots) {
        String packageName = ((SearchpathEntry)element.getEntry()).getPackage();
        if (packageName == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            ArrayList<IJavaElement> packages = new ArrayList<IJavaElement>(10);
            int i = 0;
            while (i < roots.length) {
                IJavaElement[] pfs = roots[i].getChildren();
                int j = 0;
                while (j < pfs.length) {
                    if (pfs[j].getElementType() == 4 && pfs[j].getElementName().equals(packageName)) {
                        packages.add(pfs[j]);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            return packages;
        }
        catch (JavaModelException javaModelException) {
            return Collections.EMPTY_LIST;
        }
    }
}

