/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.guiutils;

import org.eclipse.jst.jsf.common.ui.internal.guiutils.SWTUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class CollapsableSection {
    protected FormToolkit _toolkit;
    protected Section _section;
    protected ScrolledComposite _scomp;
    protected String _title;
    protected int _expansionStyle;

    public CollapsableSection(FormToolkit toolkit, ScrolledComposite scomp, String title, boolean bCollapsed) {
        this._toolkit = toolkit;
        this._scomp = scomp;
        this._title = title;
        this._expansionStyle = 10;
        this._expansionStyle = bCollapsed ? (this._expansionStyle |= 0x20) : (this._expansionStyle |= 0x40);
    }

    public abstract void setCollapsableContent(Composite var1);

    public Control createControl(Composite parent, int horizontalSpan) {
        this._section = this._toolkit.createSection(parent, this._expansionStyle);
        this._section.clientVerticalSpacing = 5;
        this._section.setText(this._title);
        this._toolkit.createCompositeSeparator((Composite)this._section);
        this._section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent event) {
                SWTUtils.computeScrollArea(CollapsableSection.this._scomp, (Composite)CollapsableSection.this._scomp.getContent());
            }
        });
        Composite content = new Composite((Composite)this._section, 0);
        this.setCollapsableContent(content);
        this._section.setClient((Control)content);
        GridData gd = new GridData(768);
        gd.horizontalSpan = horizontalSpan;
        this._section.setLayoutData((Object)gd);
        return this._section;
    }

    public void setExpanded(boolean expanded) {
        if (this._section != null) {
            this._section.setExpanded(expanded);
            SWTUtils.computeScrollArea(this._scomp, (Composite)this._scomp.getContent());
        }
    }

    public Section getSection() {
        return this._section;
    }
}

